/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.GeneratorSettingsFlat;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import org.spigotmc.SpigotWorldConfig;

public class ChunkProviderFlat
extends ChunkGenerator {
    public static final Codec<ChunkProviderFlat> c = RecordCodecBuilder.create(instance -> instance.group((App)GeneratorSettingsFlat.a.fieldOf("settings").forGetter(ChunkProviderFlat::g)).apply((Applicative)instance, instance.stable(ChunkProviderFlat::new)));
    private final GeneratorSettingsFlat d;

    public ChunkProviderFlat(GeneratorSettingsFlat generatorsettingsflat) {
        this(generatorsettingsflat, new WorldChunkManagerHell(generatorsettingsflat.d()));
    }

    public ChunkProviderFlat(GeneratorSettingsFlat generatorsettingsflat, WorldChunkManager worldchunkmanager) {
        super(worldchunkmanager, SystemUtils.b(generatorsettingsflat::a));
        this.d = generatorsettingsflat;
    }

    @Override
    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2, SpigotWorldConfig conf) {
        Stream stream = this.d.c().map(HolderSet::a).orElseGet(() -> holderlookup.b().map(holder_c -> holder_c));
        return ChunkGeneratorStructureState.createForFlat(randomstate, i2, this.b, stream, conf);
    }

    @Override
    protected Codec<? extends ChunkGenerator> a() {
        return c;
    }

    public GeneratorSettingsFlat g() {
        return this.d;
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
    }

    @Override
    public int a(LevelHeightAccessor levelheightaccessor) {
        return levelheightaccessor.C_() + Math.min(levelheightaccessor.D_(), this.d.f().size());
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Executor executor, Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        List<IBlockData> list = this.d.f();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        HeightMap heightmap = ichunkaccess.a(HeightMap.Type.c);
        HeightMap heightmap1 = ichunkaccess.a(HeightMap.Type.a);
        int i2 = 0;
        while (i2 < Math.min(ichunkaccess.D_(), list.size())) {
            IBlockData iblockdata = list.get(i2);
            if (iblockdata != null) {
                int j2 = ichunkaccess.C_() + i2;
                int k2 = 0;
                while (k2 < 16) {
                    int l2 = 0;
                    while (l2 < 16) {
                        ichunkaccess.a(blockposition_mutableblockposition.d(k2, j2, l2), iblockdata, false);
                        heightmap.a(k2, j2, l2, iblockdata);
                        heightmap1.a(k2, j2, l2, iblockdata);
                        ++l2;
                    }
                    ++k2;
                }
            }
            ++i2;
        }
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    @Override
    public int a(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        List<IBlockData> list = this.d.f();
        int k2 = Math.min(list.size(), levelheightaccessor.aj()) - 1;
        while (k2 >= 0) {
            IBlockData iblockdata = list.get(k2);
            if (iblockdata != null && heightmap_type.e().test(iblockdata)) {
                return levelheightaccessor.C_() + k2 + 1;
            }
            --k2;
        }
        return levelheightaccessor.C_();
    }

    @Override
    public BlockColumn a(int i2, int j2, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return new BlockColumn(levelheightaccessor.C_(), (IBlockData[])this.d.f().stream().limit(levelheightaccessor.D_()).map(iblockdata -> iblockdata == null ? Blocks.a.n() : iblockdata).toArray(IBlockData[]::new));
    }

    @Override
    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long i2, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
    }

    @Override
    public int f() {
        return 0;
    }

    @Override
    public int d() {
        return 384;
    }

    @Override
    public int e() {
        return -63;
    }
}

