/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.DataBits;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.slf4j.Logger;

public class HeightMap {
    private static final Logger a = LogUtils.getLogger();
    static final Predicate<IBlockData> b = var0 -> !var0.i();
    static final Predicate<IBlockData> c = BlockBase.BlockData::d;
    private final DataBits d;
    private final Predicate<IBlockData> e;
    private final IChunkAccess f;

    public HeightMap(IChunkAccess var0, Type var1) {
        this.e = var1.e();
        this.f = var0;
        int var2 = MathHelper.e(var0.D_() + 1);
        this.d = new SimpleBitStorage(var2, 256);
    }

    public static void a(IChunkAccess var0, Set<Type> var1) {
        int var2 = var1.size();
        ObjectArrayList var3 = new ObjectArrayList(var2);
        ObjectListIterator var4 = var3.iterator();
        int var5 = var0.b() + 16;
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (int var7 = 0; var7 < 16; ++var7) {
            block1: for (int var8 = 0; var8 < 16; ++var8) {
                for (Type type : var1) {
                    var3.add((Object)var0.a(type));
                }
                for (int var9 = var5 - 1; var9 >= var0.C_(); --var9) {
                    var6.d(var7, var9, var8);
                    IBlockData iBlockData = var0.a_(var6);
                    if (iBlockData.a(Blocks.a)) continue;
                    while (var4.hasNext()) {
                        HeightMap var11 = (HeightMap)var4.next();
                        if (!var11.e.test(iBlockData)) continue;
                        var11.a(var7, var8, var9 + 1);
                        var4.remove();
                    }
                    if (var3.isEmpty()) continue block1;
                    var4.back(var2);
                }
            }
        }
    }

    public boolean a(int var0, int var1, int var2, IBlockData var3) {
        int var4 = this.a(var0, var2);
        if (var1 <= var4 - 2) {
            return false;
        }
        if (this.e.test(var3)) {
            if (var1 >= var4) {
                this.a(var0, var2, var1 + 1);
                return true;
            }
        } else if (var4 - 1 == var1) {
            BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
            for (int var6 = var1 - 1; var6 >= this.f.C_(); --var6) {
                var5.d(var0, var6, var2);
                if (!this.e.test(this.f.a_(var5))) continue;
                this.a(var0, var2, var6 + 1);
                return true;
            }
            this.a(var0, var2, this.f.C_());
            return true;
        }
        return false;
    }

    public int a(int var0, int var1) {
        return this.a(HeightMap.c(var0, var1));
    }

    public int b(int var0, int var1) {
        return this.a(HeightMap.c(var0, var1)) - 1;
    }

    private int a(int var0) {
        return this.d.a(var0) + this.f.C_();
    }

    private void a(int var0, int var1, int var2) {
        this.d.b(HeightMap.c(var0, var1), var2 - this.f.C_());
    }

    public void a(IChunkAccess var0, Type var1, long[] var2) {
        long[] var3 = this.d.a();
        if (var3.length == var2.length) {
            System.arraycopy(var2, 0, var3, 0, var2.length);
            return;
        }
        a.warn("Ignoring heightmap data for chunk " + var0.f() + ", size does not match; expected: " + var3.length + ", got: " + var2.length);
        HeightMap.a(var0, EnumSet.of(var1));
    }

    public long[] a() {
        return this.d.a();
    }

    private static int c(int var0, int var1) {
        return var0 + var1 * 16;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type("WORLD_SURFACE_WG", Use.a, b);
        public static final /* enum */ Type b = new Type("WORLD_SURFACE", Use.c, b);
        public static final /* enum */ Type c = new Type("OCEAN_FLOOR_WG", Use.a, c);
        public static final /* enum */ Type d = new Type("OCEAN_FLOOR", Use.b, c);
        public static final /* enum */ Type e = new Type("MOTION_BLOCKING", Use.c, var0 -> var0.d() || !var0.u().c());
        public static final /* enum */ Type f = new Type("MOTION_BLOCKING_NO_LEAVES", Use.b, var0 -> (var0.d() || !var0.u().c()) && !(var0.b() instanceof BlockLeaves));
        public static final Codec<Type> g;
        private final String h;
        private final Use i;
        private final Predicate<IBlockData> j;
        private static final /* synthetic */ Type[] k;

        public static Type[] values() {
            return (Type[])k.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, Use var3, Predicate var4) {
            this.h = var2;
            this.i = var3;
            this.j = var4;
        }

        public String a() {
            return this.h;
        }

        public boolean b() {
            return this.i == Use.c;
        }

        public boolean d() {
            return this.i != Use.a;
        }

        public Predicate<IBlockData> e() {
            return this.j;
        }

        @Override
        public String c() {
            return this.h;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{a, b, c, d, e, f};
        }

        static {
            k = Type.f();
            g = INamable.a(Type::values);
        }
    }

    public static final class Use
    extends Enum<Use> {
        public static final /* enum */ Use a = new Use();
        public static final /* enum */ Use b = new Use();
        public static final /* enum */ Use c = new Use();
        private static final /* synthetic */ Use[] d;

        public static Use[] values() {
            return (Use[])d.clone();
        }

        public static Use valueOf(String var0) {
            return Enum.valueOf(Use.class, var0);
        }

        private static /* synthetic */ Use[] a() {
            return new Use[]{a, b, c};
        }

        static {
            d = Use.a();
        }
    }
}

