/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;

public class RuinedPortalStructure
extends Structure {
    private static final String[] e = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] f = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private static final float g = 0.05f;
    private static final int h = 15;
    private final List<a> i;
    public static final Codec<RuinedPortalStructure> d = RecordCodecBuilder.create(var02 -> var02.group(RuinedPortalStructure.a(var02), (App)ExtraCodecs.a(net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure$a.a.listOf()).fieldOf("setups").forGetter(var0 -> var0.i)).apply((Applicative)var02, RuinedPortalStructure::new));

    public RuinedPortalStructure(Structure.c var0, List<a> var1) {
        super(var0);
        this.i = var1;
    }

    public RuinedPortalStructure(Structure.c var0, a var1) {
        this(var0, List.of(var1));
    }

    @Override
    public Optional<Structure.b> a(Structure.a var0) {
        RuinedPortalPiece.a var1 = new RuinedPortalPiece.a();
        SeededRandom var2 = var0.f();
        a var3 = null;
        if (this.i.size() > 1) {
            float var4 = 0.0f;
            for (a a2 : this.i) {
                var4 += a2.h();
            }
            float var5 = var2.i();
            for (a a3 : this.i) {
                if (!((var5 -= a3.h() / var4) < 0.0f)) continue;
                var3 = a3;
                break;
            }
        } else {
            var3 = this.i.get(0);
        }
        if (var3 == null) {
            throw new IllegalStateException();
        }
        a var4 = var3;
        var1.d = RuinedPortalStructure.a(var2, var4.b());
        var1.c = var4.c();
        var1.e = var4.d();
        var1.f = var4.e();
        var1.g = var4.g();
        MinecraftKey var5 = var2.i() < 0.05f ? new MinecraftKey(f[var2.a(f.length)]) : new MinecraftKey(e[var2.a(e.length)]);
        DefinedStructure definedStructure = var0.e().a(var5);
        EnumBlockRotation enumBlockRotation = SystemUtils.a(EnumBlockRotation.values(), (RandomSource)var2);
        EnumBlockMirror var8 = var2.i() < 0.5f ? EnumBlockMirror.a : EnumBlockMirror.c;
        BlockPosition var9 = new BlockPosition(definedStructure.a().u() / 2, 0, definedStructure.a().w() / 2);
        ChunkGenerator var102 = var0.b();
        LevelHeightAccessor var11 = var0.i();
        RandomState var12 = var0.d();
        BlockPosition var13 = var0.h().l();
        StructureBoundingBox var14 = definedStructure.a(var13, enumBlockRotation, var9, var8);
        BlockPosition var15 = var14.f();
        int var16 = var102.a(var15.u(), var15.w(), RuinedPortalPiece.a(var4.a()), var11, var12) - 1;
        int var17 = RuinedPortalStructure.a(var2, var102, var4.a(), var1.d, var16, var14.d(), var14, var11, var12);
        BlockPosition var18 = new BlockPosition(var13.u(), var17, var13.w());
        return Optional.of(new Structure.b(var18, var10 -> {
            if (var4.f()) {
                var1.b = RuinedPortalStructure.a(var18, var0.b().c().getNoiseBiome(QuartPos.a(var18.u()), QuartPos.a(var18.v()), QuartPos.a(var18.w()), var12.b()));
            }
            var10.a(new RuinedPortalPiece(var0.e(), var18, var4.a(), var1, var5, definedStructure, enumBlockRotation, var8, var9));
        }));
    }

    private static boolean a(SeededRandom var0, float var1) {
        if (var1 == 0.0f) {
            return false;
        }
        if (var1 == 1.0f) {
            return true;
        }
        return var0.i() < var1;
    }

    private static boolean a(BlockPosition var0, Holder<BiomeBase> var1) {
        return var1.a().b(var0);
    }

    private static int a(RandomSource var0, ChunkGenerator var1, RuinedPortalPiece.b var2, boolean var32, int var4, int var5, StructureBoundingBox var6, LevelHeightAccessor var7, RandomState var8) {
        int var14;
        int var10 = var7.C_() + 15;
        if (var2 == RuinedPortalPiece.b.f) {
            var9 = var32 ? MathHelper.b(var0, 32, 100) : (var0.i() < 0.5f ? MathHelper.b(var0, 27, 29) : MathHelper.b(var0, 29, 100));
        } else if (var2 == RuinedPortalPiece.b.d) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.a(var0, 70, var11);
        } else if (var2 == RuinedPortalPiece.b.e) {
            var11 = var4 - var5;
            var9 = RuinedPortalStructure.a(var0, var10, var11);
        } else {
            var9 = var2 == RuinedPortalPiece.b.b ? var4 - var5 + MathHelper.b(var0, 2, 8) : var4;
        }
        ImmutableList var11 = ImmutableList.of((Object)new BlockPosition(var6.g(), 0, var6.i()), (Object)new BlockPosition(var6.j(), 0, var6.i()), (Object)new BlockPosition(var6.g(), 0, var6.l()), (Object)new BlockPosition(var6.j(), 0, var6.l()));
        List var12 = var11.stream().map(var3 -> var1.a(var3.u(), var3.w(), var7, var8)).collect(Collectors.toList());
        HeightMap.Type var13 = var2 == RuinedPortalPiece.b.c ? HeightMap.Type.c : HeightMap.Type.a;
        block0: for (var14 = var9; var14 > var10; --var14) {
            int var15 = 0;
            for (BlockColumn var17 : var12) {
                IBlockData var18 = var17.a(var14);
                if (!var13.e().test(var18) || ++var15 != 3) continue;
                break block0;
            }
        }
        return var14;
    }

    private static int a(RandomSource var0, int var1, int var2) {
        if (var1 < var2) {
            return MathHelper.b(var0, var1, var2);
        }
        return var2;
    }

    @Override
    public StructureType<?> e() {
        return StructureType.l;
    }

    public static final class a
    extends Record {
        private final RuinedPortalPiece.b b;
        private final float c;
        private final float d;
        private final boolean e;
        private final boolean f;
        private final boolean g;
        private final boolean h;
        private final float i;
        public static final Codec<a> a = RecordCodecBuilder.create(var0 -> var0.group((App)RuinedPortalPiece.b.g.fieldOf("placement").forGetter(a::a), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(a::b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(a::c), (App)Codec.BOOL.fieldOf("overgrown").forGetter(a::d), (App)Codec.BOOL.fieldOf("vines").forGetter(a::e), (App)Codec.BOOL.fieldOf("can_be_cold").forGetter(a::f), (App)Codec.BOOL.fieldOf("replace_with_blackstone").forGetter(a::g), (App)ExtraCodecs.k.fieldOf("weight").forGetter(a::h)).apply((Applicative)var0, a::new));

        public a(RuinedPortalPiece.b var0, float var1, float var2, boolean var3, boolean var4, boolean var5, boolean var6, float var7) {
            this.b = var0;
            this.c = var1;
            this.d = var2;
            this.e = var3;
            this.f = var4;
            this.g = var5;
            this.h = var6;
            this.i = var7;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "placement;airPocketProbability;mossiness;overgrown;vines;canBeCold;replaceWithBlackstone;weight", "b", "c", "d", "e", "f", "g", "h", "i"}, this, var0);
        }

        public RuinedPortalPiece.b a() {
            return this.b;
        }

        public float b() {
            return this.c;
        }

        public float c() {
            return this.d;
        }

        public boolean d() {
            return this.e;
        }

        public boolean e() {
            return this.f;
        }

        public boolean f() {
            return this.g;
        }

        public boolean g() {
            return this.h;
        }

        public float h() {
            return this.i;
        }
    }
}

