/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_20_R1.map.RenderData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 128;
    private static final int k = 64;
    public static final int a = 4;
    public static final int b = 256;
    public int c;
    public int d;
    public ResourceKey<World> e;
    public boolean l;
    public boolean m;
    public byte f;
    public byte[] g = new byte[16384];
    public boolean h;
    public final List<WorldMapHumanTracker> n = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> o = Maps.newHashMap();
    private final Map<String, MapIconBanner> p = Maps.newHashMap();
    public final Map<String, MapIcon> q = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> r = Maps.newHashMap();
    private int s;
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public String id;

    private WorldMap(int i2, int j2, byte b0, boolean flag, boolean flag1, boolean flag2, ResourceKey<World> resourcekey) {
        this.f = b0;
        this.c = i2;
        this.d = j2;
        this.e = resourcekey;
        this.l = flag;
        this.m = flag1;
        this.h = flag2;
        this.b();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
    }

    public static WorldMap a(double d0, double d1, byte b0, boolean flag, boolean flag1, ResourceKey<World> resourcekey) {
        int i2 = 128 * (1 << b0);
        int j2 = MathHelper.a((d0 + 64.0) / (double)i2);
        int k2 = MathHelper.a((d1 + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, b0, flag, flag1, false, resourcekey);
    }

    public static WorldMap a(byte b0, boolean flag, ResourceKey<World> resourcekey) {
        return new WorldMap(0, 0, b0, false, false, flag, resourcekey);
    }

    public static WorldMap b(NBTTagCompound nbttagcompound) {
        DataResult<ResourceKey<World>> dataresult = DimensionManager.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("dimension")));
        Logger logger = i;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbttagcompound.i("UUIDLeast");
            long most = nbttagcompound.i("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().ac();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + nbttagcompound.c("dimension"));
        });
        int i2 = nbttagcompound.h("xCenter");
        int j2 = nbttagcompound.h("zCenter");
        byte b0 = (byte)MathHelper.a((int)nbttagcompound.f("scale"), 0, 4);
        boolean flag = !nbttagcompound.b("trackingPosition", 1) || nbttagcompound.q("trackingPosition");
        boolean flag1 = nbttagcompound.q("unlimitedTracking");
        boolean flag2 = nbttagcompound.q("locked");
        WorldMap worldmap = new WorldMap(i2, j2, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbttagcompound.m("colors");
        if (abyte.length == 16384) {
            worldmap.g = abyte;
        }
        NBTTagList nbttaglist = nbttagcompound.c("banners", 10);
        int k2 = 0;
        while (k2 < nbttaglist.size()) {
            MapIconBanner mapiconbanner = MapIconBanner.a(nbttaglist.a(k2));
            worldmap.p.put(mapiconbanner.f(), mapiconbanner);
            worldmap.a(mapiconbanner.c(), null, mapiconbanner.f(), mapiconbanner.a().u(), mapiconbanner.a().w(), 180.0, mapiconbanner.d());
            ++k2;
        }
        NBTTagList nbttaglist1 = nbttagcompound.c("frames", 10);
        int l2 = 0;
        while (l2 < nbttaglist1.size()) {
            WorldMapFrame worldmapframe = WorldMapFrame.a(nbttaglist1.a(l2));
            worldmap.r.put(worldmapframe.e(), worldmapframe);
            worldmap.a(MapIcon.Type.b, null, "frame-" + worldmapframe.d(), worldmapframe.b().u(), worldmapframe.b().w(), worldmapframe.c(), null);
            ++l2;
        }
        return worldmap;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound nbttagcompound) {
        DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.a());
        Logger logger = i;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("dimension", (NBTBase)nbtbase));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().ac() != this.e) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbttagcompound.a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbttagcompound.a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbttagcompound.a("xCenter", this.c);
        nbttagcompound.a("zCenter", this.d);
        nbttagcompound.a("scale", this.f);
        nbttagcompound.a("colors", this.g);
        nbttagcompound.a("trackingPosition", this.l);
        nbttagcompound.a("unlimitedTracking", this.m);
        nbttagcompound.a("locked", this.h);
        NBTTagList nbttaglist = new NBTTagList();
        for (MapIconBanner mapiconbanner : this.p.values()) {
            nbttaglist.add(mapiconbanner.e());
        }
        nbttagcompound.a("banners", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (WorldMapFrame worldmapframe : this.r.values()) {
            nbttaglist1.add(worldmapframe.a());
        }
        nbttagcompound.a("frames", nbttaglist1);
        return nbttagcompound;
    }

    public WorldMap a() {
        WorldMap worldmap = new WorldMap(this.c, this.d, this.f, this.l, this.m, true, this.e);
        worldmap.p.putAll(this.p);
        worldmap.q.putAll(this.q);
        worldmap.s = this.s;
        System.arraycopy(this.g, 0, worldmap.g, 0, this.g.length);
        worldmap.b();
        return worldmap;
    }

    public WorldMap a(int i2) {
        return WorldMap.a(this.c, this.d, (byte)MathHelper.a(this.f + i2, 0, 4), this.l, this.m, this.e);
    }

    public void a(EntityHuman entityhuman, ItemStack itemstack) {
        NBTTagCompound nbttagcompound;
        if (!this.o.containsKey(entityhuman)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.o.put(entityhuman, worldmap_worldmaphumantracker);
            this.n.add(worldmap_worldmaphumantracker);
        }
        if (!entityhuman.fN().h(itemstack)) {
            this.a(entityhuman.Z().getString());
        }
        int i2 = 0;
        while (i2 < this.n.size()) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.n.get(i2);
            String s2 = worldmap_worldmaphumantracker1.a.Z().getString();
            if (!worldmap_worldmaphumantracker1.a.dD() && (worldmap_worldmaphumantracker1.a.fN().h(itemstack) || itemstack.F())) {
                if (!itemstack.F() && worldmap_worldmaphumantracker1.a.dI().ac() == this.e && this.l) {
                    this.a(MapIcon.Type.a, worldmap_worldmaphumantracker1.a.dI(), s2, worldmap_worldmaphumantracker1.a.dn(), worldmap_worldmaphumantracker1.a.dt(), worldmap_worldmaphumantracker1.a.dy(), null);
                }
            } else {
                this.o.remove(worldmap_worldmaphumantracker1.a);
                this.n.remove(worldmap_worldmaphumantracker1);
                this.a(s2);
            }
            ++i2;
        }
        if (itemstack.F() && this.l) {
            EntityItemFrame entityitemframe = itemstack.G();
            BlockPosition blockposition = entityitemframe.y();
            WorldMapFrame worldmapframe = this.r.get(WorldMapFrame.a(blockposition));
            if (worldmapframe != null && entityitemframe.af() != worldmapframe.d() && this.r.containsKey(worldmapframe.e())) {
                this.a("frame-" + worldmapframe.d());
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.cB().e() * 90, entityitemframe.af());
            this.a(MapIcon.Type.b, entityhuman.dI(), "frame-" + entityitemframe.af(), blockposition.u(), blockposition.w(), entityitemframe.cB().e() * 90, null);
            this.r.put(worldmapframe1.e(), worldmapframe1);
        }
        if ((nbttagcompound = itemstack.v()) != null && nbttagcompound.b("Decorations", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("Decorations", 10);
            int j2 = 0;
            while (j2 < nbttaglist.size()) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(j2);
                if (!this.q.containsKey(nbttagcompound1.l("id"))) {
                    this.a(MapIcon.Type.a(nbttagcompound1.f("type")), entityhuman.dI(), nbttagcompound1.l("id"), nbttagcompound1.k("x"), nbttagcompound1.k("z"), nbttagcompound1.k("rot"), null);
                }
                ++j2;
            }
        }
    }

    private void a(String s2) {
        MapIcon mapicon = this.q.remove(s2);
        if (mapicon != null && mapicon.b().e()) {
            --this.s;
        }
        this.g();
    }

    public static void a(ItemStack itemstack, BlockPosition blockposition, String s2, MapIcon.Type mapicon_type) {
        NBTTagList nbttaglist;
        if (itemstack.u() && itemstack.v().b("Decorations", 9)) {
            nbttaglist = itemstack.v().c("Decorations", 10);
        } else {
            nbttaglist = new NBTTagList();
            itemstack.a("Decorations", nbttaglist);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("type", mapicon_type.a());
        nbttagcompound.a("id", s2);
        nbttagcompound.a("x", (double)blockposition.u());
        nbttagcompound.a("z", (double)blockposition.w());
        nbttagcompound.a("rot", 180.0);
        nbttaglist.add(nbttagcompound);
        if (mapicon_type.c()) {
            NBTTagCompound nbttagcompound1 = itemstack.a("display");
            nbttagcompound1.a("MapColor", mapicon_type.d());
        }
    }

    private void a(MapIcon.Type mapicon_type, @Nullable GeneratorAccess generatoraccess, String s2, double d0, double d1, double d2, @Nullable IChatBaseComponent ichatbasecomponent) {
        MapIcon mapicon1;
        MapIcon mapicon;
        byte b2;
        int i2 = 1 << this.f;
        float f2 = (float)(d0 - (double)this.c) / (float)i2;
        float f1 = (float)(d1 - (double)this.d) / (float)i2;
        byte b0 = (byte)((double)(f2 * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        boolean flag = true;
        if (f2 >= -63.0f && f1 >= -63.0f && f2 <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((d2 += d2 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.e == World.i && generatoraccess != null) {
                int j2 = (int)(generatoraccess.u_().f() / 10L);
                b2 = (byte)(j2 * j2 * 34187121 + j2 * 121 >> 15 & 0xF);
            }
        } else {
            if (mapicon_type != MapIcon.Type.a) {
                this.a(s2);
                return;
            }
            boolean flag1 = true;
            if (Math.abs(f2) < 320.0f && Math.abs(f1) < 320.0f) {
                mapicon_type = MapIcon.Type.g;
            } else {
                if (!this.m) {
                    this.a(s2);
                    return;
                }
                mapicon_type = MapIcon.Type.h;
            }
            b2 = 0;
            if (f2 <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f2 >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapicon = new MapIcon(mapicon_type, b0, b1, b2, ichatbasecomponent)).equals(mapicon1 = this.q.put(s2, mapicon))) {
            if (mapicon1 != null && mapicon1.b().e()) {
                --this.s;
            }
            if (mapicon_type.e()) {
                ++this.s;
            }
            this.g();
        }
    }

    @Nullable
    public Packet<?> a(int i2, EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.o.get(entityhuman);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.a(i2);
    }

    public void a(int i2, int j2) {
        this.b();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.n) {
            worldmap_worldmaphumantracker.a(i2, j2);
        }
    }

    public void g() {
        this.b();
        this.n.forEach(WorldMapHumanTracker::access$0);
    }

    public WorldMapHumanTracker a(EntityHuman entityhuman) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.o.get(entityhuman);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(entityhuman);
            this.o.put(entityhuman, worldmap_worldmaphumantracker);
            this.n.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        double d0 = (double)blockposition.u() + 0.5;
        double d1 = (double)blockposition.w() + 0.5;
        int i2 = 1 << this.f;
        double d2 = (d0 - (double)this.c) / (double)i2;
        double d3 = (d1 - (double)this.d) / (double)i2;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.a(generatoraccess, blockposition);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.p.remove(mapiconbanner.f(), mapiconbanner)) {
                this.a(mapiconbanner.f());
                return true;
            }
            if (!this.b(256)) {
                this.p.put(mapiconbanner.f(), mapiconbanner);
                this.a(mapiconbanner.c(), generatoraccess, mapiconbanner.f(), d0, d1, 180.0, mapiconbanner.d());
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess iblockaccess, int i2, int j2) {
        Iterator<MapIconBanner> iterator = this.p.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.a().u() != i2 || mapiconbanner.a().w() != j2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.a(iblockaccess, mapiconbanner.a()))) continue;
            iterator.remove();
            this.a(mapiconbanner.f());
        }
    }

    public Collection<MapIconBanner> d() {
        return this.p.values();
    }

    public void a(BlockPosition blockposition, int i2) {
        this.a("frame-" + i2);
        this.r.remove(WorldMapFrame.a(blockposition));
    }

    public boolean a(int i2, int j2, byte b0) {
        byte b1 = this.g[i2 + j2 * 128];
        if (b1 != b0) {
            this.b(i2, j2, b0);
            return true;
        }
        return false;
    }

    public void b(int i2, int j2, byte b0) {
        this.g[i2 + j2 * 128] = b0;
        this.a(i2, j2);
    }

    public boolean e() {
        MapIcon mapicon;
        Iterator<MapIcon> iterator = this.q.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while ((mapicon = iterator.next()).b() != MapIcon.Type.i && mapicon.b() != MapIcon.Type.j);
        return true;
    }

    public void a(List<MapIcon> list) {
        this.q.clear();
        this.s = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            MapIcon mapicon = list.get(i2);
            this.q.put("icon-" + i2, mapicon);
            if (mapicon.b().e()) {
                ++this.s;
            }
            ++i2;
        }
    }

    public Iterable<MapIcon> f() {
        return this.q.values();
    }

    public boolean b(int i2) {
        return this.s >= i2;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.a = entityhuman;
        }

        private b createPatch(byte[] buffer) {
            int i2 = this.e;
            int j2 = this.f;
            int k2 = this.g + 1 - this.e;
            int l2 = this.h + 1 - this.f;
            byte[] abyte = new byte[k2 * l2];
            int i1 = 0;
            while (i1 < k2) {
                int j1 = 0;
                while (j1 < l2) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                    ++j1;
                }
                ++i1;
            }
            return new b(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> a(int i2) {
            ArrayList<MapIcon> collection;
            b worldmap_b;
            RenderData render = WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity());
            if (this.d) {
                this.d = false;
                worldmap_b = this.createPatch(render.buffer);
            } else {
                worldmap_b = null;
            }
            if (this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(MapIcon.Type.a(cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull(cursor.getCaption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_b == null ? null : new PacketPlayOutMap(i2, WorldMap.this.f, WorldMap.this.h, collection, worldmap_b);
        }

        void a(int i2, int j2) {
            if (this.d) {
                this.e = Math.min(this.e, i2);
                this.f = Math.min(this.f, j2);
                this.g = Math.max(this.g, i2);
                this.h = Math.max(this.h, j2);
            } else {
                this.d = true;
                this.e = i2;
                this.f = j2;
                this.g = i2;
                this.h = j2;
            }
        }

        private void b() {
            this.i = true;
        }

        static /* synthetic */ void access$0(WorldMapHumanTracker worldMapHumanTracker) {
            worldMapHumanTracker.b();
        }
    }

    public static class b {
        public final int a;
        public final int b;
        public final int c;
        public final int d;
        public final byte[] e;

        public b(int i2, int j2, int k2, int l2, byte[] abyte) {
            this.a = i2;
            this.b = j2;
            this.c = k2;
            this.d = l2;
            this.e = abyte;
        }

        public void a(WorldMap worldmap) {
            int i2 = 0;
            while (i2 < this.c) {
                int j2 = 0;
                while (j2 < this.d) {
                    worldmap.b(this.a + i2, this.b + j2, this.e[i2 + j2 * this.c]);
                    ++j2;
                }
                ++i2;
            }
        }
    }
}

