/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger e = LogUtils.getLogger();
    protected static final String a = "Player";
    protected static final String b = "WorldGenSettings";
    public WorldSettings f;
    private final WorldOptions g;
    private final a h;
    private final Lifecycle i;
    private int j;
    private int k;
    private int l;
    private float m;
    private long n;
    private long o;
    @Nullable
    private final DataFixer p;
    private final int q;
    private boolean r;
    @Nullable
    private NBTTagCompound s;
    private final int t;
    private int u;
    private boolean v;
    private int w;
    private boolean x;
    private int y;
    private boolean z;
    private boolean A;
    private WorldBorder.c B;
    private EnderDragonBattle.a C;
    @Nullable
    private NBTTagCompound D;
    private int E;
    private int F;
    @Nullable
    private UUID G;
    private final Set<String> H;
    private boolean I;
    private final Set<String> J;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> K;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable DataFixer datafixer, int i2, @Nullable NBTTagCompound nbttagcompound, boolean flag, int j2, int k2, int l2, float f2, long i1, long j1, int k1, int l1, int i22, boolean flag1, int j22, boolean flag2, boolean flag3, boolean flag4, WorldBorder.c worldborder_c, int k22, int l22, @Nullable UUID uuid, Set<String> set, Set<String> set1, CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue, @Nullable NBTTagCompound nbttagcompound1, EnderDragonBattle.a enderdragonbattle_a, WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this.p = datafixer;
        this.I = flag;
        this.j = j2;
        this.k = k2;
        this.l = l2;
        this.m = f2;
        this.n = i1;
        this.o = j1;
        this.t = k1;
        this.u = l1;
        this.w = i22;
        this.v = flag1;
        this.y = j22;
        this.x = flag2;
        this.z = flag3;
        this.A = flag4;
        this.B = worldborder_c;
        this.E = k22;
        this.F = l22;
        this.G = uuid;
        this.H = set;
        this.J = set1;
        this.s = nbttagcompound;
        this.q = i2;
        this.K = customfunctioncallbacktimerqueue;
        this.D = nbttagcompound1;
        this.C = enderdragonbattle_a;
        this.f = worldsettings;
        this.g = worldoptions;
        this.h = worlddataserver_a;
        this.i = lifecycle;
    }

    public WorldDataServer(WorldSettings worldsettings, WorldOptions worldoptions, a worlddataserver_a, Lifecycle lifecycle) {
        this(null, SharedConstants.b().d().c(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.e, 0, 0, null, Sets.newLinkedHashSet(), new HashSet<String>(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, EnderDragonBattle.a.b, worldsettings.h(), worldoptions, worlddataserver_a, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, DataFixer datafixer, int i2, @Nullable NBTTagCompound nbttagcompound, WorldSettings worldsettings, LevelVersion levelversion, a worlddataserver_a, WorldOptions worldoptions, Lifecycle lifecycle) {
        long j2 = dynamic.get("Time").asLong(0L);
        boolean flag = dynamic.get("WasModded").asBoolean(false);
        int k2 = dynamic.get("SpawnX").asInt(0);
        int l2 = dynamic.get("SpawnY").asInt(0);
        int i1 = dynamic.get("SpawnZ").asInt(0);
        float f2 = dynamic.get("SpawnAngle").asFloat(0.0f);
        long j1 = dynamic.get("DayTime").asLong(j2);
        int k1 = levelversion.a();
        int l1 = dynamic.get("clearWeatherTime").asInt(0);
        int i22 = dynamic.get("rainTime").asInt(0);
        boolean flag1 = dynamic.get("raining").asBoolean(false);
        int j22 = dynamic.get("thunderTime").asInt(0);
        boolean flag2 = dynamic.get("thundering").asBoolean(false);
        boolean flag3 = dynamic.get("initialized").asBoolean(true);
        boolean flag4 = dynamic.get("DifficultyLocked").asBoolean(false);
        WorldBorder.c worldborder_c = WorldBorder.c.a(dynamic, WorldBorder.e);
        int k22 = dynamic.get("WanderingTraderSpawnDelay").asInt(0);
        int l22 = dynamic.get("WanderingTraderSpawnChance").asInt(0);
        UUID uuid = dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null);
        Set set = dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet));
        Set<String> set1 = dynamic.get("removed_features").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toSet());
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream());
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue();
        DataResult dataresult = dynamic.get("DragonFight").read(EnderDragonBattle.a.a);
        Logger logger = e;
        Objects.requireNonNull(logger);
        return new WorldDataServer(datafixer, i2, nbttagcompound, flag, k2, l2, i1, f2, j2, j1, k1, l1, i22, flag1, j22, flag2, flag3, flag4, worldborder_c, k22, l22, uuid, set, set1, customfunctioncallbacktimerqueue, nbttagcompound1, dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElse(EnderDragonBattle.a.b), worldsettings, worldoptions, worlddataserver_a, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom iregistrycustom, @Nullable NBTTagCompound nbttagcompound) {
        this.N();
        if (nbttagcompound == null) {
            nbttagcompound = this.s;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(iregistrycustom, nbttagcompound1, nbttagcompound);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom iregistrycustom, NBTTagCompound nbttagcompound, @Nullable NBTTagCompound nbttagcompound1) {
        nbttagcompound.a("ServerBrands", WorldDataServer.a(this.H));
        nbttagcompound.a("WasModded", this.I);
        if (!this.J.isEmpty()) {
            nbttagcompound.a("removed_features", WorldDataServer.a(this.J));
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().d().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().g());
        nbttagcompound2.a("Series", SharedConstants.b().d().b());
        nbttagcompound.a("Version", nbttagcompound2);
        GameProfileSerializer.g(nbttagcompound);
        RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, iregistrycustom);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.g, new WorldDimensions(this.customDimensions != null ? this.customDimensions : iregistrycustom.d(Registries.aI)));
        Logger logger = e;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> nbttagcompound.a(b, (NBTBase)nbtbase));
        nbttagcompound.a("GameType", this.f.b().a());
        nbttagcompound.a("SpawnX", this.j);
        nbttagcompound.a("SpawnY", this.k);
        nbttagcompound.a("SpawnZ", this.l);
        nbttagcompound.a("SpawnAngle", this.m);
        nbttagcompound.a("Time", this.n);
        nbttagcompound.a("DayTime", this.o);
        nbttagcompound.a("LastPlayed", SystemUtils.d());
        nbttagcompound.a("LevelName", this.f.a());
        nbttagcompound.a("version", 19133);
        nbttagcompound.a("clearWeatherTime", this.u);
        nbttagcompound.a("rainTime", this.w);
        nbttagcompound.a("raining", this.v);
        nbttagcompound.a("thunderTime", this.y);
        nbttagcompound.a("thundering", this.x);
        nbttagcompound.a("hardcore", this.f.c());
        nbttagcompound.a("allowCommands", this.f.e());
        nbttagcompound.a("initialized", this.z);
        this.B.a(nbttagcompound);
        nbttagcompound.a("Difficulty", (byte)this.f.d().a());
        nbttagcompound.a("DifficultyLocked", this.A);
        nbttagcompound.a("GameRules", this.f.f().a());
        nbttagcompound.a("DragonFight", (NBTBase)SystemUtils.a(EnderDragonBattle.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.C), IllegalStateException::new));
        if (nbttagcompound1 != null) {
            nbttagcompound.a(a, nbttagcompound1);
        }
        DataResult dataresult1 = WorldDataConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f.g());
        dataresult1.get().ifLeft(nbtbase -> nbttagcompound.a((NBTTagCompound)nbtbase)).ifRight(partialresult -> e.warn("Failed to encode configuration {}", (Object)partialresult.message()));
        if (this.D != null) {
            nbttagcompound.a("CustomBossEvents", this.D);
        }
        nbttagcompound.a("ScheduledEvents", this.K.b());
        nbttagcompound.a("WanderingTraderSpawnDelay", this.E);
        nbttagcompound.a("WanderingTraderSpawnChance", this.F);
        if (this.G != null) {
            nbttagcompound.a("WanderingTraderId", this.G);
        }
        nbttagcompound.a("Bukkit.Version", String.valueOf(Bukkit.getName()) + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(nbttagcompound);
    }

    private static NBTTagList a(Set<String> set) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = set.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        return nbttaglist;
    }

    @Override
    public int a() {
        return this.j;
    }

    @Override
    public int b() {
        return this.k;
    }

    @Override
    public int c() {
        return this.l;
    }

    @Override
    public float d() {
        return this.m;
    }

    @Override
    public long e() {
        return this.n;
    }

    @Override
    public long f() {
        return this.o;
    }

    private void N() {
        if (!this.r && this.s != null) {
            if (this.q < SharedConstants.b().d().c()) {
                if (this.p == null) {
                    throw SystemUtils.b(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.s = DataFixTypes.b.a(this.p, this.s, this.q);
            }
            this.r = true;
        }
    }

    @Override
    public NBTTagCompound y() {
        this.N();
        return this.s;
    }

    @Override
    public void b(int i2) {
        this.j = i2;
    }

    @Override
    public void c(int i2) {
        this.k = i2;
    }

    @Override
    public void d(int i2) {
        this.l = i2;
    }

    @Override
    public void a(float f2) {
        this.m = f2;
    }

    @Override
    public void a(long i2) {
        this.n = i2;
    }

    @Override
    public void b(long i2) {
        this.o = i2;
    }

    @Override
    public void a(BlockPosition blockposition, float f2) {
        this.j = blockposition.u();
        this.k = blockposition.v();
        this.l = blockposition.w();
        this.m = f2;
    }

    @Override
    public String g() {
        return this.f.a();
    }

    @Override
    public int z() {
        return this.t;
    }

    @Override
    public int h() {
        return this.u;
    }

    @Override
    public void a(int i2) {
        this.u = i2;
    }

    @Override
    public boolean i() {
        return this.x;
    }

    @Override
    public void a(boolean flag) {
        if (this.x == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.x = flag;
    }

    @Override
    public int j() {
        return this.y;
    }

    @Override
    public void e(int i2) {
        this.y = i2;
    }

    @Override
    public boolean k() {
        return this.v;
    }

    @Override
    public void b(boolean flag) {
        if (this.v == flag) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, flag);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.v = flag;
    }

    @Override
    public int l() {
        return this.w;
    }

    @Override
    public void f(int i2) {
        this.w = i2;
    }

    @Override
    public EnumGamemode m() {
        return this.f.b();
    }

    @Override
    public void a(EnumGamemode enumgamemode) {
        this.f = this.f.a(enumgamemode);
    }

    @Override
    public boolean n() {
        return this.f.c();
    }

    @Override
    public boolean o() {
        return this.f.e();
    }

    @Override
    public boolean p() {
        return this.z;
    }

    @Override
    public void c(boolean flag) {
        this.z = flag;
    }

    @Override
    public GameRules q() {
        return this.f.f();
    }

    @Override
    public WorldBorder.c r() {
        return this.B;
    }

    @Override
    public void a(WorldBorder.c worldborder_c) {
        this.B = worldborder_c;
    }

    @Override
    public EnumDifficulty s() {
        return this.f.d();
    }

    @Override
    public void a(EnumDifficulty enumdifficulty) {
        this.f = this.f.a(enumdifficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.s(), this.t());
        for (EntityPlayer player : this.world.v()) {
            player.c.a(packet);
        }
    }

    @Override
    public boolean t() {
        return this.A;
    }

    @Override
    public void d(boolean flag) {
        this.A = flag;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> u() {
        return this.K;
    }

    @Override
    public void a(CrashReportSystemDetails crashreportsystemdetails, LevelHeightAccessor levelheightaccessor) {
        IWorldDataServer.super.a(crashreportsystemdetails, levelheightaccessor);
        SaveData.super.a(crashreportsystemdetails);
    }

    @Override
    public WorldOptions A() {
        return this.g;
    }

    @Override
    public boolean B() {
        return this.h == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean C() {
        return this.h == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle D() {
        return this.i;
    }

    @Override
    public EnderDragonBattle.a E() {
        return this.C;
    }

    @Override
    public void a(EnderDragonBattle.a enderdragonbattle_a) {
        this.C = enderdragonbattle_a;
    }

    @Override
    public WorldDataConfiguration F() {
        return this.f.g();
    }

    @Override
    public void a(WorldDataConfiguration worlddataconfiguration) {
        this.f = this.f.a(worlddataconfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound G() {
        return this.D;
    }

    @Override
    public void a(@Nullable NBTTagCompound nbttagcompound) {
        this.D = nbttagcompound;
    }

    @Override
    public int v() {
        return this.E;
    }

    @Override
    public void g(int i2) {
        this.E = i2;
    }

    @Override
    public int w() {
        return this.F;
    }

    @Override
    public void h(int i2) {
        this.F = i2;
    }

    @Override
    @Nullable
    public UUID x() {
        return this.G;
    }

    @Override
    public void a(UUID uuid) {
        this.G = uuid;
    }

    @Override
    public void a(String s2, boolean flag) {
        this.H.add(s2);
        this.I |= flag;
    }

    @Override
    public boolean H() {
        return this.I;
    }

    @Override
    public Set<String> I() {
        return ImmutableSet.copyOf(this.H);
    }

    @Override
    public Set<String> J() {
        return Set.copyOf(this.J);
    }

    @Override
    public IWorldDataServer K() {
        return this;
    }

    @Override
    public WorldSettings L() {
        return this.f.h();
    }

    public void checkName(String name) {
        if (!this.f.a.equals(name)) {
            this.f.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

