/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class WorldNBTStorage {
    private static final Logger b = LogUtils.getLogger();
    private final File c;
    protected final DataFixer a;

    public WorldNBTStorage(Convertable.ConversionSession convertable_conversionsession, DataFixer datafixer) {
        this.a = datafixer;
        this.c = convertable_conversionsession.a(SavedFile.c).toFile();
        this.c.mkdirs();
    }

    public void a(EntityHuman entityhuman) {
        if (SpigotConfig.disablePlayerDataSaving) {
            return;
        }
        try {
            NBTTagCompound nbttagcompound = entityhuman.f(new NBTTagCompound());
            File file = File.createTempFile(String.valueOf(entityhuman.cu()) + "-", ".dat", this.c);
            NBTCompressedStreamTools.a(nbttagcompound, file);
            File file1 = new File(this.c, String.valueOf(entityhuman.cu()) + ".dat");
            File file2 = new File(this.c, String.valueOf(entityhuman.cu()) + ".dat_old");
            SystemUtils.a(file1, file, file2);
        }
        catch (Exception exception) {
            b.warn("Failed to save player data for {}", (Object)entityhuman.Z().getString());
        }
    }

    @Nullable
    public NBTTagCompound b(EntityHuman entityhuman) {
        NBTTagCompound nbttagcompound = null;
        try {
            File file = new File(this.c, String.valueOf(entityhuman.cu()) + ".dat");
            boolean usingWrongFile = false;
            if (!file.exists() && (file = new File(this.c, String.valueOf(UUID.nameUUIDFromBytes(("OfflinePlayer:" + entityhuman.cv()).getBytes("UTF-8")).toString()) + ".dat")).exists()) {
                usingWrongFile = true;
                Bukkit.getServer().getLogger().warning("Using offline mode UUID file for player " + entityhuman.cv() + " as it is the only copy we can find.");
            }
            if (file.exists() && file.isFile()) {
                nbttagcompound = NBTCompressedStreamTools.a(file);
            }
            if (usingWrongFile) {
                file.renameTo(new File(String.valueOf(file.getPath()) + ".offline-read"));
            }
        }
        catch (Exception exception) {
            b.warn("Failed to load player data for {}", (Object)entityhuman.Z().getString());
        }
        if (nbttagcompound != null) {
            if (entityhuman instanceof EntityPlayer) {
                CraftPlayer player = (CraftPlayer)entityhuman.getBukkitEntity();
                long modified = new File(this.c, String.valueOf(entityhuman.ct().toString()) + ".dat").lastModified();
                if (modified < player.getFirstPlayed()) {
                    player.setFirstPlayed(modified);
                }
            }
            int i2 = GameProfileSerializer.b(nbttagcompound, -1);
            entityhuman.g(DataFixTypes.b.a(this.a, nbttagcompound, i2));
        }
        return nbttagcompound;
    }

    public NBTTagCompound getPlayerData(String s2) {
        try {
            File file1 = new File(this.c, String.valueOf(s2) + ".dat");
            if (file1.exists()) {
                return NBTCompressedStreamTools.a(new FileInputStream(file1));
            }
        }
        catch (Exception exception) {
            b.warn("Failed to load player data for " + s2);
        }
        return null;
    }

    public String[] a() {
        String[] astring = this.c.list();
        if (astring == null) {
            astring = new String[]{};
        }
        int i2 = 0;
        while (i2 < astring.length) {
            if (astring[i2].endsWith(".dat")) {
                astring[i2] = astring[i2].substring(0, astring[i2].length() - 4);
            }
            ++i2;
        }
        return astring;
    }

    public File getPlayerDir() {
        return this.c;
    }
}

