/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataResolver;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootDataManager
implements IReloadListener,
LootDataResolver {
    private static final Logger b = LogUtils.getLogger();
    public static final LootDataId<LootTable> a = new LootDataId<LootTable>(LootDataType.c, LootTables.a);
    private Map<LootDataId<?>, ?> c = Map.of();
    private Multimap<LootDataType<?>, MinecraftKey> d = ImmutableMultimap.of();
    public Map<?, MinecraftKey> lootTableToKey = ImmutableMap.of();

    @Override
    public final CompletableFuture<Void> a(IReloadListener.a ireloadlistener_a, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller, GameProfilerFiller gameprofilerfiller1, Executor executor, Executor executor1) {
        HashMap map = new HashMap();
        CompletableFuture[] acompletablefuture = (CompletableFuture[])LootDataType.c().map(lootdatatype -> LootDataManager.a(lootdatatype, iresourcemanager, executor, map)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completablefuture = CompletableFuture.allOf(acompletablefuture);
        Objects.requireNonNull(ireloadlistener_a);
        return ((CompletableFuture)completablefuture.thenCompose(ireloadlistener_a::a)).thenAcceptAsync(ovoid -> this.a(map), executor1);
    }

    private static <T> CompletableFuture<?> a(LootDataType<T> lootdatatype, IResourceManager iresourcemanager, Executor executor, Map<LootDataType<?>, Map<MinecraftKey, ?>> map) {
        HashMap map1 = new HashMap();
        map.put(lootdatatype, map1);
        return CompletableFuture.runAsync(() -> {
            HashMap<MinecraftKey, JsonElement> map2 = new HashMap<MinecraftKey, JsonElement>();
            ResourceDataJson.a(iresourcemanager, lootdatatype.b(), lootdatatype.a(), map2);
            map2.forEach((minecraftkey, jsonelement) -> lootdatatype.a((MinecraftKey)minecraftkey, (JsonElement)jsonelement).ifPresent(object -> map1.put(minecraftkey, object)));
        }, executor);
    }

    private void a(Map<LootDataType<?>, Map<MinecraftKey, ?>> map) {
        Object object = map.get(LootDataType.c).remove(LootTables.a);
        if (object != null) {
            b.warn("Datapack tried to redefine {} loot table, ignoring", (Object)LootTables.a);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMultimap.Builder com_google_common_collect_immutablemultimap_builder = ImmutableMultimap.builder();
        map.forEach((lootdatatype, map1) -> map1.forEach((minecraftkey, object1) -> {
            builder.put(new LootDataId(lootdatatype, (MinecraftKey)minecraftkey), object1);
            com_google_common_collect_immutablemultimap_builder.put(lootdatatype, minecraftkey);
        }));
        builder.put(a, (Object)LootTable.a);
        ImmutableMap map12 = builder.build();
        LootCollector lootcollector = new LootCollector(LootContextParameterSets.m, new LootDataResolver((Map)map12){
            private final /* synthetic */ Map val$map1;
            {
                this.val$map1 = map;
            }

            @Override
            @Nullable
            public <T> T getElement(LootDataId<T> lootdataid) {
                return (T)this.val$map1.get(lootdataid);
            }
        });
        map12.forEach((lootdataid, object1) -> LootDataManager.a(lootcollector, lootdataid, object1));
        lootcollector.a().forEach((s2, s1) -> b.warn("Found loot table element validation problem in {}: {}", s2, s1));
        this.c = map12;
        this.d = com_google_common_collect_immutablemultimap_builder.build();
        ImmutableMap.Builder lootTableToKeyBuilder = ImmutableMap.builder();
        this.c.forEach((key, lootTable) -> {
            ImmutableMap.Builder builder2 = lootTableToKeyBuilder.put(lootTable, (Object)key.b());
        });
        this.lootTableToKey = lootTableToKeyBuilder.build();
    }

    private static <T> void a(LootCollector lootcollector, LootDataId<T> lootdataid, Object object) {
        lootdataid.a().a(lootcollector, lootdataid, object);
    }

    @Override
    @Nullable
    public <T> T getElement(LootDataId<T> lootdataid) {
        return (T)this.c.get(lootdataid);
    }

    public Collection<MinecraftKey> a(LootDataType<?> lootdatatype) {
        return this.d.get(lootdatatype);
    }

    public static LootItemCondition a(LootItemCondition[] alootitemcondition) {
        return new a(alootitemcondition);
    }

    public static LootItemFunction a(LootItemFunction[] alootitemfunction) {
        return new b(alootitemfunction);
    }

    private static class a
    implements LootItemCondition {
        private final LootItemCondition[] a;
        private final Predicate<LootTableInfo> b;

        a(LootItemCondition[] alootitemcondition) {
            this.a = alootitemcondition;
            this.b = LootItemConditions.a(alootitemcondition);
        }

        public final boolean a(LootTableInfo loottableinfo) {
            return this.b.test(loottableinfo);
        }

        @Override
        public void a(LootCollector lootcollector) {
            LootItemCondition.super.a(lootcollector);
            int i2 = 0;
            while (i2 < this.a.length) {
                this.a[i2].a(lootcollector.b(".term[" + i2 + "]"));
                ++i2;
            }
        }

        @Override
        public LootItemConditionType b() {
            throw new UnsupportedOperationException();
        }
    }

    private static class b
    implements LootItemFunction {
        protected final LootItemFunction[] a;
        private final BiFunction<ItemStack, LootTableInfo, ItemStack> b;

        public b(LootItemFunction[] alootitemfunction) {
            this.a = alootitemfunction;
            this.b = LootItemFunctions.a(alootitemfunction);
        }

        public ItemStack a(ItemStack itemstack, LootTableInfo loottableinfo) {
            return this.b.apply(itemstack, loottableinfo);
        }

        @Override
        public void a(LootCollector lootcollector) {
            LootItemFunction.super.a(lootcollector);
            int i2 = 0;
            while (i2 < this.a.length) {
                this.a[i2].a(lootcollector.b(".function[" + i2 + "]"));
                ++i2;
            }
        }

        @Override
        public LootItemFunctionType b() {
            throw new UnsupportedOperationException();
        }
    }
}

