/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;

@FunctionalInterface
public interface LootDataResolver {
    @Nullable
    public <T> T getElement(LootDataId<T> var1);

    @Nullable
    default public <T> T getElement(LootDataType<T> var0, MinecraftKey var1) {
        return this.getElement(new LootDataId<T>(var0, var1));
    }

    default public <T> Optional<T> getElementOptional(LootDataId<T> var0) {
        return Optional.ofNullable(this.getElement(var0));
    }

    default public <T> Optional<T> getElementOptional(LootDataType<T> var0, MinecraftKey var1) {
        return this.getElementOptional(new LootDataId<T>(var0, var1));
    }

    default public LootTable getLootTable(MinecraftKey var0) {
        return this.getElementOptional(LootDataType.c, var0).orElse(LootTable.a);
    }
}

