/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionUser;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootSelector {
    final LootEntryAbstract[] a;
    final LootItemCondition[] b;
    private final Predicate<LootTableInfo> c;
    final LootItemFunction[] d;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> e;
    final NumberProvider f;
    final NumberProvider g;

    LootSelector(LootEntryAbstract[] var0, LootItemCondition[] var1, LootItemFunction[] var2, NumberProvider var3, NumberProvider var4) {
        this.a = var0;
        this.b = var1;
        this.c = LootItemConditions.a(var1);
        this.d = var2;
        this.e = LootItemFunctions.a(var2);
        this.f = var3;
        this.g = var4;
    }

    private void b(Consumer<ItemStack> var0, LootTableInfo var1) {
        RandomSource var2 = var1.b();
        ArrayList var32 = Lists.newArrayList();
        MutableInt var4 = new MutableInt();
        for (LootEntryAbstract lootEntryAbstract : this.a) {
            lootEntryAbstract.expand(var1, var3 -> {
                int var4 = var3.a(var1.c());
                if (var4 > 0) {
                    var32.add(var3);
                    var4.add(var4);
                }
            });
        }
        int var5 = var32.size();
        if (var4.intValue() == 0 || var5 == 0) {
            return;
        }
        if (var5 == 1) {
            ((LootEntry)var32.get(0)).a(var0, var1);
            return;
        }
        int var6 = var2.a(var4.intValue());
        for (LootEntry lootEntry : var32) {
            if ((var6 -= lootEntry.a(var1.c())) >= 0) continue;
            lootEntry.a(var0, var1);
            return;
        }
    }

    public void a(Consumer<ItemStack> var0, LootTableInfo var1) {
        if (!this.c.test(var1)) {
            return;
        }
        Consumer<ItemStack> var2 = LootItemFunction.a(this.e, var0, var1);
        int var3 = this.f.a(var1) + MathHelper.d(this.g.b(var1) * var1.c());
        for (int var4 = 0; var4 < var3; ++var4) {
            this.b(var2, var1);
        }
    }

    public void a(LootCollector var0) {
        int var1;
        for (var1 = 0; var1 < this.b.length; ++var1) {
            this.b[var1].a(var0.b(".condition[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.d.length; ++var1) {
            this.d[var1].a(var0.b(".functions[" + var1 + "]"));
        }
        for (var1 = 0; var1 < this.a.length; ++var1) {
            this.a[var1].a(var0.b(".entries[" + var1 + "]"));
        }
        this.f.a(var0.b(".rolls"));
        this.g.a(var0.b(".bonusRolls"));
    }

    public static a a() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a>,
    LootItemConditionUser<a> {
        private final List<LootEntryAbstract> a = Lists.newArrayList();
        private final List<LootItemCondition> b = Lists.newArrayList();
        private final List<LootItemFunction> c = Lists.newArrayList();
        private NumberProvider d = ConstantValue.a(1.0f);
        private NumberProvider e = ConstantValue.a(0.0f);

        public a a(NumberProvider var0) {
            this.d = var0;
            return this;
        }

        public a a() {
            return this;
        }

        public a b(NumberProvider var0) {
            this.e = var0;
            return this;
        }

        public a a(LootEntryAbstract.a<?> var0) {
            this.a.add(var0.b());
            return this;
        }

        public a a(LootItemCondition.a var0) {
            this.b.add(var0.build());
            return this;
        }

        public a a(LootItemFunction.a var0) {
            this.c.add(var0.b());
            return this;
        }

        public LootSelector b() {
            if (this.d == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootSelector(this.a.toArray(new LootEntryAbstract[0]), this.b.toArray(new LootItemCondition[0]), this.c.toArray(new LootItemFunction[0]), this.d, this.e);
        }

        @Override
        public /* synthetic */ LootItemFunctionUser c() {
            return this.a();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser b(LootItemFunction.a a2) {
            return this.a(a2);
        }

        @Override
        public /* synthetic */ LootItemConditionUser d() {
            return this.a();
        }

        @Override
        public /* synthetic */ LootItemConditionUser b(LootItemCondition.a a2) {
            return this.a(a2);
        }
    }

    public static class b
    implements JsonDeserializer<LootSelector>,
    JsonSerializer<LootSelector> {
        public LootSelector a(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            JsonObject var3 = ChatDeserializer.m(var0, "loot pool");
            LootEntryAbstract[] var4 = ChatDeserializer.a(var3, "entries", var2, LootEntryAbstract[].class);
            LootItemCondition[] var5 = ChatDeserializer.a(var3, "conditions", new LootItemCondition[0], var2, LootItemCondition[].class);
            LootItemFunction[] var6 = ChatDeserializer.a(var3, "functions", new LootItemFunction[0], var2, LootItemFunction[].class);
            NumberProvider var7 = ChatDeserializer.a(var3, "rolls", var2, NumberProvider.class);
            NumberProvider var8 = ChatDeserializer.a(var3, "bonus_rolls", ConstantValue.a(0.0f), var2, NumberProvider.class);
            return new LootSelector(var4, var5, var6, var7, var8);
        }

        public JsonElement a(LootSelector var0, Type var1, JsonSerializationContext var2) {
            JsonObject var3 = new JsonObject();
            var3.add("rolls", var2.serialize((Object)var0.f));
            var3.add("bonus_rolls", var2.serialize((Object)var0.g));
            var3.add("entries", var2.serialize((Object)var0.a));
            if (!ArrayUtils.isEmpty((Object[])var0.b)) {
                var3.add("conditions", var2.serialize((Object)var0.b));
            }
            if (!ArrayUtils.isEmpty((Object[])var0.d)) {
                var3.add("functions", var2.serialize((Object)var0.d));
            }
            return var3;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.a((LootSelector)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.a(jsonElement, type, jsonDeserializationContext);
        }
    }
}

