/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    static final Logger c = LogUtils.getLogger();
    public static final LootTable a = new LootTable(LootContextParameterSets.a, null, new LootSelector[0], new LootItemFunction[0]);
    public static final LootContextParameterSet b = LootContextParameterSets.m;
    final LootContextParameterSet d;
    @Nullable
    final MinecraftKey e;
    final LootSelector[] f;
    final LootItemFunction[] g;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> h;

    LootTable(LootContextParameterSet lootcontextparameterset, @Nullable MinecraftKey minecraftkey, LootSelector[] alootselector, LootItemFunction[] alootitemfunction) {
        this.d = lootcontextparameterset;
        this.e = minecraftkey;
        this.f = alootselector;
        this.g = alootitemfunction;
        this.h = LootItemFunctions.a(alootitemfunction);
    }

    public static Consumer<ItemStack> a(WorldServer worldserver, Consumer<ItemStack> consumer) {
        return itemstack -> {
            if (itemstack.a(worldserver.G())) {
                if (itemstack.L() < itemstack.g()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    int i2 = itemstack.L();
                    while (i2 > 0) {
                        ItemStack itemstack1 = itemstack.c(Math.min(itemstack.g(), i2));
                        i2 -= itemstack1.L();
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void a(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.a(new LootTableInfo.Builder(lootparams).a(this.e), consumer);
    }

    public void a(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        LootTableInfo.c<LootTable> loottableinfo_c = LootTableInfo.a(this);
        if (loottableinfo.b(loottableinfo_c)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.a(this.h, consumer, loottableinfo);
            LootSelector[] alootselector = this.f;
            int i2 = alootselector.length;
            int j2 = 0;
            while (j2 < i2) {
                LootSelector lootselector = alootselector[j2];
                lootselector.a(consumer1, loottableinfo);
                ++j2;
            }
            loottableinfo.c(loottableinfo_c);
        } else {
            c.warn("Detected infinite loop in loot tables");
        }
    }

    public void a(LootParams lootparams, long i2, Consumer<ItemStack> consumer) {
        this.a(new LootTableInfo.Builder(lootparams).a(i2).a(this.e), LootTable.a(lootparams.a(), consumer));
    }

    public void b(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.a(lootparams, LootTable.a(lootparams.a(), consumer));
    }

    public void b(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        this.a(loottableinfo, LootTable.a(loottableinfo.d(), consumer));
    }

    public ObjectArrayList<ItemStack> a(LootParams lootparams, long i2) {
        return this.a(new LootTableInfo.Builder(lootparams).a(i2).a(this.e));
    }

    public ObjectArrayList<ItemStack> a(LootParams lootparams) {
        return this.a(new LootTableInfo.Builder(lootparams).a(this.e));
    }

    private ObjectArrayList<ItemStack> a(LootTableInfo loottableinfo) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.b(loottableinfo, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public LootContextParameterSet a() {
        return this.d;
    }

    public void a(LootCollector lootcollector) {
        int i2 = 0;
        while (i2 < this.f.length) {
            this.f[i2].a(lootcollector.b(".pools[" + i2 + "]"));
            ++i2;
        }
        i2 = 0;
        while (i2 < this.g.length) {
            this.g[i2].a(lootcollector.b(".functions[" + i2 + "]"));
            ++i2;
        }
    }

    public void a(IInventory iinventory, LootParams lootparams, long i2) {
        this.fillInventory(iinventory, lootparams, i2, false);
    }

    public void fillInventory(IInventory iinventory, LootParams lootparams, long i2, boolean plugin) {
        LootTableInfo loottableinfo = new LootTableInfo.Builder(lootparams).a(i2).a(this.e);
        ObjectArrayList objectarraylist = this.a(loottableinfo);
        RandomSource randomsource = loottableinfo.b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.a(iinventory, randomsource);
        this.a((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                c.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.b()) {
                iinventory.a((int)list.remove(list.size() - 1), ItemStack.b);
                continue;
            }
            iinventory.a((int)list.remove(list.size() - 1), itemstack);
        }
    }

    private void a(ObjectArrayList<ItemStack> objectarraylist, int i2, RandomSource randomsource) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator objectlistiterator = objectarraylist.iterator();
        while (objectlistiterator.hasNext()) {
            ItemStack itemstack = (ItemStack)objectlistiterator.next();
            if (itemstack.b()) {
                objectlistiterator.remove();
                continue;
            }
            if (itemstack.L() <= 1) continue;
            list.add(itemstack);
            objectlistiterator.remove();
        }
        while (i2 - objectarraylist.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(MathHelper.a(randomsource, 0, list.size() - 1));
            int j2 = MathHelper.a(randomsource, 1, itemstack1.L() / 2);
            ItemStack itemstack2 = itemstack1.a(j2);
            if (itemstack1.L() > 1 && randomsource.h()) {
                list.add(itemstack1);
            } else {
                objectarraylist.add((Object)itemstack1);
            }
            if (itemstack2.L() > 1 && randomsource.h()) {
                list.add(itemstack2);
                continue;
            }
            objectarraylist.add((Object)itemstack2);
        }
        objectarraylist.addAll((Collection)list);
        SystemUtils.b(objectarraylist, randomsource);
    }

    private List<Integer> a(IInventory iinventory, RandomSource randomsource) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        int i2 = 0;
        while (i2 < iinventory.b()) {
            if (iinventory.a(i2).b()) {
                objectarraylist.add((Object)i2);
            }
            ++i2;
        }
        SystemUtils.b(objectarraylist, randomsource);
        return objectarraylist;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final List<LootSelector> a = Lists.newArrayList();
        private final List<LootItemFunction> b = Lists.newArrayList();
        private LootContextParameterSet c = b;
        @Nullable
        private MinecraftKey d = null;

        public a a(LootSelector.a lootselector_a) {
            this.a.add(lootselector_a.b());
            return this;
        }

        public a a(LootContextParameterSet lootcontextparameterset) {
            this.c = lootcontextparameterset;
            return this;
        }

        public a a(MinecraftKey minecraftkey) {
            this.d = minecraftkey;
            return this;
        }

        public a a(LootItemFunction.a lootitemfunction_a) {
            this.b.add(lootitemfunction_a.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.d, this.a.toArray(new LootSelector[0]), this.b.toArray(new LootItemFunction[0]));
        }
    }

    public static class b
    implements JsonDeserializer<LootTable>,
    JsonSerializer<LootTable> {
        public LootTable a(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            MinecraftKey minecraftkey;
            JsonObject jsonobject = ChatDeserializer.m(jsonelement, "loot table");
            LootSelector[] alootselector = ChatDeserializer.a(jsonobject, "pools", new LootSelector[0], jsondeserializationcontext, LootSelector[].class);
            LootContextParameterSet lootcontextparameterset = null;
            if (jsonobject.has("type")) {
                String s2 = ChatDeserializer.i(jsonobject, "type");
                lootcontextparameterset = LootContextParameterSets.a(new MinecraftKey(s2));
            }
            if (jsonobject.has("random_sequence")) {
                String s1 = ChatDeserializer.i(jsonobject, "random_sequence");
                minecraftkey = new MinecraftKey(s1);
            } else {
                minecraftkey = null;
            }
            LootItemFunction[] alootitemfunction = ChatDeserializer.a(jsonobject, "functions", new LootItemFunction[0], jsondeserializationcontext, LootItemFunction[].class);
            return new LootTable(lootcontextparameterset != null ? lootcontextparameterset : LootContextParameterSets.m, minecraftkey, alootselector, alootitemfunction);
        }

        public JsonElement a(LootTable loottable, Type type, JsonSerializationContext jsonserializationcontext) {
            JsonObject jsonobject = new JsonObject();
            if (loottable.d != b) {
                MinecraftKey minecraftkey = LootContextParameterSets.a(loottable.d);
                if (minecraftkey != null) {
                    jsonobject.addProperty("type", minecraftkey.toString());
                } else {
                    c.warn("Failed to find id for param set {}", (Object)loottable.d);
                }
            }
            if (loottable.e != null) {
                jsonobject.addProperty("random_sequence", loottable.e.toString());
            }
            if (loottable.f.length > 0) {
                jsonobject.add("pools", jsonserializationcontext.serialize((Object)loottable.f));
            }
            if (!ArrayUtils.isEmpty((Object[])loottable.g)) {
                jsonobject.add("functions", jsonserializationcontext.serialize((Object)loottable.g));
            }
            return jsonobject;
        }
    }
}

