/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.apache.commons.lang.StringUtils;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftIpBanEntry;

public class CraftIpBanList
implements BanList {
    private final IpBanList list;

    public CraftIpBanList(IpBanList list) {
        this.list = list;
    }

    public BanEntry getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        IpBanEntry entry = (IpBanEntry)this.list.b(target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        IpBanEntry entry = new IpBanEntry(target, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.a(entry);
        try {
            this.list.e();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-ips.json, {0}", ex.getMessage());
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String[] stringArray = this.list.a();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String target = stringArray[n3];
            builder.add((Object)new CraftIpBanEntry(target, (IpBanEntry)this.list.b(target), this.list));
            ++n3;
        }
        return builder.build();
    }

    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        return this.list.a(InetSocketAddress.createUnresolved(target, 0));
    }

    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        this.list.c(target);
    }
}

