/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.entity.EntityType;

public class CraftCreatureSpawner
extends CraftBlockEntityState<TileEntityMobSpawner>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, TileEntityMobSpawner tileEntity) {
        super(world, tileEntity);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).d().f;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(spawnData.a());
        return type.map(entityTypes -> EntityType.fromName((String)EntityTypes.a(entityTypes).a())).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((TileEntityMobSpawner)this.getSnapshot()).d().e = SimpleWeightedRandomList.b();
            ((TileEntityMobSpawner)this.getSnapshot()).d().f = null;
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.isPlaced() ? this.getWorldHandle().y_() : RandomSource.a();
        ((TileEntityMobSpawner)this.getSnapshot()).a(EntityTypes.a(entityType.getName()).get(), rand);
    }

    public String getCreatureTypeName() {
        MobSpawnerData spawnData = ((TileEntityMobSpawner)this.getSnapshot()).d().f;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(spawnData.a());
        return type.map(entityTypes -> EntityTypes.a(entityTypes).a()).orElse(null);
    }

    public void setCreatureTypeByName(String creatureType) {
        EntityType type = EntityType.fromName((String)creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    public int getDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().d;
    }

    public void setDelay(int delay) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().d = delay;
    }

    public int getMinSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().i;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).d().i = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().j;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((TileEntityMobSpawner)this.getSnapshot()).d().j = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().m;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().m = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().k;
    }

    public void setSpawnCount(int count) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().k = count;
    }

    public int getRequiredPlayerRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().n;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().n = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return ((TileEntityMobSpawner)this.getSnapshot()).d().o;
    }

    public void setSpawnRange(int spawnRange) {
        ((TileEntityMobSpawner)this.getSnapshot()).d().o = spawnRange;
    }
}

