/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Furnace;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryFurnace;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.Recipe;

public abstract class CraftFurnace<T extends TileEntityFurnace>
extends CraftContainer<T>
implements Furnace {
    public CraftFurnace(World world, T tileEntity) {
        super(world, tileEntity);
    }

    public FurnaceInventory getSnapshotInventory() {
        return new CraftInventoryFurnace((TileEntityFurnace)this.getSnapshot());
    }

    public FurnaceInventory getInventory() {
        if (!this.isPlaced()) {
            return this.getSnapshotInventory();
        }
        return new CraftInventoryFurnace((TileEntityFurnace)this.getTileEntity());
    }

    public short getBurnTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).u;
    }

    public void setBurnTime(short burnTime) {
        ((TileEntityFurnace)this.getSnapshot()).u = burnTime;
        this.data = (IBlockData)this.data.a(BlockFurnace.b, burnTime > 0);
    }

    public short getCookTime() {
        return (short)((TileEntityFurnace)this.getSnapshot()).w;
    }

    public void setCookTime(short cookTime) {
        ((TileEntityFurnace)this.getSnapshot()).w = cookTime;
    }

    public int getCookTimeTotal() {
        return ((TileEntityFurnace)this.getSnapshot()).x;
    }

    public void setCookTimeTotal(int cookTimeTotal) {
        ((TileEntityFurnace)this.getSnapshot()).x = cookTimeTotal;
    }

    public Map<CookingRecipe<?>, Integer> getRecipesUsed() {
        ImmutableMap.Builder recipesUsed = ImmutableMap.builder();
        for (Map.Entry entrySet : ((TileEntityFurnace)this.getSnapshot()).getRecipesUsed().object2IntEntrySet()) {
            Recipe recipe = Bukkit.getRecipe((NamespacedKey)CraftNamespacedKey.fromMinecraft((MinecraftKey)entrySet.getKey()));
            if (!(recipe instanceof CookingRecipe var5_5)) continue;
            recipesUsed.put((Object)cookingRecipe, (Object)((Integer)entrySet.getValue()));
        }
        return recipesUsed.build();
    }
}

