/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.block.sign.CraftSignSide;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CraftSign<T extends TileEntitySign>
extends CraftBlockEntityState<T>
implements Sign {
    private final CraftSignSide front = new CraftSignSide(((TileEntitySign)this.getSnapshot()).g());
    private final CraftSignSide back = new CraftSignSide(((TileEntitySign)this.getSnapshot()).i());

    public CraftSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    public String[] getLines() {
        return this.front.getLines();
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.front.getLine(index);
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.front.setLine(index, line);
    }

    public boolean isEditable() {
        return !((TileEntitySign)this.getSnapshot()).w() && ((TileEntitySign)this.getSnapshot()).d != null;
    }

    public void setEditable(boolean editable) {
        ((TileEntitySign)this.getSnapshot()).b(!editable);
    }

    public boolean isGlowingText() {
        return this.front.isGlowingText();
    }

    public void setGlowingText(boolean glowing) {
        this.front.setGlowingText(glowing);
    }

    @NotNull
    public SignSide getSide(Side side) {
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        switch (side) {
            case FRONT: {
                return this.front;
            }
            case BACK: {
                return this.back;
            }
        }
        throw new IllegalArgumentException();
    }

    public DyeColor getColor() {
        return this.front.getColor();
    }

    public void setColor(DyeColor color) {
        this.front.setColor(color);
    }

    @Override
    public void applyTo(T sign) {
        ((TileEntitySign)this.getSnapshot()).a(this.front.applyLegacyStringToSignSide(), true);
        ((TileEntitySign)this.getSnapshot()).a(this.back.applyLegacyStringToSignSide(), false);
        super.applyTo(sign);
    }

    public static void openSign(Sign sign, Player player, Side side) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((side != null ? 1 : 0) != 0, (Object)"side == null");
        Preconditions.checkArgument((boolean)sign.isPlaced(), (Object)"Sign must be placed");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        TileEntitySign handle = (TileEntitySign)((CraftSign)sign).getTileEntity();
        ((CraftPlayer)player).getHandle().a(handle, Side.FRONT == side);
    }

    public static IChatBaseComponent[] sanitizeLines(String[] lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        int i2 = 0;
        while (i2 < 4) {
            components[i2] = i2 < lines.length && lines[i2] != null ? IChatBaseComponent.b("").b(CraftChatMessage.fromString(lines[i2])[0]) : IChatBaseComponent.h();
            ++i2;
        }
        return components;
    }

    public static String[] revertComponents(IChatBaseComponent[] components) {
        String[] lines = new String[components.length];
        int i2 = 0;
        while (i2 < lines.length) {
            lines[i2] = CraftSign.revertComponent(components[i2]);
            ++i2;
        }
        return lines;
    }

    private static String revertComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

