/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block.sign;

import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.SignText;
import org.bukkit.DyeColor;
import org.bukkit.block.sign.SignSide;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftSign;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftSignSide
implements SignSide {
    private String[] originalLines = null;
    private String[] lines = null;
    private SignText signText;

    public CraftSignSide(SignText signText) {
        this.signText = signText;
    }

    @NotNull
    public String[] getLines() {
        if (this.lines == null) {
            IChatBaseComponent[] messages = this.signText.b(false);
            this.lines = new String[messages.length];
            System.arraycopy(CraftSign.revertComponents(messages), 0, this.lines, 0, this.lines.length);
            this.originalLines = new String[this.lines.length];
            System.arraycopy(this.lines, 0, this.originalLines, 0, this.originalLines.length);
        }
        return this.lines;
    }

    @NotNull
    public String getLine(int index) throws IndexOutOfBoundsException {
        return this.getLines()[index];
    }

    public void setLine(int index, @NotNull String line) throws IndexOutOfBoundsException {
        this.getLines()[index] = line;
    }

    public boolean isGlowingText() {
        return this.signText.a();
    }

    public void setGlowingText(boolean glowing) {
        this.signText = this.signText.a(glowing);
    }

    @Nullable
    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((byte)this.signText.b().a()));
    }

    public void setColor(@NotNull DyeColor color) {
        this.signText = this.signText.a(EnumColor.a(color.getWoolData()));
    }

    public SignText applyLegacyStringToSignSide() {
        if (this.lines != null) {
            int i2 = 0;
            while (i2 < this.lines.length) {
                String line;
                String string = line = this.lines[i2] == null ? "" : this.lines[i2];
                if (!line.equals(this.originalLines[i2])) {
                    this.signText = this.signText.a(i2, CraftChatMessage.fromString(line)[0]);
                }
                ++i2;
            }
        }
        return this.signText;
    }
}

