/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.boss;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final EnderDragonBattle handle;

    public CraftDragonBattle(EnderDragonBattle handle) {
        this.handle = handle;
    }

    public EnderDragon getEnderDragon() {
        Entity entity = this.handle.l.a(this.handle.w);
        return entity != null ? (EnderDragon)entity.getBukkitEntity() : null;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.k);
    }

    public Location getEndPortalLocation() {
        if (this.handle.y == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.handle.y, (World)this.handle.l.getWorld());
    }

    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.y != null || this.handle.m() != null) {
            return false;
        }
        this.handle.a(withPortals);
        return true;
    }

    public boolean hasBeenPreviouslyKilled() {
        return this.handle.f();
    }

    public void initiateRespawn() {
        this.handle.g();
    }

    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.z);
    }

    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)phase);
        if (this.handle.z == null) {
            return false;
        }
        this.handle.a(this.toNMSRespawnPhase(phase));
        return true;
    }

    public void resetCrystals() {
        this.handle.h();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(EnumDragonRespawn phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private EnumDragonRespawn toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? EnumDragonRespawn.values()[phase.ordinal()] : null;
    }
}

