/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.command;

import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.command.ServerCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;

public class CraftBlockCommandSender
extends ServerCommandSender
implements BlockCommandSender {
    private final CommandListenerWrapper block;
    private final TileEntity tile;

    public CraftBlockCommandSender(CommandListenerWrapper commandBlockListenerAbstract, TileEntity tile) {
        this.block = commandBlockListenerAbstract;
        this.tile = tile;
    }

    public Block getBlock() {
        return CraftBlock.at(this.tile.k(), this.tile.p());
    }

    public void sendMessage(String message) {
        IChatBaseComponent[] iChatBaseComponentArray = CraftChatMessage.fromString(message);
        int n2 = iChatBaseComponentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IChatBaseComponent component = iChatBaseComponentArray[n3];
            this.block.c.a(component);
            ++n3;
        }
    }

    public void sendMessage(String ... messages) {
        String[] stringArray = messages;
        int n2 = messages.length;
        int n3 = 0;
        while (n3 < n2) {
            String message = stringArray[n3];
            this.sendMessage(message);
            ++n3;
        }
    }

    public String getName() {
        return this.block.c();
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of a block");
    }

    public CommandListenerWrapper getWrapper() {
        return this.block;
    }
}

