/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import net.minecraft.core.Vector3f;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class CraftArmorStand
extends CraftLivingEntity
implements ArmorStand {
    public CraftArmorStand(CraftServer server, EntityArmorStand entity) {
        super(server, entity);
    }

    @Override
    public String toString() {
        return "CraftArmorStand";
    }

    @Override
    public EntityType getType() {
        return EntityType.ARMOR_STAND;
    }

    @Override
    public EntityArmorStand getHandle() {
        return (EntityArmorStand)super.getHandle();
    }

    public ItemStack getItemInHand() {
        return this.getEquipment().getItemInHand();
    }

    public void setItemInHand(ItemStack item) {
        this.getEquipment().setItemInHand(item);
    }

    public ItemStack getBoots() {
        return this.getEquipment().getBoots();
    }

    public void setBoots(ItemStack item) {
        this.getEquipment().setBoots(item);
    }

    public ItemStack getLeggings() {
        return this.getEquipment().getLeggings();
    }

    public void setLeggings(ItemStack item) {
        this.getEquipment().setLeggings(item);
    }

    public ItemStack getChestplate() {
        return this.getEquipment().getChestplate();
    }

    public void setChestplate(ItemStack item) {
        this.getEquipment().setChestplate(item);
    }

    public ItemStack getHelmet() {
        return this.getEquipment().getHelmet();
    }

    public void setHelmet(ItemStack item) {
        this.getEquipment().setHelmet(item);
    }

    public EulerAngle getBodyPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cd);
    }

    public void setBodyPose(EulerAngle pose) {
        this.getHandle().b(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().ce);
    }

    public void setLeftArmPose(EulerAngle pose) {
        this.getHandle().c(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightArmPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cf);
    }

    public void setRightArmPose(EulerAngle pose) {
        this.getHandle().d(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getLeftLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cg);
    }

    public void setLeftLegPose(EulerAngle pose) {
        this.getHandle().e(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getRightLegPose() {
        return CraftArmorStand.fromNMS(this.getHandle().ch);
    }

    public void setRightLegPose(EulerAngle pose) {
        this.getHandle().f(CraftArmorStand.toNMS(pose));
    }

    public EulerAngle getHeadPose() {
        return CraftArmorStand.fromNMS(this.getHandle().cc);
    }

    public void setHeadPose(EulerAngle pose) {
        this.getHandle().a(CraftArmorStand.toNMS(pose));
    }

    public boolean hasBasePlate() {
        return !this.getHandle().s();
    }

    public void setBasePlate(boolean basePlate) {
        this.getHandle().s(!basePlate);
    }

    @Override
    public void setGravity(boolean gravity) {
        super.setGravity(gravity);
        this.getHandle().ae = !gravity;
    }

    public boolean isVisible() {
        return !this.getHandle().cb();
    }

    public void setVisible(boolean visible) {
        this.getHandle().j(!visible);
    }

    public boolean hasArms() {
        return this.getHandle().r();
    }

    public void setArms(boolean arms) {
        this.getHandle().a(arms);
    }

    public boolean isSmall() {
        return this.getHandle().q();
    }

    public void setSmall(boolean small) {
        this.getHandle().t(small);
    }

    private static EulerAngle fromNMS(Vector3f old) {
        return new EulerAngle(Math.toRadians(old.b()), Math.toRadians(old.c()), Math.toRadians(old.d()));
    }

    private static Vector3f toNMS(EulerAngle old) {
        return new Vector3f((float)Math.toDegrees(old.getX()), (float)Math.toDegrees(old.getY()), (float)Math.toDegrees(old.getZ()));
    }

    public boolean isMarker() {
        return this.getHandle().w();
    }

    public void setMarker(boolean marker) {
        this.getHandle().u(marker);
    }

    public void addEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cb |= 1 << CraftEquipmentSlot.getNMS(equipmentSlot).c() + lockType.ordinal() * 8;
    }

    public void removeEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        this.getHandle().cb &= ~(1 << CraftEquipmentSlot.getNMS(equipmentSlot).c() + lockType.ordinal() * 8);
    }

    public boolean hasEquipmentLock(EquipmentSlot equipmentSlot, ArmorStand.LockType lockType) {
        return (this.getHandle().cb & 1 << CraftEquipmentSlot.getNMS(equipmentSlot).c() + lockType.ordinal() * 8) != 0;
    }
}

