/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.EntityArrow;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftArrow
extends AbstractProjectile
implements AbstractArrow {
    public CraftArrow(CraftServer server, EntityArrow entity) {
        super(server, entity);
    }

    public void setKnockbackStrength(int knockbackStrength) {
        Preconditions.checkArgument((knockbackStrength >= 0 ? 1 : 0) != 0, (String)"Knockback value (%s) cannot be negative", (int)knockbackStrength);
        this.getHandle().b(knockbackStrength);
    }

    public int getKnockbackStrength() {
        return this.getHandle().o;
    }

    public double getDamage() {
        return this.getHandle().q();
    }

    public void setDamage(double damage) {
        Preconditions.checkArgument((damage >= 0.0 ? 1 : 0) != 0, (String)"Damage value (%s) must be positive", (Object)damage);
        this.getHandle().h(damage);
    }

    public int getPierceLevel() {
        return this.getHandle().w();
    }

    public void setPierceLevel(int pierceLevel) {
        Preconditions.checkArgument((pierceLevel >= 0 && pierceLevel <= 127 ? 1 : 0) != 0, (String)"Pierce level (%s) out of range, expected 0 < level < 127", (int)pierceLevel);
        this.getHandle().a((byte)pierceLevel);
    }

    public boolean isCritical() {
        return this.getHandle().s();
    }

    public void setCritical(boolean critical) {
        this.getHandle().a(critical);
    }

    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().b(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().b((net.minecraft.world.entity.Entity)null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public boolean isInBlock() {
        return this.getHandle().b;
    }

    public Block getAttachedBlock() {
        if (!this.isInBlock()) {
            return null;
        }
        BlockPosition pos = this.getHandle().di();
        return this.getWorld().getBlockAt(pos.u(), pos.v(), pos.w());
    }

    public AbstractArrow.PickupStatus getPickupStatus() {
        return AbstractArrow.PickupStatus.values()[this.getHandle().d.ordinal()];
    }

    public void setPickupStatus(AbstractArrow.PickupStatus status) {
        Preconditions.checkArgument((status != null ? 1 : 0) != 0, (Object)"PickupStatus cannot be null");
        this.getHandle().d = EntityArrow.PickupStatus.a(status.ordinal());
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().m = value;
    }

    public boolean isShotFromCrossbow() {
        return this.getHandle().t();
    }

    public void setShotFromCrossbow(boolean shotFromCrossbow) {
        this.getHandle().q(shotFromCrossbow);
    }

    @Override
    public EntityArrow getHandle() {
        return (EntityArrow)this.entity;
    }

    @Override
    public String toString() {
        return "CraftArrow";
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }
}

