/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.animal.EntityBee;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, EntityBee entity) {
        super(server, entity);
    }

    @Override
    public EntityBee getHandle() {
        return (EntityBee)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBee";
    }

    @Override
    public EntityType getType() {
        return EntityType.BEE;
    }

    public Location getHive() {
        BlockPosition hive = this.getHandle().gg();
        return hive == null ? null : CraftLocation.toBukkit(hive, this.getWorld());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().cG = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public Location getFlower() {
        BlockPosition flower = this.getHandle().q();
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().i(location == null ? null : CraftLocation.toBlockPosition(location));
    }

    public boolean hasNectar() {
        return this.getHandle().gi();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().w(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().gj();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().x(stung);
    }

    public int getAnger() {
        return this.getHandle().a();
    }

    public void setAnger(int anger) {
        this.getHandle().a(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().cz;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().t(ticks);
    }
}

