/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftDragonBattle;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMob;
import org.bukkit.entity.ComplexEntityPart;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EntityType;

public class CraftEnderDragon
extends CraftMob
implements EnderDragon,
CraftEnemy {
    public CraftEnderDragon(CraftServer server, EntityEnderDragon entity) {
        super(server, entity);
    }

    public Set<ComplexEntityPart> getParts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        EntityComplexPart[] entityComplexPartArray = this.getHandle().cf;
        int n2 = this.getHandle().cf.length;
        int n3 = 0;
        while (n3 < n2) {
            EntityComplexPart part = entityComplexPartArray[n3];
            builder.add((Object)((ComplexEntityPart)part.getBukkitEntity()));
            ++n3;
        }
        return builder.build();
    }

    @Override
    public EntityEnderDragon getHandle() {
        return (EntityEnderDragon)this.entity;
    }

    @Override
    public String toString() {
        return "CraftEnderDragon";
    }

    @Override
    public EntityType getType() {
        return EntityType.ENDER_DRAGON;
    }

    public EnderDragon.Phase getPhase() {
        return EnderDragon.Phase.values()[this.getHandle().aj().b(EntityEnderDragon.b)];
    }

    public void setPhase(EnderDragon.Phase phase) {
        this.getHandle().fW().a(CraftEnderDragon.getMinecraftPhase(phase));
    }

    public static EnderDragon.Phase getBukkitPhase(DragonControllerPhase phase) {
        return EnderDragon.Phase.values()[phase.b()];
    }

    public static DragonControllerPhase getMinecraftPhase(EnderDragon.Phase phase) {
        return DragonControllerPhase.a(phase.ordinal());
    }

    public BossBar getBossBar() {
        DragonBattle battle = this.getDragonBattle();
        return battle != null ? battle.getBossBar() : null;
    }

    public DragonBattle getDragonBattle() {
        return this.getHandle().fX() != null ? new CraftDragonBattle(this.getHandle().fX()) : null;
    }

    public int getDeathAnimationTicks() {
        return this.getHandle().bV;
    }
}

