/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftSound;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, EntityLiving entity) {
        super(server, entity);
        if (entity instanceof EntityInsentient || entity instanceof EntityArmorStand) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().er()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        Preconditions.checkArgument(((health = (double)((float)health)) >= 0.0 && health <= this.getMaxHealth() ? 1 : 0) != 0, (String)"Health value (%s) must be between 0 and %s", (Object)health, (Object)this.getMaxHealth());
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().ai();
            return;
        }
        this.getHandle().t((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().dJ().n());
        }
    }

    public double getAbsorptionAmount() {
        return this.getHandle().ff();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().y((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().eI();
    }

    public void setMaxHealth(double amount) {
        Preconditions.checkArgument((amount > 0.0 ? 1 : 0) != 0, (String)"Max health amount (%s) must be greater than 0", (Object)amount);
        this.getHandle().a(GenericAttributes.a).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().a(GenericAttributes.a).a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().cF();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (!transparent.contains(material = block.getType())) break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().cf();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().j(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().aJ;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().aJ = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().eJ();
    }

    public void setArrowsInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.getHandle().aj().b(EntityLiving.bL, count);
    }

    public void damage(double amount) {
        this.damage(amount, null);
    }

    public void damage(double amount, Entity source) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        DamageSource reason = this.getHandle().dJ().n();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().dJ().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().dJ().b(((CraftLivingEntity)source).getHandle());
        }
        this.entity.a(reason, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().aS;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().aS = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bj;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bj = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().ak;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().ak = ticks;
    }

    @Override
    public EntityLiving getHandle() {
        return (EntityLiving)this.entity;
    }

    public void setHandle(EntityLiving entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + '}';
    }

    public Player getKiller() {
        return this.getHandle().aZ == null ? null : (Player)this.getHandle().aZ.getBukkitEntity();
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        this.getHandle().addEffect(new MobEffect(MobEffectList.a(effect.getType().getId()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().a(MobEffectList.a(type.getId()));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        MobEffect handle = this.getHandle().b(MobEffectList.a(type.getId()));
        return handle == null ? null : new PotionEffect(PotionEffectType.getById((int)MobEffectList.a(handle.c())), handle.d(), handle.e(), handle.f(), handle.g());
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(MobEffectList.a(type.getId()), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (MobEffect handle : this.getHandle().bR.values()) {
            effects.add(new PotionEffect(PotionEffectType.getById((int)MobEffectList.a(handle.c())), handle.d(), handle.e(), handle.f(), handle.g()));
        }
        return effects;
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        IProjectile launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, this.getHandle());
                ((EntityTippedArrow)launch).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, this.getHandle()) : (Trident.class.isAssignableFrom(projectile) ? new EntityThrownTrident(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.uV)) : new EntityTippedArrow(world, this.getHandle()));
            }
            ((EntityArrow)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dA(), this.getHandle().dy(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof EntityHuman) {
            launch = new EntityFishingHook((EntityHuman)this.getHandle(), (World)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new EntitySmallFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new EntityWitherSkull(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (DragonFireball.class.isAssignableFrom(projectile) ? new EntityDragonFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new EntityLargeFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ(), 1)));
            ((EntityFireball)launch).projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityTypes.ak.a(world);
            ((EntityLlamaSpit)launch).b((net.minecraft.world.entity.Entity)this.getHandle());
            ((EntityLlamaSpit)launch).c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityShulkerBullet(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityFireworks(world, net.minecraft.world.item.ItemStack.b, this.getHandle());
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Preconditions.checkArgument((launch != null ? 1 : 0) != 0, (String)"Projectile (%s) not supported", (Object)projectile.getName());
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().B(((CraftEntity)other).getHandle());
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof EntityInsentient && !((EntityInsentient)this.getHandle()).fH();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).s(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof EntityInsentient) {
            return ((EntityInsentient)this.getHandle()).fG();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        return ((EntityInsentient)this.getHandle()).fP() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isLeashed(), (Object)"Entity not leashed");
        return ((EntityInsentient)this.getHandle()).fP().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((EntityInsentient)this.getHandle()).a(true, false);
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation || this.getHandle() instanceof EntityWither || !(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((EntityInsentient)this.getHandle()).b(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    public boolean isGliding() {
        return this.getHandle().i(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().bW();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().h(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fe();
    }

    public boolean isSleeping() {
        return this.getHandle().fy();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().i_();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void setAI(boolean ai) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).t(!ai);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof EntityInsentient ? !((EntityInsentient)this.getHandle()).fQ() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof EntityHuman) {
            ((EntityHuman)this.getHandle()).d(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().z(((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.b, true);
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().dK().c(CraftMemoryKey.fromMemoryKey(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().dK().a(CraftMemoryKey.fromMemoryKey(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        SoundEffect sound = this.getHandle().getHurtSound0(this.getHandle().dJ().n());
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        SoundEffect sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.getBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.getBukkit(this.getHandle().eC().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.getBukkit(this.getHandle().eC().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getDrinkingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getEatingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().dN();
    }

    public EntityCategory getCategory() {
        EnumMonsterType type = this.getHandle().eN();
        if (type == EnumMonsterType.a) {
            return EntityCategory.NONE;
        }
        if (type == EnumMonsterType.b) {
            return EntityCategory.UNDEAD;
        }
        if (type == EnumMonsterType.c) {
            return EntityCategory.ARTHROPOD;
        }
        if (type == EnumMonsterType.d) {
            return EntityCategory.ILLAGER;
        }
        if (type == EnumMonsterType.e) {
            return EntityCategory.WATER;
        }
        throw new UnsupportedOperationException("Unsupported monster type: " + type + ". This is a bug, report this to Spigot.");
    }

    public boolean isInvisible() {
        return this.getHandle().cb();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().b(5, invisible);
    }
}

