/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.WardenAi;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMonster;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Warden;

public class CraftWarden
extends CraftMonster
implements Warden {
    public CraftWarden(CraftServer server, net.minecraft.world.entity.monster.warden.Warden entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.monster.warden.Warden getHandle() {
        return (net.minecraft.world.entity.monster.warden.Warden)this.entity;
    }

    @Override
    public String toString() {
        return "CraftWarden";
    }

    @Override
    public EntityType getType() {
        return EntityType.WARDEN;
    }

    public int getAnger() {
        return this.getHandle().fZ().b(this.getHandle().j());
    }

    public int getAnger(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        return this.getHandle().fZ().b(((CraftEntity)entity).getHandle());
    }

    public void increaseAnger(Entity entity, int increase) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().fZ().a(((CraftEntity)entity).getHandle(), increase);
    }

    public void setAnger(Entity entity, int anger) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().b(((CraftEntity)entity).getHandle());
        this.getHandle().fZ().a(((CraftEntity)entity).getHandle(), anger);
    }

    public void clearAnger(Entity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Entity cannot be null");
        this.getHandle().b(((CraftEntity)entity).getHandle());
    }

    public LivingEntity getEntityAngryAt() {
        return this.getHandle().fY().map(net.minecraft.world.entity.Entity::getBukkitEntity).orElse(null);
    }

    public void setDisturbanceLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"Location cannot be null");
        WardenAi.a(this.getHandle(), BlockPosition.a(location.getX(), location.getY(), location.getZ()));
    }

    public Warden.AngerLevel getAngerLevel() {
        return switch (this.getHandle().w()) {
            case AngerLevel.a -> Warden.AngerLevel.CALM;
            case AngerLevel.b -> Warden.AngerLevel.AGITATED;
            case AngerLevel.c -> Warden.AngerLevel.ANGRY;
            default -> throw new IncompatibleClassChangeError();
        };
    }
}

