/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.help;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.MultipleCommandAlias;
import org.bukkit.help.HelpTopic;

public class MultipleCommandAliasHelpTopic
extends HelpTopic {
    private final MultipleCommandAlias alias;

    public MultipleCommandAliasHelpTopic(MultipleCommandAlias alias) {
        this.alias = alias;
        this.name = "/" + alias.getLabel();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < alias.getCommands().length) {
            if (i2 != 0) {
                sb.append(ChatColor.GOLD + " > " + ChatColor.WHITE);
            }
            sb.append("/");
            sb.append(alias.getCommands()[i2].getLabel());
            ++i2;
        }
        this.shortText = sb.toString();
        this.fullText = ChatColor.GOLD + "Alias for: " + ChatColor.WHITE + this.getShortText();
    }

    public boolean canSee(CommandSender sender) {
        if (this.amendedPermission == null) {
            if (sender instanceof ConsoleCommandSender) {
                return true;
            }
            Command[] commandArray = this.alias.getCommands();
            int n2 = commandArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Command command = commandArray[n3];
                if (!command.testPermissionSilent(sender)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return sender.hasPermission(this.amendedPermission);
    }
}

