/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.inventory.InventoryMerchant;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.IHopper;
import net.minecraft.world.level.block.entity.TileEntityBarrel;
import net.minecraft.world.level.block.entity.TileEntityBlastFurnace;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityShulkerBox;
import net.minecraft.world.level.block.entity.TileEntitySmoker;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventorySmithingNew;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.InventoryIterator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLegacy;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftInventory
implements Inventory {
    protected final IInventory inventory;

    public CraftInventory(IInventory inventory) {
        this.inventory = inventory;
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public int getSize() {
        return this.getInventory().b();
    }

    public ItemStack getItem(int index) {
        net.minecraft.world.item.ItemStack item = this.getInventory().a(index);
        return item.b() ? null : CraftItemStack.asCraftMirror(item);
    }

    protected ItemStack[] asCraftMirror(List<net.minecraft.world.item.ItemStack> mcItems) {
        int size = mcItems.size();
        ItemStack[] items = new ItemStack[size];
        int i2 = 0;
        while (i2 < size) {
            net.minecraft.world.item.ItemStack mcItem = mcItems.get(i2);
            items[i2] = mcItem.b() ? null : CraftItemStack.asCraftMirror(mcItem);
            ++i2;
        }
        return items;
    }

    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    public ItemStack[] getContents() {
        List<net.minecraft.world.item.ItemStack> mcItems = this.getInventory().getContents();
        return this.asCraftMirror(mcItems);
    }

    public void setContents(ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        int i2 = 0;
        while (i2 < this.getSize()) {
            if (i2 >= items.length) {
                this.setItem(i2, null);
            } else {
                this.setItem(i2, items[i2]);
            }
            ++i2;
        }
    }

    public void setItem(int index, ItemStack item) {
        this.getInventory().a(index, CraftItemStack.asNMSCopy(item));
    }

    public boolean contains(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack item = itemStackArray[n3];
            if (item != null && item.getType() == material) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack i2 = itemStackArray[n3];
            if (item.equals((Object)i2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean contains(Material material, int amount) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack item = itemStackArray[n3];
            if (item != null && item.getType() == material && (amount -= item.getAmount()) <= 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack i2 = itemStackArray[n3];
            if (item.equals((Object)i2) && --amount <= 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        ItemStack[] itemStackArray = this.getStorageContents();
        int n2 = itemStackArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ItemStack i2 = itemStackArray[n3];
            if (item.isSimilar(i2) && (amount -= i2.getAmount()) <= 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getStorageContents();
        int i2 = 0;
        while (i2 < inventory.length) {
            ItemStack item = inventory[i2];
            if (item != null && item.getType() == material) {
                slots.put(i2, item);
            }
            ++i2;
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getStorageContents();
            int i2 = 0;
            while (i2 < inventory.length) {
                if (item.equals((Object)inventory[i2])) {
                    slots.put(i2, inventory[i2]);
                }
                ++i2;
            }
        }
        return slots;
    }

    public int first(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        int i2 = 0;
        while (i2 < inventory.length) {
            ItemStack item = inventory[i2];
            if (item != null && item.getType() == material) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getStorageContents();
        int i2 = 0;
        while (i2 < inventory.length) {
            if (inventory[i2] != null && (withAmount ? item.equals((Object)inventory[i2]) : item.isSimilar(inventory[i2]))) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int firstEmpty() {
        ItemStack[] inventory = this.getStorageContents();
        int i2 = 0;
        while (i2 < inventory.length) {
            if (inventory[i2] == null) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.inventory.ab_();
    }

    public int firstPartial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        int i2 = 0;
        while (i2 < inventory.length) {
            ItemStack item = inventory[i2];
            if (item != null && item.getType() == material && item.getAmount() < item.getMaxStackSize()) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getStorageContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        int i2 = 0;
        while (i2 < inventory.length) {
            ItemStack cItem = inventory[i2];
            if (cItem != null && cItem.getAmount() < cItem.getMaxStackSize() && cItem.isSimilar((ItemStack)filteredItem)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        int i2 = 0;
        while (i2 < items.length) {
            ItemStack item = items[i2];
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i2, item);
                        break;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    break;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    this.setItem(firstPartial, partialItem);
                    break;
                }
                partialItem.setAmount(maxAmount);
                this.setItem(firstPartial, partialItem);
                item.setAmount(amount + partialAmount - maxAmount);
            }
            ++i2;
        }
        return leftover;
    }

    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        int i2 = 0;
        while (i2 < items.length) {
            ItemStack item = items[i2];
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i2, item);
                    break;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
            ++i2;
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().ac_();
    }

    public void remove(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] items = this.getStorageContents();
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] != null && items[i2].getType() == material) {
                this.clear(i2);
            }
            ++i2;
        }
    }

    public void remove(ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] != null && items[i2].equals((Object)item)) {
                this.clear(i2);
            }
            ++i2;
        }
    }

    public void clear(int index) {
        this.setItem(index, null);
    }

    public void clear() {
        int i2 = 0;
        while (i2 < this.getSize()) {
            this.clear(i2);
            ++i2;
        }
    }

    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    public List<HumanEntity> getViewers() {
        return this.inventory.getViewers();
    }

    public InventoryType getType() {
        if (this.inventory instanceof InventoryCrafting) {
            return this.inventory.b() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof PlayerInventory) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof TileEntityDropper) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof TileEntityDispenser) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof TileEntityBlastFurnace) {
            return InventoryType.BLAST_FURNACE;
        }
        if (this.inventory instanceof TileEntitySmoker) {
            return InventoryType.SMOKER;
        }
        if (this.inventory instanceof TileEntityFurnace) {
            return InventoryType.FURNACE;
        }
        if (this instanceof CraftInventoryEnchanting) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof TileEntityBrewingStand) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof InventoryEnderChest) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof InventoryMerchant) {
            return InventoryType.MERCHANT;
        }
        if (this instanceof CraftInventoryBeacon) {
            return InventoryType.BEACON;
        }
        if (this instanceof CraftInventoryAnvil) {
            return InventoryType.ANVIL;
        }
        if (this instanceof CraftInventorySmithing) {
            return InventoryType.SMITHING;
        }
        if (this.inventory instanceof IHopper) {
            return InventoryType.HOPPER;
        }
        if (this.inventory instanceof TileEntityShulkerBox) {
            return InventoryType.SHULKER_BOX;
        }
        if (this.inventory instanceof TileEntityBarrel) {
            return InventoryType.BARREL;
        }
        if (this.inventory instanceof TileEntityLectern.LecternInventory) {
            return InventoryType.LECTERN;
        }
        if (this.inventory instanceof ChiseledBookShelfBlockEntity) {
            return InventoryType.CHISELED_BOOKSHELF;
        }
        if (this instanceof CraftInventoryLoom) {
            return InventoryType.LOOM;
        }
        if (this instanceof CraftInventoryCartography) {
            return InventoryType.CARTOGRAPHY;
        }
        if (this instanceof CraftInventoryGrindstone) {
            return InventoryType.GRINDSTONE;
        }
        if (this instanceof CraftInventoryStonecutter) {
            return InventoryType.STONECUTTER;
        }
        if (this.inventory instanceof BlockComposter.ContainerEmpty || this.inventory instanceof BlockComposter.ContainerInput || this.inventory instanceof BlockComposter.ContainerOutput) {
            return InventoryType.COMPOSTER;
        }
        if (this.inventory instanceof TileEntityJukeBox) {
            return InventoryType.JUKEBOX;
        }
        if (this instanceof CraftInventorySmithingNew) {
            return InventoryType.SMITHING_NEW;
        }
        return InventoryType.CHEST;
    }

    public InventoryHolder getHolder() {
        return this.inventory.getOwner();
    }

    public int getMaxStackSize() {
        return this.inventory.ac_();
    }

    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftInventory && ((CraftInventory)obj).inventory.equals(this.inventory);
    }

    public Location getLocation() {
        return this.inventory.getLocation();
    }
}

