/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class CraftInventoryCustom
extends CraftInventory {
    public CraftInventoryCustom(InventoryHolder owner, InventoryType type) {
        super(new MinecraftInventory(owner, type));
    }

    public CraftInventoryCustom(InventoryHolder owner, InventoryType type, String title) {
        super(new MinecraftInventory(owner, type, title));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size) {
        super(new MinecraftInventory(owner, size));
    }

    public CraftInventoryCustom(InventoryHolder owner, int size, String title) {
        super(new MinecraftInventory(owner, size, title));
    }

    static class MinecraftInventory
    implements IInventory {
        private final NonNullList<ItemStack> items;
        private int maxStack = 64;
        private final List<HumanEntity> viewers;
        private final String title;
        private InventoryType type;
        private final InventoryHolder owner;

        public MinecraftInventory(InventoryHolder owner, InventoryType type) {
            this(owner, type.getDefaultSize(), type.getDefaultTitle());
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, InventoryType type, String title) {
            this(owner, type.getDefaultSize(), title);
            this.type = type;
        }

        public MinecraftInventory(InventoryHolder owner, int size) {
            this(owner, size, "Chest");
        }

        public MinecraftInventory(InventoryHolder owner, int size, String title) {
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
            this.items = NonNullList.a(size, ItemStack.b);
            this.title = title;
            this.viewers = new ArrayList<HumanEntity>();
            this.owner = owner;
            this.type = InventoryType.CHEST;
        }

        @Override
        public int b() {
            return this.items.size();
        }

        @Override
        public ItemStack a(int i2) {
            return this.items.get(i2);
        }

        @Override
        public ItemStack a(int i2, int j2) {
            ItemStack result;
            ItemStack stack = this.a(i2);
            if (stack == ItemStack.b) {
                return stack;
            }
            if (stack.L() <= j2) {
                this.a(i2, ItemStack.b);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, j2);
                stack.h(j2);
            }
            this.e();
            return result;
        }

        @Override
        public ItemStack b(int i2) {
            ItemStack result;
            ItemStack stack = this.a(i2);
            if (stack == ItemStack.b) {
                return stack;
            }
            if (stack.L() <= 1) {
                this.a(i2, null);
                result = stack;
            } else {
                result = CraftItemStack.copyNMSStack(stack, 1);
                stack.h(1);
            }
            return result;
        }

        @Override
        public void a(int i2, ItemStack itemstack) {
            this.items.set(i2, itemstack);
            if (itemstack != ItemStack.b && this.ac_() > 0 && itemstack.L() > this.ac_()) {
                itemstack.f(this.ac_());
            }
        }

        @Override
        public int ac_() {
            return this.maxStack;
        }

        @Override
        public void setMaxStackSize(int size) {
            this.maxStack = size;
        }

        @Override
        public void e() {
        }

        @Override
        public boolean a(EntityHuman entityhuman) {
            return true;
        }

        @Override
        public List<ItemStack> getContents() {
            return this.items;
        }

        @Override
        public void onOpen(CraftHumanEntity who) {
            this.viewers.add(who);
        }

        @Override
        public void onClose(CraftHumanEntity who) {
            this.viewers.remove(who);
        }

        @Override
        public List<HumanEntity> getViewers() {
            return this.viewers;
        }

        public InventoryType getType() {
            return this.type;
        }

        @Override
        public InventoryHolder getOwner() {
            return this.owner;
        }

        @Override
        public boolean b(int i2, ItemStack itemstack) {
            return true;
        }

        @Override
        public void d_(EntityHuman entityHuman) {
        }

        @Override
        public void c(EntityHuman entityHuman) {
        }

        @Override
        public void a() {
            this.items.clear();
        }

        @Override
        public Location getLocation() {
            return null;
        }

        public String getTitle() {
            return this.title;
        }

        @Override
        public boolean ab_() {
            ItemStack itemstack;
            Iterator iterator = this.items.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((itemstack = (ItemStack)iterator.next()).b());
            return false;
        }
    }
}

