/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.IMerchant;
import net.minecraft.world.item.trading.MerchantRecipe;
import net.minecraft.world.item.trading.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchant;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;

public class CraftMerchantCustom
extends CraftMerchant {
    public CraftMerchantCustom(String title) {
        super(new MinecraftMerchant(title));
        this.getMerchant().craftMerchant = this;
    }

    public String toString() {
        return "CraftMerchantCustom";
    }

    @Override
    public MinecraftMerchant getMerchant() {
        return (MinecraftMerchant)super.getMerchant();
    }

    public static class MinecraftMerchant
    implements IMerchant {
        private final IChatBaseComponent title;
        private final MerchantRecipeList trades = new MerchantRecipeList();
        private EntityHuman tradingPlayer;
        protected CraftMerchant craftMerchant;

        public MinecraftMerchant(String title) {
            Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"Title cannot be null");
            this.title = CraftChatMessage.fromString(title)[0];
        }

        @Override
        public CraftMerchant getCraftMerchant() {
            return this.craftMerchant;
        }

        @Override
        public void f(EntityHuman entityhuman) {
            this.tradingPlayer = entityhuman;
        }

        @Override
        public EntityHuman fY() {
            return this.tradingPlayer;
        }

        @Override
        public MerchantRecipeList ga() {
            return this.trades;
        }

        @Override
        public void a(MerchantRecipe merchantrecipe) {
            merchantrecipe.j();
        }

        @Override
        public void l(ItemStack itemstack) {
        }

        public IChatBaseComponent getScoreboardDisplayName() {
            return this.title;
        }

        @Override
        public int r() {
            return 0;
        }

        @Override
        public void t(int i2) {
        }

        @Override
        public boolean gb() {
            return false;
        }

        @Override
        public SoundEffect gc() {
            return SoundEffects.yH;
        }

        @Override
        public void a(MerchantRecipeList merchantrecipelist) {
        }

        @Override
        public boolean gg() {
            return false;
        }
    }
}

