/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.map;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.minecraft.SystemUtils;
import org.bukkit.map.MapPalette;

public class CraftMapColorCache
implements MapPalette.MapColorCache {
    private static final String MD5_CACHE_HASH = "E88EDD068D12D39934B40E8B6B124C83";
    private static final File CACHE_FILE = new File("map-color-cache.dat");
    private byte[] cache;
    private final Logger logger;
    private boolean cached = false;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public CraftMapColorCache(Logger logger) {
        this.logger = logger;
    }

    public static void main(String[] args) {
        CraftMapColorCache craftMapColorCache = new CraftMapColorCache(Logger.getGlobal());
        craftMapColorCache.buildCache();
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(craftMapColorCache.cache);
            System.out.println("MD5_CACHE_HASH: " + CraftMapColorCache.bytesToString(hash));
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
    }

    public static String bytesToString(byte[] bytes) {
        char[] chars = "0123456789ABCDEF".toCharArray();
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n2 = bytes.length;
        int n3 = 0;
        while (n3 < n2) {
            byte value = byArray[n3];
            int first = (value & 0xF0) >> 4;
            int second = value & 0xF;
            builder.append(chars[first]);
            builder.append(chars[second]);
            ++n3;
        }
        return builder.toString();
    }

    public CompletableFuture<Void> initCache() {
        byte[] fileContent;
        Preconditions.checkState((!this.cached && !this.running.getAndSet(true) ? 1 : 0) != 0, (Object)"Cache is already build or is currently being build");
        this.cache = new byte[0x1000000];
        if (CACHE_FILE.exists()) {
            byte[] hash;
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (InflaterInputStream inputStream = new InflaterInputStream(new FileInputStream(CACHE_FILE));){
                    fileContent = inputStream.readAllBytes();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e2) {
                this.logger.warning("Error while reading map color cache");
                e2.printStackTrace();
                return CompletableFuture.completedFuture(null);
            }
            try {
                hash = MessageDigest.getInstance("MD5").digest(fileContent);
            }
            catch (NoSuchAlgorithmException e3) {
                this.logger.warning("Error while hashing map color cache");
                e3.printStackTrace();
                return CompletableFuture.completedFuture(null);
            }
            if (!MD5_CACHE_HASH.equals(CraftMapColorCache.bytesToString(hash))) {
                this.logger.info("Map color cache hash invalid, rebuilding cache in the background");
                return this.buildAndSaveCache();
            }
        } else {
            this.logger.info("Map color cache not found, building it in the background");
            return this.buildAndSaveCache();
        }
        System.arraycopy(fileContent, 0, this.cache, 0, fileContent.length);
        this.cached = true;
        return CompletableFuture.completedFuture(null);
    }

    private void buildCache() {
        int r2 = 0;
        while (r2 < 256) {
            int g2 = 0;
            while (g2 < 256) {
                int b2 = 0;
                while (b2 < 256) {
                    Color color = new Color(r2, g2, b2);
                    this.cache[this.toInt((Color)color)] = MapPalette.matchColor((Color)color);
                    ++b2;
                }
                ++g2;
            }
            ++r2;
        }
    }

    private CompletableFuture<Void> buildAndSaveCache() {
        return CompletableFuture.runAsync(() -> {
            this.buildCache();
            if (!CACHE_FILE.exists()) {
                try {
                    if (!CACHE_FILE.createNewFile()) {
                        this.cached = true;
                        return;
                    }
                }
                catch (IOException e2) {
                    this.logger.warning("Error while building map color cache");
                    e2.printStackTrace();
                    this.cached = true;
                    return;
                }
            }
            try {
                Throwable e2 = null;
                Object var2_5 = null;
                try (DeflaterOutputStream outputStream = new DeflaterOutputStream(new FileOutputStream(CACHE_FILE));){
                    ((OutputStream)outputStream).write(this.cache);
                }
                catch (Throwable throwable) {
                    if (e2 == null) {
                        e2 = throwable;
                    } else if (e2 != throwable) {
                        e2.addSuppressed(throwable);
                    }
                    throw e2;
                }
            }
            catch (IOException e3) {
                this.logger.warning("Error while building map color cache");
                e3.printStackTrace();
                this.cached = true;
                return;
            }
            this.cached = true;
            this.logger.info("Map color cache build successfully");
        }, SystemUtils.f());
    }

    private int toInt(Color color) {
        return color.getRGB() & 0xFFFFFF;
    }

    public boolean isCached() {
        return this.cached || !this.running.get() && this.initCache().isDone();
    }

    public byte matchColor(Color color) {
        Preconditions.checkState((boolean)this.isCached(), (Object)"Cache not build jet");
        return this.cache[this.toInt(color)];
    }
}

