/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.packs;

import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import org.bukkit.Bukkit;
import org.bukkit.FeatureFlag;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.CraftFeatureFlag;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.packs.DataPack;

public class CraftDataPack
implements DataPack {
    private final ResourcePackLoader handle;

    public CraftDataPack(ResourcePackLoader handler) {
        this.handle = handler;
    }

    public ResourcePackLoader getHandle() {
        return this.handle;
    }

    public String getRawId() {
        return this.getHandle().f();
    }

    public String getTitle() {
        return CraftChatMessage.fromComponent(this.getHandle().a());
    }

    public String getDescription() {
        return CraftChatMessage.fromComponent(this.getHandle().b());
    }

    public int getPackFormat() {
        ResourcePackLoader.a info = ResourcePackLoader.a(this.getRawId(), this.getHandle().c);
        return info == null ? 0 : info.b();
    }

    public boolean isRequired() {
        return this.getHandle().g();
    }

    public DataPack.Compatibility getCompatibility() {
        return switch (this.getHandle().c()) {
            case EnumResourcePackVersion.c -> DataPack.Compatibility.COMPATIBLE;
            case EnumResourcePackVersion.b -> DataPack.Compatibility.NEW;
            case EnumResourcePackVersion.a -> DataPack.Compatibility.OLD;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public boolean isEnabled() {
        return ((CraftServer)Bukkit.getServer()).getServer().aB().d().contains(this.getRawId());
    }

    public DataPack.Source getSource() {
        if (this.getHandle().j() == PackSource.c) {
            return DataPack.Source.BUILT_IN;
        }
        if (this.getHandle().j() == PackSource.d) {
            return DataPack.Source.FEATURE;
        }
        if (this.getHandle().j() == PackSource.e) {
            return DataPack.Source.WORLD;
        }
        if (this.getHandle().j() == PackSource.f) {
            return DataPack.Source.SERVER;
        }
        return DataPack.Source.DEFAULT;
    }

    public Set<FeatureFlag> getRequestedFeatures() {
        return CraftFeatureFlag.getFromNMS(this.getHandle().d()).stream().map(FeatureFlag.class::cast).collect(Collectors.toUnmodifiableSet());
    }

    public NamespacedKey getKey() {
        return NamespacedKey.fromString((String)this.getRawId());
    }

    public String toString() {
        String requestedFeatures = this.getRequestedFeatures().stream().map(featureFlag -> featureFlag.getKey().toString()).collect(Collectors.joining(","));
        return "CraftDataPack{rawId=" + this.getRawId() + ",id=" + this.getKey() + ",title=" + this.getTitle() + ",description=" + this.getDescription() + ",packformat=" + this.getPackFormat() + ",compatibility=" + this.getCompatibility() + ",source=" + this.getSource() + ",enabled=" + this.isEnabled() + ",requestedFeatures=[" + requestedFeatures + "]}";
    }
}

