/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import com.google.common.base.Preconditions;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final ScoreboardObjective objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, ScoreboardObjective objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    ScoreboardObjective getHandle() {
        return this.objective;
    }

    public String getName() throws IllegalStateException {
        this.checkState();
        return this.objective.b();
    }

    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.objective.d());
    }

    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        Preconditions.checkArgument((displayName.length() <= 128 ? 1 : 0) != 0, (Object)("Display name '" + displayName + "' is longer than the limit of 128 characters"));
        this.checkState();
        this.objective.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getCriteria() throws IllegalStateException {
        this.checkState();
        return this.criteria.bukkitName;
    }

    public Criteria getTrackedCriteria() throws IllegalStateException {
        this.checkState();
        return this.criteria;
    }

    public boolean isModifiable() throws IllegalStateException {
        this.checkState();
        return !this.criteria.criteria.e();
    }

    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        int i2 = 0;
        while (i2 < 19) {
            if (board.a(i2) == objective) {
                board.a(i2, null);
            }
            ++i2;
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.a(slotNumber, this.getHandle());
        }
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        int i2 = 0;
        while (i2 < 19) {
            if (board.a(i2) == objective) {
                return CraftScoreboardTranslations.toBukkitSlot(i2);
            }
            ++i2;
        }
        return null;
    }

    public void setRenderType(RenderType renderType) throws IllegalStateException {
        Preconditions.checkArgument((renderType != null ? 1 : 0) != 0, (Object)"RenderType cannot be null");
        this.checkState();
        this.objective.a(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    public RenderType getRenderType() throws IllegalStateException {
        this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.f());
    }

    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"Player cannot be null");
        this.checkState();
        return new CraftScore(this, player.getName());
    }

    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        Preconditions.checkArgument((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)("Score '" + entry + "' is longer than the limit of 32767 characters"));
        this.checkState();
        return new CraftScore(this, entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.j(this.objective);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        Preconditions.checkState((this.getScoreboard().board.d(this.objective.b()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

