/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final ScoreboardTeam team;

    CraftTeam(CraftScoreboard scoreboard, ScoreboardTeam team) {
        super(scoreboard);
        this.team = team;
    }

    public String getName() throws IllegalStateException {
        this.checkState();
        return this.team.b();
    }

    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.c());
    }

    public void setDisplayName(String displayName) throws IllegalStateException {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        int lengthStripedDisplayName = ChatColor.stripColor((String)displayName).length();
        Preconditions.checkArgument((lengthStripedDisplayName <= 128 ? 1 : 0) != 0, (String)"Display name '%s' is longer than the limit of 128 characters (%s)", (Object)displayName, (int)lengthStripedDisplayName);
        this.checkState();
        this.team.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getPrefix() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.e());
    }

    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        int lengthStripedPrefix = ChatColor.stripColor((String)prefix).length();
        Preconditions.checkArgument((lengthStripedPrefix <= 64 ? 1 : 0) != 0, (String)"Prefix '%s' is longer than the limit of 64 characters (%s)", (Object)prefix, (int)lengthStripedPrefix);
        this.checkState();
        this.team.b(CraftChatMessage.fromStringOrNull(prefix));
    }

    public String getSuffix() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.f());
    }

    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        int lengthStripedSuffix = ChatColor.stripColor((String)suffix).length();
        Preconditions.checkArgument((lengthStripedSuffix <= 64 ? 1 : 0) != 0, (String)"Suffix '%s' is longer than the limit of 64 characters (%s)", (Object)suffix, (int)lengthStripedSuffix);
        this.team.c(CraftChatMessage.fromStringOrNull(suffix));
    }

    public ChatColor getColor() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.getColor(this.team.n());
    }

    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
        this.checkState();
        this.team.a(CraftChatMessage.getColor(color));
    }

    public boolean allowFriendlyFire() throws IllegalStateException {
        this.checkState();
        return this.team.h();
    }

    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.a(enabled);
    }

    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        this.checkState();
        return this.team.i();
    }

    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.b(enabled);
    }

    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.j());
    }

    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.a(CraftTeam.bukkitToNotch(visibility));
    }

    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            players.add((Object)Bukkit.getOfflinePlayer((String)playerName));
        }
        return players.build();
    }

    public Set<String> getEntries() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.g()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    public int getSize() throws IllegalStateException {
        this.checkState();
        return this.team.g().size();
    }

    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.a(entry, this.team);
    }

    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.g().contains(entry)) {
            return false;
        }
        scoreboard.board.b(entry, this.team);
        return true;
    }

    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.g().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.d(this.team);
    }

    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.j().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.k().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.l().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + option);
    }

    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.a(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.b(ScoreboardTeamBase.EnumNameTagVisibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.a(ScoreboardTeamBase.EnumTeamPush.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + option);
            }
        }
    }

    public static ScoreboardTeamBase.EnumNameTagVisibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.a;
            }
            case NEVER: {
                return ScoreboardTeamBase.EnumNameTagVisibility.b;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return ScoreboardTeamBase.EnumNameTagVisibility.c;
            }
            case HIDE_FOR_OWN_TEAM: {
                return ScoreboardTeamBase.EnumNameTagVisibility.d;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    public static NameTagVisibility notchToBukkit(ScoreboardTeamBase.EnumNameTagVisibility visibility) {
        switch (visibility) {
            case a: {
                return NameTagVisibility.ALWAYS;
            }
            case b: {
                return NameTagVisibility.NEVER;
            }
            case c: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case d: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + (Object)((Object)visibility));
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        Preconditions.checkState((this.getScoreboard().board.f(this.team.b()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

