/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHexColor;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.bukkit.ChatColor;

public final class CraftChatMessage {
    private static final Pattern LINK_PATTERN = Pattern.compile("((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))");
    private static final Map<Character, EnumChatFormat> formatMap;

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        EnumChatFormat[] enumChatFormatArray = EnumChatFormat.values();
        int n2 = enumChatFormatArray.length;
        int n3 = 0;
        while (n3 < n2) {
            EnumChatFormat format = enumChatFormatArray[n3];
            builder.put((Object)Character.valueOf(Character.toLowerCase(format.toString().charAt(1))), (Object)format);
            ++n3;
        }
        formatMap = builder.build();
    }

    public static EnumChatFormat getColor(ChatColor color) {
        return formatMap.get(Character.valueOf(color.getChar()));
    }

    public static ChatColor getColor(EnumChatFormat format) {
        return ChatColor.getByChar((char)format.B);
    }

    public static IChatBaseComponent fromStringOrNull(String message) {
        return CraftChatMessage.fromStringOrNull(message, false);
    }

    public static IChatBaseComponent fromStringOrNull(String message, boolean keepNewlines) {
        return message == null || message.isEmpty() ? null : CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static IChatBaseComponent[] fromString(String message) {
        return CraftChatMessage.fromString(message, false);
    }

    public static IChatBaseComponent[] fromString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromString(message, keepNewlines, false);
    }

    public static IChatBaseComponent[] fromString(String message, boolean keepNewlines, boolean plain) {
        return new StringMessage(message, keepNewlines, plain).getOutput();
    }

    public static String toJSON(IChatBaseComponent component) {
        return IChatBaseComponent.ChatSerializer.a(component);
    }

    public static String toJSONOrNull(IChatBaseComponent component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.toJSON(component);
    }

    public static IChatBaseComponent fromJSON(String jsonMessage) throws JsonParseException {
        return IChatBaseComponent.ChatSerializer.a(jsonMessage);
    }

    public static IChatBaseComponent fromJSONOrNull(String jsonMessage) {
        if (jsonMessage == null) {
            return null;
        }
        try {
            return CraftChatMessage.fromJSON(jsonMessage);
        }
        catch (JsonParseException ex) {
            return null;
        }
    }

    public static IChatBaseComponent fromJSONOrString(String message) {
        return CraftChatMessage.fromJSONOrString(message, false);
    }

    public static IChatBaseComponent fromJSONOrString(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrString(message, false, keepNewlines);
    }

    private static IChatBaseComponent fromJSONOrString(String message, boolean nullable, boolean keepNewlines) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        IChatBaseComponent component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            return component;
        }
        return CraftChatMessage.fromString(message, keepNewlines)[0];
    }

    public static String fromJSONOrStringToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, false, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message) {
        return CraftChatMessage.fromJSONOrStringOrNullToJSON(message, false);
    }

    public static String fromJSONOrStringOrNullToJSON(String message, boolean keepNewlines) {
        return CraftChatMessage.fromJSONOrStringToJSON(message, true, keepNewlines, Integer.MAX_VALUE, false);
    }

    public static String fromJSONOrStringToJSON(String message, boolean nullable, boolean keepNewlines, int maxLength, boolean checkJsonContentLength) {
        if (message == null) {
            message = "";
        }
        if (nullable && message.isEmpty()) {
            return null;
        }
        IChatBaseComponent component = CraftChatMessage.fromJSONOrNull(message);
        if (component != null) {
            String trimmedContent;
            String content;
            if (checkJsonContentLength && (content = CraftChatMessage.fromComponent(component)) != (trimmedContent = CraftChatMessage.trimMessage(content, maxLength))) {
                return CraftChatMessage.fromStringToJSON(trimmedContent, keepNewlines);
            }
            return message;
        }
        message = CraftChatMessage.trimMessage(message, maxLength);
        return CraftChatMessage.fromStringToJSON(message, keepNewlines);
    }

    public static String trimMessage(String message, int maxLength) {
        if (message != null && message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }

    public static String fromStringToJSON(String message) {
        return CraftChatMessage.fromStringToJSON(message, false);
    }

    public static String fromStringToJSON(String message, boolean keepNewlines) {
        IChatBaseComponent component = CraftChatMessage.fromString(message, keepNewlines)[0];
        return CraftChatMessage.toJSON(component);
    }

    public static String fromStringOrNullToJSON(String message) {
        IChatBaseComponent component = CraftChatMessage.fromStringOrNull(message);
        return CraftChatMessage.toJSONOrNull(component);
    }

    public static String fromJSONComponent(String jsonMessage) {
        IChatBaseComponent component = CraftChatMessage.fromJSONOrNull(jsonMessage);
        return CraftChatMessage.fromComponent(component);
    }

    public static String fromComponent(IChatBaseComponent component) {
        if (component == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        boolean hadFormat = false;
        for (IChatBaseComponent c2 : component) {
            ChatModifier modi = c2.a();
            ChatHexColor color = modi.a();
            if (c2.b() != ComponentContents.a || color != null) {
                if (color != null) {
                    if (color.format != null) {
                        out.append(color.format);
                    } else {
                        out.append('\u00a7').append("x");
                        char[] cArray = color.b().substring(1).toCharArray();
                        int n2 = cArray.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            char magic = cArray[n3];
                            out.append('\u00a7').append(magic);
                            ++n3;
                        }
                    }
                    hadFormat = true;
                } else if (hadFormat) {
                    out.append(ChatColor.RESET);
                    hadFormat = false;
                }
            }
            if (modi.b()) {
                out.append(EnumChatFormat.r);
                hadFormat = true;
            }
            if (modi.c()) {
                out.append(EnumChatFormat.u);
                hadFormat = true;
            }
            if (modi.e()) {
                out.append(EnumChatFormat.t);
                hadFormat = true;
            }
            if (modi.d()) {
                out.append(EnumChatFormat.s);
                hadFormat = true;
            }
            if (modi.f()) {
                out.append(EnumChatFormat.q);
                hadFormat = true;
            }
            c2.b().a(x2 -> {
                out.append(x2);
                return Optional.empty();
            });
        }
        return out.toString();
    }

    public static IChatBaseComponent fixComponent(IChatMutableComponent component) {
        Matcher matcher = LINK_PATTERN.matcher("");
        return CraftChatMessage.fixComponent(component, matcher);
    }

    private static IChatBaseComponent fixComponent(IChatMutableComponent component, Matcher matcher) {
        LiteralContents text;
        String msg;
        if (component.b() instanceof LiteralContents && matcher.reset(msg = (text = (LiteralContents)component.b()).a()).find()) {
            matcher.reset();
            ChatModifier modifier = component.a();
            ArrayList<IChatBaseComponent> extras = new ArrayList<IChatBaseComponent>();
            ArrayList<IChatBaseComponent> extrasOld = new ArrayList<IChatBaseComponent>(component.c());
            component = IChatBaseComponent.h();
            int pos = 0;
            while (matcher.find()) {
                String match = matcher.group();
                if (!match.startsWith("http://") && !match.startsWith("https://")) {
                    match = "http://" + match;
                }
                IChatMutableComponent prev = IChatBaseComponent.b(msg.substring(pos, matcher.start()));
                prev.b(modifier);
                extras.add(prev);
                IChatMutableComponent link = IChatBaseComponent.b(matcher.group());
                ChatModifier linkModi = modifier.a(new ChatClickable(ChatClickable.EnumClickAction.a, match));
                link.b(linkModi);
                extras.add(link);
                pos = matcher.end();
            }
            IChatMutableComponent prev = IChatBaseComponent.b(msg.substring(pos));
            prev.b(modifier);
            extras.add(prev);
            extras.addAll(extrasOld);
            for (IChatBaseComponent c2 : extras) {
                component.b(c2);
            }
        }
        List<IChatBaseComponent> extras = component.c();
        int i2 = 0;
        while (i2 < extras.size()) {
            IChatBaseComponent comp = extras.get(i2);
            if (comp.a() != null && comp.a().h() == null) {
                extras.set(i2, CraftChatMessage.fixComponent(comp.e(), matcher));
            }
            ++i2;
        }
        if (component.b() instanceof TranslatableContents) {
            Object[] subs = ((TranslatableContents)component.b()).c();
            int i3 = 0;
            while (i3 < subs.length) {
                Object comp = subs[i3];
                if (comp instanceof IChatBaseComponent) {
                    IChatBaseComponent c3 = (IChatBaseComponent)comp;
                    if (c3.a() != null && c3.a().h() == null) {
                        subs[i3] = CraftChatMessage.fixComponent(c3.e(), matcher);
                    }
                } else if (comp instanceof String && matcher.reset((String)comp).find()) {
                    subs[i3] = CraftChatMessage.fixComponent(IChatBaseComponent.b((String)comp), matcher);
                }
                ++i3;
            }
        }
        return component;
    }

    private CraftChatMessage() {
    }

    private static final class StringMessage {
        private static final Pattern INCREMENTAL_PATTERN = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " \\n]|$))))|(\\n)", 2);
        private static final Pattern INCREMENTAL_PATTERN_KEEP_NEWLINES = Pattern.compile("(" + String.valueOf('\u00a7') + "[0-9a-fk-orx])|((?:(?:https?):\\/\\/)?(?:[-\\w_\\.]{2,}\\.[a-z]{2,4}.*?(?=[\\.\\?!,;:]?(?:[" + String.valueOf('\u00a7') + " ]|$))))", 2);
        private static final ChatModifier RESET = ChatModifier.a.a(false).b(false).c(false).d(false).e(false);
        private final List<IChatBaseComponent> list = new ArrayList<IChatBaseComponent>();
        private IChatMutableComponent currentChatComponent = IChatBaseComponent.h();
        private ChatModifier modifier = ChatModifier.a;
        private final IChatBaseComponent[] output;
        private int currentIndex;
        private StringBuilder hex;
        private final String message;
        private static volatile /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$EnumChatFormat;

        /*
         * Unable to fully structure code
         */
        private StringMessage(String message, boolean keepNewlines, boolean plain) {
            super();
            this.message = message;
            if (message == null) {
                this.output = new IChatBaseComponent[]{this.currentChatComponent};
                return;
            }
            this.list.add(this.currentChatComponent);
            matcher = (keepNewlines != false ? StringMessage.INCREMENTAL_PATTERN_KEEP_NEWLINES : StringMessage.INCREMENTAL_PATTERN).matcher(message);
            match = null;
            needsAdd = false;
            while (matcher.find()) {
                groupId = 0;
                while ((match = matcher.group(++groupId)) == null) {
                }
                index = matcher.start(groupId);
                if (index > this.currentIndex) {
                    needsAdd = false;
                    this.appendNewComponent(index);
                }
                switch (groupId) {
                    case 1: {
                        c = match.toLowerCase(Locale.ENGLISH).charAt(1);
                        format = CraftChatMessage.formatMap.get(Character.valueOf(c));
                        if (c != 'x') ** GOTO lbl29
                        this.hex = new StringBuilder("#");
                        ** GOTO lbl56
lbl29:
                        // 1 sources

                        if (this.hex == null) ** GOTO lbl36
                        this.hex.append(c);
                        if (this.hex.length() == 7) {
                            this.modifier = StringMessage.RESET.a(ChatHexColor.a(this.hex.toString()));
                            this.hex = null;
                        }
                        ** GOTO lbl56
lbl36:
                        // 1 sources

                        if (!format.d() || format == EnumChatFormat.v) ** GOTO lbl55
                        switch (StringMessage.$SWITCH_TABLE$net$minecraft$EnumChatFormat()[format.ordinal()]) {
                            case 18: {
                                this.modifier = this.modifier.a(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 21: {
                                this.modifier = this.modifier.b(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 19: {
                                this.modifier = this.modifier.d(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 20: {
                                this.modifier = this.modifier.c(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            case 17: {
                                this.modifier = this.modifier.e(Boolean.TRUE);
                                ** GOTO lbl56
                            }
                            default: {
                                throw new AssertionError((Object)"Unexpected message format");
                            }
                        }
lbl55:
                        // 1 sources

                        this.modifier = StringMessage.RESET.a(format);
lbl56:
                        // 8 sources

                        needsAdd = true;
                        break;
                    }
                    case 2: {
                        if (plain) {
                            this.appendNewComponent(matcher.end(groupId));
                            break;
                        }
                        if (!match.startsWith("http://") && !match.startsWith("https://")) {
                            match = "http://" + match;
                        }
                        this.modifier = this.modifier.a(new ChatClickable(ChatClickable.EnumClickAction.a, match));
                        this.appendNewComponent(matcher.end(groupId));
                        this.modifier = this.modifier.a((ChatClickable)null);
                        break;
                    }
                    case 3: {
                        if (needsAdd) {
                            this.appendNewComponent(index);
                        }
                        this.currentChatComponent = null;
                    }
                }
                this.currentIndex = matcher.end(groupId);
            }
            if (this.currentIndex < message.length() || needsAdd) {
                this.appendNewComponent(message.length());
            }
            this.output = this.list.toArray(new IChatBaseComponent[this.list.size()]);
        }

        private void appendNewComponent(int index) {
            IChatMutableComponent addition = IChatBaseComponent.b(this.message.substring(this.currentIndex, index)).b(this.modifier);
            this.currentIndex = index;
            if (this.currentChatComponent == null) {
                this.currentChatComponent = IChatBaseComponent.h();
                this.list.add(this.currentChatComponent);
            }
            this.currentChatComponent.b(addition);
        }

        private IChatBaseComponent[] getOutput() {
            return this.output;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$net$minecraft$EnumChatFormat() {
            if ($SWITCH_TABLE$net$minecraft$EnumChatFormat != null) {
                return $SWITCH_TABLE$net$minecraft$EnumChatFormat;
            }
            int[] nArray = new int[EnumChatFormat.values().length];
            try {
                nArray[EnumChatFormat.l.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.a.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.j.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.r.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.d.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.b.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.i.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.c.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.f.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.e.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.g.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.h.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.k.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.u.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.n.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.q.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.m.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.v.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.s.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.t.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.p.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[EnumChatFormat.o.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$net$minecraft$EnumChatFormat = nArray;
            return nArray;
        }
    }
}

