/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import net.minecraft.server.MinecraftServer;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TicksPerSecondCommand
extends Command {
    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        StringBuilder sb = new StringBuilder(ChatColor.GOLD + "TPS from last 1m, 5m, 15m: ");
        double[] dArray = MinecraftServer.getServer().recentTps;
        int n2 = MinecraftServer.getServer().recentTps.length;
        int n3 = 0;
        while (n3 < n2) {
            double tps = dArray[n3];
            sb.append(this.format(tps));
            sb.append(", ");
            ++n3;
        }
        sender.sendMessage(sb.substring(0, sb.length() - 2));
        sender.sendMessage(ChatColor.GOLD + "Current Memory Usage: " + ChatColor.GREEN + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + " mb (Max: " + Runtime.getRuntime().maxMemory() / 0x100000L + " mb)");
        return true;
    }

    private String format(double tps) {
        return String.valueOf((tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED)).toString()) + (tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

