/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicates;
import net.minecraft.advancements.critereon.GameTypePredicate;
import net.minecraft.advancements.critereon.InputPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record PlayerPredicate(MinMaxBounds.Ints level, GameTypePredicate gameType, List<StatMatcher<?>> stats, Object2BooleanMap<ResourceKey<Recipe<?>>> recipes, Map<ResourceLocation, AdvancementPredicate> advancements, Optional<EntityPredicate> lookingAt, Optional<InputPredicate> input) implements EntitySubPredicate
{
    public static final int LOOKING_AT_RANGE = 100;
    public static final MapCodec<PlayerPredicate> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MinMaxBounds.Ints.CODEC.optionalFieldOf("level", (Object)MinMaxBounds.Ints.ANY).forGetter(PlayerPredicate::level), (App)GameTypePredicate.CODEC.optionalFieldOf("gamemode", (Object)GameTypePredicate.ANY).forGetter(PlayerPredicate::gameType), (App)StatMatcher.CODEC.listOf().optionalFieldOf("stats", List.of()).forGetter(PlayerPredicate::stats), (App)ExtraCodecs.object2BooleanMap(Recipe.KEY_CODEC).optionalFieldOf("recipes", (Object)Object2BooleanMaps.emptyMap()).forGetter(PlayerPredicate::recipes), (App)Codec.unboundedMap(ResourceLocation.CODEC, AdvancementPredicate.CODEC).optionalFieldOf("advancements", Map.of()).forGetter(PlayerPredicate::advancements), (App)EntityPredicate.CODEC.optionalFieldOf("looking_at").forGetter(PlayerPredicate::lookingAt), (App)InputPredicate.CODEC.optionalFieldOf("input").forGetter(PlayerPredicate::input)).apply((Applicative)var0, PlayerPredicate::new));

    @Override
    public boolean matches(Entity var02, ServerLevel var1, @Nullable Vec3 var2) {
        Object var10;
        Object var7;
        if (!(var02 instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer var3 = (ServerPlayer)var02;
        if (!this.level.matches(var3.experienceLevel)) {
            return false;
        }
        if (!this.gameType.matches(var3.gameMode())) {
            return false;
        }
        ServerStatsCounter var4 = var3.getStats();
        for (StatMatcher<?> statMatcher : this.stats) {
            if (statMatcher.matches(var4)) continue;
            return false;
        }
        ServerRecipeBook var5 = var3.getRecipeBook();
        for (Object2BooleanMap.Entry var72 : this.recipes.object2BooleanEntrySet()) {
            if (var5.contains((ResourceKey)var72.getKey()) == var72.getBooleanValue()) continue;
            return false;
        }
        if (!this.advancements.isEmpty()) {
            PlayerAdvancements playerAdvancements = var3.getAdvancements();
            var7 = var3.level().getServer().getAdvancements();
            for (Map.Entry<ResourceLocation, AdvancementPredicate> entry : this.advancements.entrySet()) {
                var10 = ((ServerAdvancementManager)var7).get(entry.getKey());
                if (var10 != null && entry.getValue().test(playerAdvancements.getOrStartProgress((AdvancementHolder)var10))) continue;
                return false;
            }
        }
        if (this.lookingAt.isPresent()) {
            Vec3 vec3 = var3.getEyePosition();
            var7 = var3.getViewVector(1.0f);
            Vec3 var8 = vec3.add(((Vec3)var7).x * 100.0, ((Vec3)var7).y * 100.0, ((Vec3)var7).z * 100.0);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult(var3.level(), var3, vec3, var8, new AABB(vec3, var8).inflate(1.0), var0 -> !var0.isSpectator(), 0.0f);
            if (entityHitResult == null || entityHitResult.getType() != HitResult.Type.ENTITY) {
                return false;
            }
            var10 = entityHitResult.getEntity();
            if (!this.lookingAt.get().matches(var3, (Entity)var10) || !var3.hasLineOfSight((Entity)var10)) {
                return false;
            }
        }
        return !this.input.isPresent() || this.input.get().matches(var3.getLastClientInput());
    }

    public MapCodec<PlayerPredicate> codec() {
        return EntitySubPredicates.PLAYER;
    }

    record StatMatcher<T>(StatType<T> type, Holder<T> value, MinMaxBounds.Ints range, Supplier<Stat<T>> stat) {
        public static final Codec<StatMatcher<?>> CODEC = BuiltInRegistries.STAT_TYPE.byNameCodec().dispatch(StatMatcher::type, StatMatcher::createTypedCodec);

        public StatMatcher(StatType<T> var0, Holder<T> var1, MinMaxBounds.Ints var2) {
            this(var0, var1, var2, (Supplier<Stat<T>>)Suppliers.memoize(() -> var0.get(var1.value())));
        }

        private static <T> MapCodec<StatMatcher<T>> createTypedCodec(StatType<T> var0) {
            return RecordCodecBuilder.mapCodec(var12 -> var12.group((App)var0.getRegistry().holderByNameCodec().fieldOf("stat").forGetter(StatMatcher::value), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("value", (Object)MinMaxBounds.Ints.ANY).forGetter(StatMatcher::range)).apply((Applicative)var12, (var1, var2) -> new StatMatcher(var0, var1, (MinMaxBounds.Ints)var2)));
        }

        public boolean matches(StatsCounter var0) {
            return this.range.matches(var0.getValue(this.stat.get()));
        }
    }

    static interface AdvancementPredicate
    extends Predicate<AdvancementProgress> {
        public static final Codec<AdvancementPredicate> CODEC = Codec.either(AdvancementDonePredicate.CODEC, AdvancementCriterionsPredicate.CODEC).xmap(Either::unwrap, var0 -> {
            if (var0 instanceof AdvancementDonePredicate) {
                AdvancementDonePredicate var1 = (AdvancementDonePredicate)var0;
                return Either.left((Object)var1);
            }
            if (var0 instanceof AdvancementCriterionsPredicate) {
                AdvancementCriterionsPredicate var2 = (AdvancementCriterionsPredicate)var0;
                return Either.right((Object)var2);
            }
            throw new UnsupportedOperationException();
        });
    }

    public static class Builder {
        private MinMaxBounds.Ints level = MinMaxBounds.Ints.ANY;
        private GameTypePredicate gameType = GameTypePredicate.ANY;
        private final ImmutableList.Builder<StatMatcher<?>> stats = ImmutableList.builder();
        private final Object2BooleanMap<ResourceKey<Recipe<?>>> recipes = new Object2BooleanOpenHashMap();
        private final Map<ResourceLocation, AdvancementPredicate> advancements = Maps.newHashMap();
        private Optional<EntityPredicate> lookingAt = Optional.empty();
        private Optional<InputPredicate> input = Optional.empty();

        public static Builder player() {
            return new Builder();
        }

        public Builder setLevel(MinMaxBounds.Ints var0) {
            this.level = var0;
            return this;
        }

        public <T> Builder addStat(StatType<T> var0, Holder.Reference<T> var1, MinMaxBounds.Ints var2) {
            this.stats.add(new StatMatcher<T>(var0, var1, var2));
            return this;
        }

        public Builder addRecipe(ResourceKey<Recipe<?>> var0, boolean var1) {
            this.recipes.put(var0, var1);
            return this;
        }

        public Builder setGameType(GameTypePredicate var0) {
            this.gameType = var0;
            return this;
        }

        public Builder setLookingAt(EntityPredicate.Builder var0) {
            this.lookingAt = Optional.of(var0.build());
            return this;
        }

        public Builder checkAdvancementDone(ResourceLocation var0, boolean var1) {
            this.advancements.put(var0, new AdvancementDonePredicate(var1));
            return this;
        }

        public Builder checkAdvancementCriterions(ResourceLocation var0, Map<String, Boolean> var1) {
            this.advancements.put(var0, new AdvancementCriterionsPredicate((Object2BooleanMap<String>)new Object2BooleanOpenHashMap(var1)));
            return this;
        }

        public Builder hasInput(InputPredicate var0) {
            this.input = Optional.of(var0);
            return this;
        }

        public PlayerPredicate build() {
            return new PlayerPredicate(this.level, this.gameType, (List<StatMatcher<?>>)this.stats.build(), this.recipes, this.advancements, this.lookingAt, this.input);
        }
    }

    record AdvancementCriterionsPredicate(Object2BooleanMap<String> criterions) implements AdvancementPredicate
    {
        public static final Codec<AdvancementCriterionsPredicate> CODEC = ExtraCodecs.object2BooleanMap(Codec.STRING).xmap(AdvancementCriterionsPredicate::new, AdvancementCriterionsPredicate::criterions);

        @Override
        public boolean test(AdvancementProgress var0) {
            for (Object2BooleanMap.Entry var2 : this.criterions.object2BooleanEntrySet()) {
                CriterionProgress var3 = var0.getCriterion((String)var2.getKey());
                if (var3 != null && var3.isDone() == var2.getBooleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }

    record AdvancementDonePredicate(boolean state) implements AdvancementPredicate
    {
        public static final Codec<AdvancementDonePredicate> CODEC = Codec.BOOL.xmap(AdvancementDonePredicate::new, AdvancementDonePredicate::state);

        @Override
        public boolean test(AdvancementProgress var0) {
            return var0.isDone() == this.state;
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((AdvancementProgress)object);
        }
    }
}

