/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinate;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class Vec2Argument
implements ArgumentType<Coordinates> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0", "~ ~", "0.1 -0.5", "~1 ~-2");
    public static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos2d.incomplete"));
    private final boolean centerCorrect;

    public Vec2Argument(boolean var0) {
        this.centerCorrect = var0;
    }

    public static Vec2Argument vec2() {
        return new Vec2Argument(true);
    }

    public static Vec2Argument vec2(boolean var0) {
        return new Vec2Argument(var0);
    }

    public static Vec2 getVec2(CommandContext<CommandSourceStack> var0, String var1) {
        Vec3 var2 = ((Coordinates)var0.getArgument(var1, Coordinates.class)).getPosition((CommandSourceStack)var0.getSource());
        return new Vec2((float)var2.x, (float)var2.z);
    }

    public Coordinates parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        if (!var0.canRead()) {
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        WorldCoordinate var2 = WorldCoordinate.parseDouble(var0, this.centerCorrect);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        WorldCoordinate var3 = WorldCoordinate.parseDouble(var0, this.centerCorrect);
        return new WorldCoordinates(var2, new WorldCoordinate(true, 0.0), var3);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof SharedSuggestionProvider) {
            String var2 = var1.getRemaining();
            Collection<SharedSuggestionProvider.TextCoordinates> var3 = !var2.isEmpty() && var2.charAt(0) == '^' ? Collections.singleton(SharedSuggestionProvider.TextCoordinates.DEFAULT_LOCAL) : ((SharedSuggestionProvider)var0.getSource()).getAbsoluteCoordinates();
            return SharedSuggestionProvider.suggest2DCoordinates(var2, var3, var1, Commands.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

