/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.item.ComponentPredicateParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.parsing.packrat.commands.ParserBasedArgument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemPredicateArgument
extends ParserBasedArgument<Result> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo:'bar'}");
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("argument.item.id.invalid", var0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.item.tag.unknown", var0));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.item.component.unknown", var0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("arguments.item.component.malformed", var0, var1));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_PREDICATE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("arguments.item.predicate.unknown", var0));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_PREDICATE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("arguments.item.predicate.malformed", var0, var1));
    private static final ResourceLocation COUNT_ID = ResourceLocation.withDefaultNamespace("count");
    static final Map<ResourceLocation, ComponentWrapper> PSEUDO_COMPONENTS = Stream.of(new ComponentWrapper(COUNT_ID, var0 -> true, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map(var0 -> var1 -> var0.matches(var1.getCount())))).collect(Collectors.toUnmodifiableMap(ComponentWrapper::id, var0 -> var0));
    static final Map<ResourceLocation, PredicateWrapper> PSEUDO_PREDICATES = Stream.of(new PredicateWrapper(COUNT_ID, (Decoder<? extends Predicate<ItemStack>>)MinMaxBounds.Ints.CODEC.map(var0 -> var1 -> var0.matches(var1.getCount())))).collect(Collectors.toUnmodifiableMap(PredicateWrapper::id, var0 -> var0));

    public ItemPredicateArgument(CommandBuildContext var02) {
        super(ComponentPredicateParser.createGrammar(new Context(var02)).mapResult(var0 -> Util.allOf(var0)::test));
    }

    public static ItemPredicateArgument itemPredicate(CommandBuildContext var0) {
        return new ItemPredicateArgument(var0);
    }

    public static Result getItemPredicate(CommandContext<CommandSourceStack> var0, String var1) {
        return (Result)var0.getArgument(var1, Result.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    static class Context
    implements ComponentPredicateParser.Context<Predicate<ItemStack>, ComponentWrapper, PredicateWrapper> {
        private final HolderLookup.Provider registries;
        private final HolderLookup.RegistryLookup<Item> items;
        private final HolderLookup.RegistryLookup<DataComponentType<?>> components;
        private final HolderLookup.RegistryLookup<DataComponentPredicate.Type<?>> predicates;

        Context(HolderLookup.Provider var0) {
            this.registries = var0;
            this.items = var0.lookupOrThrow(Registries.ITEM);
            this.components = var0.lookupOrThrow(Registries.DATA_COMPONENT_TYPE);
            this.predicates = var0.lookupOrThrow(Registries.DATA_COMPONENT_PREDICATE_TYPE);
        }

        @Override
        public Predicate<ItemStack> forElementType(ImmutableStringReader var0, ResourceLocation var12) throws CommandSyntaxException {
            Holder.Reference<Item> var2 = this.items.get(ResourceKey.create(Registries.ITEM, var12)).orElseThrow(() -> ERROR_UNKNOWN_ITEM.createWithContext(var0, (Object)var12));
            return var1 -> var1.is(var2);
        }

        @Override
        public Predicate<ItemStack> forTagType(ImmutableStringReader var0, ResourceLocation var12) throws CommandSyntaxException {
            HolderSet var2 = this.items.get(TagKey.create(Registries.ITEM, var12)).orElseThrow(() -> ERROR_UNKNOWN_TAG.createWithContext(var0, (Object)var12));
            return var1 -> var1.is(var2);
        }

        @Override
        public ComponentWrapper lookupComponentType(ImmutableStringReader var0, ResourceLocation var1) throws CommandSyntaxException {
            ComponentWrapper var2 = PSEUDO_COMPONENTS.get(var1);
            if (var2 != null) {
                return var2;
            }
            DataComponentType var3 = this.components.get(ResourceKey.create(Registries.DATA_COMPONENT_TYPE, var1)).map(Holder::value).orElseThrow(() -> ERROR_UNKNOWN_COMPONENT.createWithContext(var0, (Object)var1));
            return ComponentWrapper.create(var0, var1, var3);
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader var0, ComponentWrapper var1, Dynamic<?> var2) throws CommandSyntaxException {
            return var1.decode(var0, RegistryOps.injectRegistryContext(var2, this.registries));
        }

        @Override
        public Predicate<ItemStack> createComponentTest(ImmutableStringReader var0, ComponentWrapper var1) {
            return var1.presenceChecker;
        }

        @Override
        public PredicateWrapper lookupPredicateType(ImmutableStringReader var0, ResourceLocation var1) throws CommandSyntaxException {
            PredicateWrapper var2 = PSEUDO_PREDICATES.get(var1);
            if (var2 != null) {
                return var2;
            }
            return this.predicates.get(ResourceKey.create(Registries.DATA_COMPONENT_PREDICATE_TYPE, var1)).map(PredicateWrapper::new).orElseThrow(() -> ERROR_UNKNOWN_PREDICATE.createWithContext(var0, (Object)var1));
        }

        @Override
        public Predicate<ItemStack> createPredicateTest(ImmutableStringReader var0, PredicateWrapper var1, Dynamic<?> var2) throws CommandSyntaxException {
            return var1.decode(var0, RegistryOps.injectRegistryContext(var2, this.registries));
        }

        @Override
        public Stream<ResourceLocation> listElementTypes() {
            return this.items.listElementIds().map(ResourceKey::location);
        }

        @Override
        public Stream<ResourceLocation> listTagTypes() {
            return this.items.listTagIds().map(TagKey::location);
        }

        @Override
        public Stream<ResourceLocation> listComponentTypes() {
            return Stream.concat(PSEUDO_COMPONENTS.keySet().stream(), this.components.listElements().filter(var0 -> !((DataComponentType)var0.value()).isTransient()).map(var0 -> var0.key().location()));
        }

        @Override
        public Stream<ResourceLocation> listPredicateTypes() {
            return Stream.concat(PSEUDO_PREDICATES.keySet().stream(), this.predicates.listElementIds().map(ResourceKey::location));
        }

        @Override
        public Predicate<ItemStack> negate(Predicate<ItemStack> var0) {
            return var0.negate();
        }

        @Override
        public Predicate<ItemStack> anyOf(List<Predicate<ItemStack>> var0) {
            return Util.anyOf(var0);
        }

        @Override
        public /* synthetic */ Object anyOf(List list) {
            return this.anyOf(list);
        }

        @Override
        public /* synthetic */ Object createPredicateTest(ImmutableStringReader immutableStringReader, Object object, Dynamic dynamic) throws CommandSyntaxException {
            return this.createPredicateTest(immutableStringReader, (PredicateWrapper)object, dynamic);
        }

        @Override
        public /* synthetic */ Object lookupPredicateType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.lookupPredicateType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object lookupComponentType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.lookupComponentType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object forTagType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.forTagType(immutableStringReader, resourceLocation);
        }

        @Override
        public /* synthetic */ Object forElementType(ImmutableStringReader immutableStringReader, ResourceLocation resourceLocation) throws CommandSyntaxException {
            return this.forElementType(immutableStringReader, resourceLocation);
        }
    }

    public static interface Result
    extends Predicate<ItemStack> {
    }

    static final class ComponentWrapper
    extends Record {
        private final ResourceLocation id;
        final Predicate<ItemStack> presenceChecker;
        private final Decoder<? extends Predicate<ItemStack>> valueChecker;

        ComponentWrapper(ResourceLocation var0, Predicate<ItemStack> var1, Decoder<? extends Predicate<ItemStack>> var2) {
            this.id = var0;
            this.presenceChecker = var1;
            this.valueChecker = var2;
        }

        public static <T> ComponentWrapper create(ImmutableStringReader var0, ResourceLocation var12, DataComponentType<T> var2) throws CommandSyntaxException {
            Codec<T> var3 = var2.codec();
            if (var3 == null) {
                throw ERROR_UNKNOWN_COMPONENT.createWithContext(var0, (Object)var12);
            }
            return new ComponentWrapper(var12, var1 -> var1.has(var2), (Decoder<? extends Predicate<ItemStack>>)var3.map(var1 -> var2 -> {
                Object var3 = var2.get(var2);
                return Objects.equals(var1, var3);
            }));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader var0, Dynamic<?> var12) throws CommandSyntaxException {
            DataResult var2 = this.valueChecker.parse(var12);
            return (Predicate)var2.getOrThrow(var1 -> ERROR_MALFORMED_COMPONENT.createWithContext(var0, (Object)this.id.toString(), var1));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ComponentWrapper.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ComponentWrapper.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ComponentWrapper.class, "id;presenceChecker;valueChecker", "id", "presenceChecker", "valueChecker"}, this, var0);
        }

        public ResourceLocation id() {
            return this.id;
        }

        public Predicate<ItemStack> presenceChecker() {
            return this.presenceChecker;
        }

        public Decoder<? extends Predicate<ItemStack>> valueChecker() {
            return this.valueChecker;
        }
    }

    record PredicateWrapper(ResourceLocation id, Decoder<? extends Predicate<ItemStack>> type) {
        public PredicateWrapper(Holder.Reference<DataComponentPredicate.Type<?>> var02) {
            this(var02.key().location(), (Decoder<? extends Predicate<ItemStack>>)var02.value().codec().map(var0 -> var0::matches));
        }

        public Predicate<ItemStack> decode(ImmutableStringReader var0, Dynamic<?> var12) throws CommandSyntaxException {
            DataResult var2 = this.type.parse(var12);
            return (Predicate)var2.getOrThrow(var1 -> ERROR_MALFORMED_PREDICATE.createWithContext(var0, (Object)this.id.toString(), var1));
        }
    }
}

