/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import java.util.List;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.CommandQueueEntry;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;
import net.minecraft.commands.execution.tasks.ContinuationTask;
import net.minecraft.commands.functions.InstantiatedFunction;

public class CallFunction<T extends ExecutionCommandSource<T>>
implements UnboundEntryAction<T> {
    private final InstantiatedFunction<T> function;
    private final CommandResultCallback resultCallback;
    private final boolean returnParentFrame;

    public CallFunction(InstantiatedFunction<T> var0, CommandResultCallback var1, boolean var2) {
        this.function = var0;
        this.resultCallback = var1;
        this.returnParentFrame = var2;
    }

    @Override
    public void execute(T var0, ExecutionContext<T> var12, Frame var22) {
        var12.incrementCost();
        List<UnboundEntryAction<T>> var3 = this.function.entries();
        TraceCallbacks var4 = var12.tracer();
        if (var4 != null) {
            var4.onCall(var22.depth(), this.function.id(), this.function.entries().size());
        }
        int var5 = var22.depth() + 1;
        Frame.FrameControl var6 = this.returnParentFrame ? var22.frameControl() : var12.frameControlForDepth(var5);
        Frame var7 = new Frame(var5, this.resultCallback, var6);
        ContinuationTask.schedule(var12, var7, var3, (var1, var2) -> new CommandQueueEntry<ExecutionCommandSource>(var1, var2.bind(var0)));
    }

    @Override
    public /* synthetic */ void execute(Object object, ExecutionContext executionContext, Frame frame) {
        this.execute((ExecutionCommandSource)object, executionContext, frame);
    }
}

