/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R6.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class ShulkerBoxDispenseBehavior
extends OptionalDispenseItemBehavior {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected net.minecraft.world.item.ItemStack execute(BlockSource sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        this.setSuccess(false);
        Item item = itemstack.getItem();
        if (item instanceof BlockItem) {
            net.minecraft.world.item.ItemStack eventStack;
            DispenseItemBehavior idispensebehavior;
            Direction enumdirection = sourceblock.state().getValue(DispenserBlock.FACING);
            BlockPos blockposition = sourceblock.pos().relative(enumdirection);
            Direction enumdirection1 = sourceblock.level().isEmptyBlock(blockposition.below()) ? enumdirection : Direction.UP;
            CraftBlock bukkitBlock = CraftBlock.at(sourceblock.level(), sourceblock.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
            BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
            if (!DispenserBlock.eventFired) {
                sourceblock.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return itemstack;
            }
            if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != DispenseItemBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
            try {
                this.setSuccess(((BlockItem)item).place(new DirectionalPlaceContext((Level)sourceblock.level(), blockposition, enumdirection, itemstack, enumdirection1)).consumesAction());
            }
            catch (Exception exception) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)blockposition, (Object)exception);
            }
        }
        return itemstack;
    }
}

