/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTicks;

public class StructureUtils {
    public static final int DEFAULT_Y_SEARCH_RADIUS = 10;
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "Minecraft.Server/src/test/convertables/data";
    public static Path testStructuresDir = Paths.get("Minecraft.Server/src/test/convertables/data", new String[0]);

    public static Rotation getRotationForRotationSteps(int var0) {
        switch (var0) {
            case 0: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + var0);
    }

    public static int getRotationStepsForRotation(Rotation var0) {
        switch (var0) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + String.valueOf(var0));
    }

    public static TestInstanceBlockEntity createNewEmptyTest(ResourceLocation var0, BlockPos var1, Vec3i var2, Rotation var3, ServerLevel var4) {
        BoundingBox var5 = StructureUtils.getStructureBoundingBox(TestInstanceBlockEntity.getStructurePos(var1), var2, var3);
        StructureUtils.clearSpaceForStructure(var5, var4);
        var4.setBlockAndUpdate(var1, Blocks.TEST_INSTANCE_BLOCK.defaultBlockState());
        TestInstanceBlockEntity var6 = (TestInstanceBlockEntity)var4.getBlockEntity(var1);
        ResourceKey<GameTestInstance> var7 = ResourceKey.create(Registries.TEST_INSTANCE, var0);
        var6.set(new TestInstanceBlockEntity.Data(Optional.of(var7), var2, var3, false, TestInstanceBlockEntity.Status.CLEARED, Optional.empty()));
        return var6;
    }

    public static void clearSpaceForStructure(BoundingBox var02, ServerLevel var1) {
        int var22 = var02.minY() - 1;
        BlockPos.betweenClosedStream(var02).forEach(var2 -> StructureUtils.clearBlock(var22, var2, var1));
        ((LevelTicks)var1.getBlockTicks()).clearArea(var02);
        var1.clearBlockEvents(var02);
        AABB var3 = AABB.of(var02);
        List<Entity> var4 = var1.getEntitiesOfClass(Entity.class, var3, var0 -> !(var0 instanceof Player));
        var4.forEach(Entity::discard);
    }

    public static BlockPos getTransformedFarCorner(BlockPos var0, Vec3i var1, Rotation var2) {
        BlockPos var3 = var0.offset(var1).offset(-1, -1, -1);
        return StructureTemplate.transform(var3, Mirror.NONE, var2, var0);
    }

    public static BoundingBox getStructureBoundingBox(BlockPos var0, Vec3i var1, Rotation var2) {
        BlockPos var3 = StructureUtils.getTransformedFarCorner(var0, var1, var2);
        BoundingBox var4 = BoundingBox.fromCorners(var0, var3);
        int var5 = Math.min(var4.minX(), var4.maxX());
        int var6 = Math.min(var4.minZ(), var4.maxZ());
        return var4.move(var0.getX() - var5, 0, var0.getZ() - var6);
    }

    public static Optional<BlockPos> findTestContainingPos(BlockPos var0, int var1, ServerLevel var22) {
        return StructureUtils.findTestBlocks(var0, var1, var22).filter(var2 -> StructureUtils.doesStructureContain(var2, var0, var22)).findFirst();
    }

    public static Optional<BlockPos> findNearestTest(BlockPos var0, int var12, ServerLevel var2) {
        Comparator<BlockPos> var3 = Comparator.comparingInt(var1 -> var1.distManhattan(var0));
        return StructureUtils.findTestBlocks(var0, var12, var2).min(var3);
    }

    public static Stream<BlockPos> findTestBlocks(BlockPos var02, int var1, ServerLevel var2) {
        return var2.getPoiManager().findAll(var0 -> var0.is(PoiTypes.TEST_INSTANCE), var0 -> true, var02, var1, PoiManager.Occupancy.ANY).map(BlockPos::immutable);
    }

    public static Stream<BlockPos> lookedAtTestPos(BlockPos var0, Entity var12, ServerLevel var22) {
        int var3 = 250;
        Vec3 var4 = var12.getEyePosition();
        Vec3 var5 = var4.add(var12.getLookAngle().scale(250.0));
        return StructureUtils.findTestBlocks(var0, 250, var22).map(var1 -> var22.getBlockEntity((BlockPos)var1, BlockEntityType.TEST_INSTANCE_BLOCK)).flatMap(Optional::stream).filter(var2 -> var2.getStructureBounds().clip(var4, var5).isPresent()).map(BlockEntity::getBlockPos).sorted(Comparator.comparing(var0::distSqr)).limit(1L);
    }

    private static void clearBlock(int var0, BlockPos var1, ServerLevel var2) {
        BlockState var3 = var1.getY() < var0 ? Blocks.STONE.defaultBlockState() : Blocks.AIR.defaultBlockState();
        BlockInput var4 = new BlockInput(var3, Collections.emptySet(), null);
        var4.place(var2, var1, 818);
        var2.updateNeighborsAt(var1, var3.getBlock());
    }

    private static boolean doesStructureContain(BlockPos var0, BlockPos var1, ServerLevel var2) {
        BlockEntity blockEntity = var2.getBlockEntity(var0);
        if (blockEntity instanceof TestInstanceBlockEntity) {
            TestInstanceBlockEntity var3 = (TestInstanceBlockEntity)blockEntity;
            return var3.getStructureBoundingBox().isInside(var1);
        }
        return false;
    }
}

