/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtFormatException;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public final class ListTag
extends AbstractList<Tag>
implements CollectionTag {
    private static final String WRAPPER_MARKER = "";
    private static final int SELF_SIZE_IN_BYTES = 36;
    public static final TagType<ListTag> TYPE = new TagType.VariableSize<ListTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListTag load(DataInput var0, NbtAccounter var1) throws IOException {
            var1.pushDepth();
            try {
                ListTag listTag = 1.loadList(var0, var1);
                return listTag;
            }
            finally {
                var1.popDepth();
            }
        }

        private static ListTag loadList(DataInput var0, NbtAccounter var1) throws IOException {
            var1.accountBytes(36L);
            byte var2 = var0.readByte();
            int var3 = 1.readListCount(var0);
            if (var2 == 0 && var3 > 0) {
                throw new NbtFormatException("Missing type on ListTag");
            }
            var1.accountBytes(4L, var3);
            TagType<?> var4 = TagTypes.getType(var2);
            ListTag var5 = new ListTag(new ArrayList<Tag>(var3));
            for (int var6 = 0; var6 < var3; ++var6) {
                var5.addAndUnwrap((Tag)var4.load(var0, var1));
            }
            return var5;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            var2.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseList(var0, var1, var2);
                return valueResult;
            }
            finally {
                var2.popDepth();
            }
        }

        /*
         * Exception decompiling
         */
        private static StreamTagVisitor.ValueResult parseList(DataInput var0, StreamTagVisitor var1, NbtAccounter var2) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 8[CASE]], but top level block is 9[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static int readListCount(DataInput var0) throws IOException {
            int var1 = var0.readInt();
            if (var1 < 0) {
                throw new NbtFormatException("ListTag length cannot be negative: " + var1);
            }
            return var1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput var0, NbtAccounter var1) throws IOException {
            var1.pushDepth();
            try {
                TagType<?> var2 = TagTypes.getType(var0.readByte());
                int var3 = var0.readInt();
                var2.skip(var0, var3, var1);
            }
            finally {
                var1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "LIST";
        }

        @Override
        public String getPrettyName() {
            return "TAG_List";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final List<Tag> list;

    public ListTag() {
        this(new ArrayList<Tag>());
    }

    public ListTag(List<Tag> var0) {
        this.list = var0;
    }

    private static Tag tryUnwrap(CompoundTag var0) {
        Tag var1;
        if (var0.size() == 1 && (var1 = var0.get(WRAPPER_MARKER)) != null) {
            return var1;
        }
        return var0;
    }

    private static boolean isWrapper(CompoundTag var0) {
        return var0.size() == 1 && var0.contains(WRAPPER_MARKER);
    }

    private static Tag wrapIfNeeded(byte var0, Tag var1) {
        CompoundTag var2;
        if (var0 != 10) {
            return var1;
        }
        if (var1 instanceof CompoundTag && !ListTag.isWrapper(var2 = (CompoundTag)var1)) {
            return var2;
        }
        return ListTag.wrapElement(var1);
    }

    private static CompoundTag wrapElement(Tag var0) {
        return new CompoundTag(Map.of(WRAPPER_MARKER, var0));
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        byte var1 = this.identifyRawElementType();
        var0.writeByte(var1);
        var0.writeInt(this.list.size());
        for (Tag var3 : this.list) {
            ListTag.wrapIfNeeded(var1, var3).write(var0);
        }
    }

    @VisibleForTesting
    public byte identifyRawElementType() {
        byte var0 = 0;
        for (Tag var2 : this.list) {
            byte var3 = var2.getId();
            if (var0 == 0) {
                var0 = var3;
                continue;
            }
            if (var0 == var3) continue;
            return 10;
        }
        return var0;
    }

    public void addAndUnwrap(Tag var0) {
        if (var0 instanceof CompoundTag) {
            CompoundTag var1 = (CompoundTag)var0;
            this.add(ListTag.tryUnwrap(var1));
        } else {
            this.add(var0);
        }
    }

    @Override
    public int sizeInBytes() {
        int var0 = 36;
        var0 += 4 * this.list.size();
        for (Tag var2 : this.list) {
            var0 += var2.sizeInBytes();
        }
        return var0;
    }

    @Override
    public byte getId() {
        return 9;
    }

    public TagType<ListTag> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        StringTagVisitor var0 = new StringTagVisitor();
        var0.visitList(this);
        return var0.build();
    }

    @Override
    public Tag remove(int var0) {
        return this.list.remove(var0);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Optional<CompoundTag> getCompound(int var0) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof CompoundTag) {
            CompoundTag var1 = (CompoundTag)tag;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public CompoundTag getCompoundOrEmpty(int var0) {
        return this.getCompound(var0).orElseGet(CompoundTag::new);
    }

    public Optional<ListTag> getList(int var0) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof ListTag) {
            ListTag var1 = (ListTag)tag;
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    public ListTag getListOrEmpty(int var0) {
        return this.getList(var0).orElseGet(ListTag::new);
    }

    public Optional<Short> getShort(int var0) {
        return this.getOptional(var0).flatMap(Tag::asShort);
    }

    public short getShortOr(int var0, short var1) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.shortValue();
        }
        return var1;
    }

    public Optional<Integer> getInt(int var0) {
        return this.getOptional(var0).flatMap(Tag::asInt);
    }

    public int getIntOr(int var0, int var1) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.intValue();
        }
        return var1;
    }

    public Optional<int[]> getIntArray(int var0) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof IntArrayTag) {
            IntArrayTag var1 = (IntArrayTag)tag;
            return Optional.of(var1.getAsIntArray());
        }
        return Optional.empty();
    }

    public Optional<long[]> getLongArray(int var0) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof LongArrayTag) {
            LongArrayTag var1 = (LongArrayTag)tag;
            return Optional.of(var1.getAsLongArray());
        }
        return Optional.empty();
    }

    public Optional<Double> getDouble(int var0) {
        return this.getOptional(var0).flatMap(Tag::asDouble);
    }

    public double getDoubleOr(int var0, double var1) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof NumericTag) {
            NumericTag var3 = (NumericTag)tag;
            return var3.doubleValue();
        }
        return var1;
    }

    public Optional<Float> getFloat(int var0) {
        return this.getOptional(var0).flatMap(Tag::asFloat);
    }

    public float getFloatOr(int var0, float var1) {
        Tag tag = this.getNullable(var0);
        if (tag instanceof NumericTag) {
            NumericTag var2 = (NumericTag)tag;
            return var2.floatValue();
        }
        return var1;
    }

    public Optional<String> getString(int var0) {
        return this.getOptional(var0).flatMap(Tag::asString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getStringOr(int var0, String var1) {
        Tag var2 = this.getNullable(var0);
        if (!(var2 instanceof StringTag)) return var1;
        StringTag stringTag = (StringTag)var2;
        try {
            String string = stringTag.value();
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Nullable
    private Tag getNullable(int var0) {
        return var0 >= 0 && var0 < this.list.size() ? this.list.get(var0) : null;
    }

    private Optional<Tag> getOptional(int var0) {
        return Optional.ofNullable(this.getNullable(var0));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Tag get(int var0) {
        return this.list.get(var0);
    }

    @Override
    public Tag set(int var0, Tag var1) {
        return this.list.set(var0, var1);
    }

    @Override
    public void add(int var0, Tag var1) {
        this.list.add(var0, var1);
    }

    @Override
    public boolean setTag(int var0, Tag var1) {
        this.list.set(var0, var1);
        return true;
    }

    @Override
    public boolean addTag(int var0, Tag var1) {
        this.list.add(var0, var1);
        return true;
    }

    @Override
    public ListTag copy() {
        ArrayList<Tag> var0 = new ArrayList<Tag>(this.list.size());
        for (Tag var2 : this.list) {
            var0.add(var2.copy());
        }
        return new ListTag(var0);
    }

    @Override
    public Optional<ListTag> asList() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof ListTag && Objects.equals(this.list, ((ListTag)var0).list);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public Stream<Tag> stream() {
        return super.stream();
    }

    public Stream<CompoundTag> compoundStream() {
        return this.stream().mapMulti((var0, var1) -> {
            if (var0 instanceof CompoundTag) {
                CompoundTag var2 = (CompoundTag)var0;
                var1.accept(var2);
            }
        });
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitList(this);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor var0) {
        byte var1 = this.identifyRawElementType();
        switch (var0.visitList(TagTypes.getType(var1), this.list.size())) {
            case HALT: {
                return StreamTagVisitor.ValueResult.HALT;
            }
            case BREAK: {
                return var0.visitContainerEnd();
            }
        }
        block13: for (int var2 = 0; var2 < this.list.size(); ++var2) {
            Tag var3 = ListTag.wrapIfNeeded(var1, this.list.get(var2));
            switch (var0.visitElement(var3.getType(), var2)) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case SKIP: {
                    continue block13;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                default: {
                    switch (var3.accept(var0)) {
                        case HALT: {
                            return StreamTagVisitor.ValueResult.HALT;
                        }
                        case BREAK: {
                            return var0.visitContainerEnd();
                        }
                    }
                }
            }
        }
        return var0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        return this.remove(n);
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        this.add(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        return this.set(n, (Tag)object);
    }

    @Override
    public /* synthetic */ Object get(int n) {
        return this.get(n);
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

