/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.DataFixer;
import com.mojang.jtracy.DiscontinuousFrame;
import com.mojang.jtracy.TracyClient;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.Proxy;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.Tag;
import net.minecraft.network.PacketProcessor;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerLinks;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.SuppressedExceptionCollector;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkLoadCounter;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DemoMode;
import net.minecraft.server.level.PlayerSpawnFinder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.level.progress.ChunkLoadStatusView;
import net.minecraft.server.level.progress.LevelLoadListener;
import net.minecraft.server.network.ServerConnectionListener;
import net.minecraft.server.network.TextFilter;
import net.minecraft.server.notifications.NotificationManager;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.debug.ServerDebugSubscribers;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.CatSpawner;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.TicketStorage;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.PatrolSpawner;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.CommandStorage;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_21_R6.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_21_R6.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_21_R6.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R6.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.plugin.PluginLoadOrder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends ReentrantBlockableEventLoop<TickTask>
implements ServerInfo,
CommandSource,
ChunkIOErrorReporter {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String VANILLA_BRAND = "vanilla";
    private static final float AVERAGE_TICK_TIME_SMOOTHING = 0.8f;
    private static final int TICK_STATS_SPAN = 100;
    private static final long OVERLOADED_THRESHOLD_NANOS = 30L * TimeUtil.NANOSECONDS_PER_SECOND / 20L;
    private static final int OVERLOADED_TICKS_THRESHOLD = 20;
    private static final long OVERLOADED_WARNING_INTERVAL_NANOS = 10L * TimeUtil.NANOSECONDS_PER_SECOND;
    private static final int OVERLOADED_TICKS_WARNING_INTERVAL = 100;
    private static final long STATUS_EXPIRE_TIME_NANOS = 5L * TimeUtil.NANOSECONDS_PER_SECOND;
    private static final long PREPARE_LEVELS_DEFAULT_DELAY_NANOS = 10L * TimeUtil.NANOSECONDS_PER_MILLISECOND;
    private static final int MAX_STATUS_PLAYER_SAMPLE = 12;
    public static final int SPAWN_POSITION_SEARCH_RADIUS = 5;
    private static final int AUTOSAVE_INTERVAL = 6000;
    private static final int MIMINUM_AUTOSAVE_TICKS = 100;
    private static final int MAX_TICK_LATENCY = 3;
    public static final int ABSOLUTE_MAX_WORLD_SIZE = 29999984;
    public static final LevelSettings DEMO_SETTINGS = new LevelSettings("Demo World", GameType.SURVIVAL, false, Difficulty.NORMAL, false, new GameRules(FeatureFlags.DEFAULT_FLAGS), WorldDataConfiguration.DEFAULT);
    public static final NameAndId ANONYMOUS_PLAYER_PROFILE = new NameAndId(Util.NIL_UUID, "Anonymous Player");
    public LevelStorageSource.LevelStorageAccess storageSource;
    public final PlayerDataStorage playerDataStorage;
    private final List<Runnable> tickables = Lists.newArrayList();
    private MetricsRecorder metricsRecorder;
    private Consumer<ProfileResults> onMetricsRecordingStopped;
    private Consumer<Path> onMetricsRecordingFinished;
    private boolean willStartRecordingMetrics;
    @Nullable
    private TimeProfiler debugCommandProfiler;
    private boolean debugCommandProfilerDelayStart;
    private ServerConnectionListener connection;
    public final LevelLoadListener levelLoadListener;
    @Nullable
    private ServerStatus status;
    @Nullable
    private ServerStatus.Favicon statusIcon;
    private final RandomSource random;
    public final DataFixer fixerUpper;
    private String localIp;
    private int port = -1;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private Map<ResourceKey<Level>, ServerLevel> levels;
    private PlayerList playerList;
    private volatile boolean running = true;
    private boolean stopped;
    private int tickCount;
    private int ticksUntilAutosave = 6000;
    protected final Proxy proxy;
    private boolean onlineMode;
    private boolean preventProxyConnections;
    @Nullable
    private String motd;
    private int playerIdleTimeout;
    private final long[] tickTimesNanos;
    private long aggregatedTickTimesNanos = 0L;
    @Nullable
    private KeyPair keyPair;
    @Nullable
    private GameProfile singleplayerProfile;
    private boolean isDemo;
    private volatile boolean isReady;
    private long lastOverloadWarningNanos;
    protected final Services services;
    private final NotificationManager notificationManager;
    private long lastServerStatus;
    public final Thread serverThread;
    private long lastTickNanos;
    private long taskExecutionStartNanos;
    private long idleTimeNanos;
    private long nextTickTimeNanos;
    private boolean waitingForNextTick = false;
    private long delayedTasksMaxNextTickTimeNanos;
    private boolean mayHaveDelayedTasks;
    private final PackRepository packRepository;
    private final ServerScoreboard scoreboard;
    @Nullable
    private CommandStorage commandStorage;
    private final CustomBossEvents customBossEvents;
    private final ServerFunctionManager functionManager;
    private boolean enforceWhitelist;
    private boolean usingWhitelist;
    private float smoothedTickTimeMillis;
    public final Executor executor;
    @Nullable
    private String serverId;
    public ReloadableResources resources;
    private final StructureTemplateManager structureTemplateManager;
    private final ServerTickRateManager tickRateManager;
    private final ServerDebugSubscribers debugSubscribers;
    protected WorldData worldData;
    private LevelData.RespawnData effectiveRespawnData;
    private final PotionBrewing potionBrewing;
    private FuelValues fuelValues;
    private int emptyTicks;
    private volatile boolean isSaving;
    private static final AtomicReference<RuntimeException> fatalException = new AtomicReference();
    private final SuppressedExceptionCollector suppressedExceptions;
    private final DiscontinuousFrame tickFrame;
    private final PacketProcessor packetProcessor;
    public final WorldLoader.DataLoadContext worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public Terminal terminal;
    public static int currentTick = (int)(System.currentTimeMillis() / 50L);
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public Commands vanillaCommandDispatcher;
    private boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 100;
    public final double[] recentTps = new double[3];
    private boolean hasStopped = false;
    private final Object stopLock = new Object();
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").build());

    public static <S extends MinecraftServer> S spin(Function<Thread, S> function) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        Thread thread = new Thread(() -> ((MinecraftServer)atomicreference.get()).runServer(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> LOGGER.error("Uncaught exception in server thread", throwable));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)function.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, WorldLoader.DataLoadContext worldLoader, Thread thread, LevelStorageSource.LevelStorageAccess convertable_conversionsession, PackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, LevelLoadListener levelloadlistener) {
        super("Server");
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
        this.onMetricsRecordingStopped = methodprofilerresults -> this.stopRecordingMetrics();
        this.onMetricsRecordingFinished = path -> {};
        this.random = RandomSource.create();
        this.levels = Maps.newLinkedHashMap();
        this.tickTimesNanos = new long[100];
        this.lastTickNanos = Util.getNanos();
        this.taskExecutionStartNanos = Util.getNanos();
        this.nextTickTimeNanos = Util.getNanos();
        this.scoreboard = new ServerScoreboard(this);
        this.customBossEvents = new CustomBossEvents();
        this.debugSubscribers = new ServerDebugSubscribers(this);
        this.effectiveRespawnData = LevelData.RespawnData.DEFAULT;
        this.suppressedExceptions = new SuppressedExceptionCollector();
        this.registries = worldstem.registries();
        this.worldData = worldstem.worldData();
        this.proxy = proxy;
        this.packRepository = resourcepackrepository;
        this.resources = new ReloadableResources(worldstem.resourceManager(), worldstem.dataPackResources());
        this.services = services;
        this.tickRateManager = new ServerTickRateManager(this);
        this.levelLoadListener = levelloadlistener;
        this.storageSource = convertable_conversionsession;
        this.playerDataStorage = convertable_conversionsession.createPlayerStorage();
        this.fixerUpper = datafixer;
        this.functionManager = new ServerFunctionManager(this, this.resources.managers.getFunctionLibrary());
        HolderLookup.RegistryLookup holdergetter = this.registries.compositeAccess().lookupOrThrow(Registries.BLOCK).filterFeatures(this.worldData.enabledFeatures());
        this.structureTemplateManager = new StructureTemplateManager(worldstem.resourceManager(), convertable_conversionsession, datafixer, holdergetter);
        this.serverThread = thread;
        this.executor = Util.backgroundExecutor();
        this.potionBrewing = PotionBrewing.bootstrap(this.worldData.enabledFeatures());
        this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
        this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
        this.tickFrame = TracyClient.createDiscontinuousFrame((String)"Server Tick");
        this.notificationManager = new NotificationManager();
        this.packetProcessor = new PacketProcessor(thread);
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.dataPackResources().commands;
        if (System.console() == null && System.getProperty("org.jline.terminal.provider") == null) {
            System.setProperty("org.jline.terminal.provider", "dumb");
            org.bukkit.craftbukkit.Main.useJline = false;
        }
        try {
            this.terminal = TerminalBuilder.builder().dumb(false).build();
        }
        catch (Throwable e) {
            try {
                System.setProperty("org.jline.terminal.provider", "dumb");
                org.bukkit.craftbukkit.Main.useJline = false;
                this.terminal = TerminalBuilder.builder().build();
            }
            catch (IOException ex) {
                LOGGER.warn((String)null, (Throwable)ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
    }

    private void readScoreboard(DimensionDataStorage worldpersistentdata) {
        worldpersistentdata.computeIfAbsent(ServerScoreboard.TYPE);
    }

    protected abstract boolean initServer() throws IOException;

    public ChunkLoadStatusView createChunkLoadStatusView(final int i) {
        return new ChunkLoadStatusView(){
            @Nullable
            private ChunkMap chunkMap;
            private int centerChunkX;
            private int centerChunkZ;

            @Override
            public void moveTo(ResourceKey<Level> resourcekey, ChunkPos chunkcoordintpair) {
                ServerLevel worldserver = MinecraftServer.this.getLevel(resourcekey);
                this.chunkMap = worldserver != null ? worldserver.getChunkSource().chunkMap : null;
                this.centerChunkX = chunkcoordintpair.x;
                this.centerChunkZ = chunkcoordintpair.z;
            }

            @Override
            @Nullable
            public ChunkStatus get(int j, int k) {
                return this.chunkMap == null ? null : this.chunkMap.getLatestStatus(ChunkPos.asLong(j + this.centerChunkX - i, k + this.centerChunkZ - i));
            }

            @Override
            public int radius() {
                return i;
            }
        };
    }

    protected void loadLevel(String s) {
        boolean flag = !JvmProfiler.INSTANCE.isRunning() && SharedConstants.DEBUG_JFR_PROFILING_ENABLE_LEVEL_LOADING && JvmProfiler.INSTANCE.start(Environment.from(this));
        ProfiledDuration profiledduration = JvmProfiler.INSTANCE.onWorldLoadedStarted();
        this.loadWorld0(s);
        if (profiledduration != null) {
            profiledduration.finish(true);
        }
        if (flag) {
            try {
                JvmProfiler.INSTANCE.stop();
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void forceDifficulty() {
    }

    private void loadWorld0(String s) {
        LevelStorageSource.LevelStorageAccess worldSession = this.storageSource;
        RegistryAccess.Frozen iregistrycustom_dimension = this.registries.compositeAccess();
        HolderLookup.RegistryLookup dimensions = iregistrycustom_dimension.lookupOrThrow(Registries.LEVEL_STEM);
        Iterator<ServerLevel> iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            ServerLevel world;
            PrimaryLevelData worlddata;
            Dynamic<?> dynamic;
            String name;
            LevelStem worldDimension = (LevelStem)iterator.next();
            ResourceKey<LevelStem> dimensionKey = dimensions.getResourceKey(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == LevelStem.NETHER) {
                if (!this.server.getAllowNether()) continue;
                dimension = -1;
            } else if (dimensionKey == LevelStem.END) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != LevelStem.OVERWORLD) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.location().getNamespace() + "_" + dimensionKey.location().getPath() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase(Locale.ROOT);
            String string = name = dimensionKey == LevelStem.OVERWORLD ? s : s + "_" + worldType;
            if (dimension != 0) {
                File newWorld = LevelStorageSource.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = LevelStorageSource.getStorageFolder(new File(s).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    LOGGER.info("---- Migration of old " + worldType + " folder required ----");
                    LOGGER.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    LOGGER.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    LOGGER.info("Attempting to move " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "...");
                    if (newWorld.exists()) {
                        LOGGER.warn("A file or folder already exists at " + String.valueOf(newWorld) + "!");
                        LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            LOGGER.info("Success! To restore " + worldType + " in the future, simply move " + String.valueOf(newWorld) + " to " + String.valueOf(oldWorld));
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                LOGGER.warn("Unable to migrate world data.");
                            }
                            LOGGER.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            LOGGER.warn("Could not move folder " + String.valueOf(oldWorld) + " to " + String.valueOf(newWorld) + "!");
                            LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        LOGGER.warn("Could not create path for " + String.valueOf(newWorld) + "!");
                        LOGGER.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = LevelStorageSource.createDefault(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.hasWorldData()) {
                LevelSummary worldinfo;
                try {
                    dynamic = worldSession.getDataTag();
                    worldinfo = worldSession.getSummary(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    LevelStorageSource.LevelDirectory convertable_b = worldSession.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)convertable_b.dataFile(), (Object)ioexception);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.getDataTagFallback();
                        worldinfo = worldSession.getSummary(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        LOGGER.error("Failed to load world data from {}", (Object)convertable_b.oldDataFile(), (Object)ioexception1);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.dataFile(), (Object)convertable_b.oldDataFile());
                        return;
                    }
                    worldSession.restoreLevelDataFromOld();
                }
                if (worldinfo.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.DataLoadContext worldloader_a = this.worldLoader;
            HolderLookup.RegistryLookup iregistry = worldloader_a.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = LevelStorageSource.getLevelDataAndDimensions(dynamic, worldloader_a.dataConfiguration(), (Registry<LevelStem>)iregistry, worldloader_a.datapackWorldgen());
                worlddata = (PrimaryLevelData)leveldataanddimensions.worldData();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                LevelSettings worldsettings;
                if (this.isDemo()) {
                    worldsettings = DEMO_SETTINGS;
                    worldoptions = WorldOptions.DEMO_OPTIONS;
                    worlddimensions = WorldPresets.createNormalWorldDimensions(worldloader_a.datapackWorldgen());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).getProperties();
                    worldsettings = new LevelSettings(dedicatedserverproperties.levelName, dedicatedserverproperties.gameMode.get(), dedicatedserverproperties.hardcore, dedicatedserverproperties.difficulty.get(), false, new GameRules(worldloader_a.dataConfiguration().enabledFeatures()), worldloader_a.dataConfiguration());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.worldOptions.withBonusChest(true) : dedicatedserverproperties.worldOptions;
                    worlddimensions = dedicatedserverproperties.createDimensions(worldloader_a.datapackWorldgen());
                }
                WorldDimensions.Complete worlddimensions_b = worlddimensions.bake((Registry<LevelStem>)iregistry);
                Lifecycle lifecycle = worlddimensions_b.lifecycle().add(worldloader_a.datapackWorldgen().allRegistriesLifecycle());
                worlddata = new PrimaryLevelData(worldsettings, worldoptions, worlddimensions_b.specialWorldProperty(), lifecycle);
            }
            worlddata.checkName(name);
            if (this.options.has("forceUpgrade")) {
                Main.forceUpgrade(worldSession, worlddata, DataFixers.getDataFixer(), this.options.has("eraseCache"), () -> true, iregistrycustom_dimension, this.options.has("recreateRegionFiles"));
            }
            PrimaryLevelData iworlddataserver = worlddata;
            boolean flag = worlddata.isDebugWorld();
            WorldOptions worldoptions = worlddata.worldGenOptions();
            long i = worldoptions.seed();
            long j = BiomeManager.obfuscateSeed(i);
            ImmutableList list = ImmutableList.of((Object)new PhantomSpawner(), (Object)new PatrolSpawner(), (Object)new CatSpawner(), (Object)new VillageSiege(), (Object)new WanderingTraderSpawner(iworlddataserver));
            LevelStem worlddimension = dimensions.getValue(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.type().value());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((WorldInfo)worldInfo);
            }
            ResourceKey<Level> worldKey = ResourceKey.create(Registries.DIMENSION, dimensionKey.location());
            if (dimensionKey == LevelStem.OVERWORLD) {
                this.worldData = worlddata;
                this.worldData.setGameType(((DedicatedServer)this).getProperties().gameMode.get());
                world = new ServerLevel(this, this.executor, worldSession, iworlddataserver, worldKey, worlddimension, flag, j, (List<CustomSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                DimensionDataStorage worldpersistentdata = world.getDataStorage();
                this.readScoreboard(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.getScoreboard());
                this.commandStorage = new CommandStorage(worldpersistentdata);
            } else {
                world = new ServerLevel(this, this.executor, worldSession, iworlddataserver, worldKey, worlddimension, flag, j, (List<CustomSpawner>)ImmutableList.of(), true, this.overworld().getRandomSequences(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.setModdedInfo(this.getServerModName(), this.getModdedStatus().shouldReportAsModified());
            this.initWorld(world, worlddata, this.worldData, worldoptions);
            this.addLevel(world);
            this.getPlayerList().addWorldborderListener(world);
            if (worlddata.getCustomBossEvents() == null) continue;
            this.getCustomBossEvents().load(worlddata.getCustomBossEvents(), this.registryAccess());
        }
        this.forceDifficulty();
        for (ServerLevel worldserver : this.getAllLevels()) {
            this.prepareLevels(worldserver);
            worldserver.entityManager.tick();
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.connection.acceptConnections();
    }

    public void initWorld(ServerLevel worldserver, ServerLevelData iworlddataserver, WorldData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.isDebugWorld();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        this.initWorldBorder(worldserver, iworlddataserver);
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.isInitialized()) {
            try {
                MinecraftServer.setInitialSpawn(worldserver, iworlddataserver, worldoptions.generateBonusChest(), flag, this.levelLoadListener);
                iworlddataserver.setInitialized(true);
                if (flag) {
                    this.setupDebugLevel(this.worldData);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception initializing level");
                try {
                    worldserver.fillReportDetails(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.setInitialized(true);
        }
        GlobalPos globalpos = new GlobalPos(worldserver.dimension(), worldserver.getRespawnData().pos());
        this.levelLoadListener.updateFocus(globalpos.dimension(), new ChunkPos(globalpos.pos()));
    }

    private void initWorldBorder(ServerLevel worldserver1, ServerLevelData iworlddataserver) {
        boolean flag1 = false;
        Optional<WorldBorder.Settings> optional = iworlddataserver.getLegacyWorldBorderSettings();
        if (optional.isPresent()) {
            WorldBorder.Settings worldborder_c = optional.get();
            DimensionDataStorage worldpersistentdata1 = worldserver1.getDataStorage();
            if (worldpersistentdata1.get(WorldBorder.TYPE) == null) {
                double d0 = worldserver1.dimensionType().coordinateScale();
                WorldBorder.Settings worldborder_c1 = new WorldBorder.Settings(worldborder_c.centerX() / d0, worldborder_c.centerZ() / d0, worldborder_c.damagePerBlock(), worldborder_c.safeZone(), worldborder_c.warningBlocks(), worldborder_c.warningTime(), worldborder_c.size(), worldborder_c.lerpTime(), worldborder_c.lerpTarget());
                worldpersistentdata1.set(WorldBorder.TYPE, worldborder_c1.toWorldBorder());
            }
            flag1 = true;
        }
        worldserver1.getWorldBorder().setAbsoluteMaxSize(this.getAbsoluteMaxWorldSize());
        this.getPlayerList().addWorldborderListener(worldserver1);
        if (flag1) {
            iworlddataserver.setLegacyWorldBorderSettings(Optional.empty());
        }
    }

    private static void setInitialSpawn(ServerLevel worldserver, ServerLevelData iworlddataserver, boolean flag, boolean flag1, LevelLoadListener levelloadlistener) {
        if (SharedConstants.DEBUG_ONLY_GENERATE_HALF_THE_WORLD && SharedConstants.DEBUG_WORLD_RECREATE) {
            iworlddataserver.setSpawn(LevelData.RespawnData.of(worldserver.dimension(), new BlockPos(0, 64, -100), 0.0f, 0.0f));
        } else if (flag1) {
            iworlddataserver.setSpawn(LevelData.RespawnData.of(worldserver.dimension(), BlockPos.ZERO.above(80), 0.0f, 0.0f));
        } else {
            ServerChunkCache chunkproviderserver = worldserver.getChunkSource();
            ChunkPos chunkcoordintpair = new ChunkPos(chunkproviderserver.randomState().sampler().findSpawnPosition());
            if (worldserver.generator != null) {
                Random rand = new Random(worldserver.getSeed());
                Location spawn = worldserver.generator.getFixedSpawnLocation((World)worldserver.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != worldserver.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + iworlddataserver.getLevelName() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    iworlddataserver.setSpawn(LevelData.RespawnData.of(worldserver.dimension(), new BlockPos(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw(), spawn.getPitch()));
                    return;
                }
            }
            levelloadlistener.start(LevelLoadListener.Stage.PREPARE_GLOBAL_SPAWN, 0);
            levelloadlistener.updateFocus(worldserver.dimension(), chunkcoordintpair);
            int i = chunkproviderserver.getGenerator().getSpawnHeight(worldserver);
            if (i < worldserver.getMinY()) {
                BlockPos blockposition = chunkcoordintpair.getWorldPosition();
                i = worldserver.getHeight(Heightmap.Types.WORLD_SURFACE, blockposition.getX() + 8, blockposition.getZ() + 8);
            }
            iworlddataserver.setSpawn(LevelData.RespawnData.of(worldserver.dimension(), chunkcoordintpair.getWorldPosition().offset(8, i, 8), 0.0f, 0.0f));
            int j = 0;
            int k = 0;
            int l = 0;
            int i1 = -1;
            for (int j1 = 0; j1 < Mth.square(11); ++j1) {
                BlockPos blockposition1;
                if (j >= -5 && j <= 5 && k >= -5 && k <= 5 && (blockposition1 = PlayerSpawnFinder.getSpawnPosInChunk(worldserver, new ChunkPos(chunkcoordintpair.x + j, chunkcoordintpair.z + k))) != null) {
                    iworlddataserver.setSpawn(LevelData.RespawnData.of(worldserver.dimension(), blockposition1, 0.0f, 0.0f));
                    break;
                }
                if (j == k || j < 0 && j == -k || j > 0 && j == 1 - k) {
                    int k1 = l;
                    l = -i1;
                    i1 = k1;
                }
                j += l;
                k += i1;
            }
            if (flag) {
                worldserver.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.get(MiscOverworldFeatures.BONUS_CHEST)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(worldserver, chunkproviderserver.getGenerator(), worldserver.random, iworlddataserver.getRespawnData().pos()));
            }
            levelloadlistener.finish(LevelLoadListener.Stage.PREPARE_GLOBAL_SPAWN);
        }
    }

    private void setupDebugLevel(WorldData savedata) {
        savedata.setDifficulty(Difficulty.PEACEFUL);
        savedata.setDifficultyLocked(true);
        ServerLevelData iworlddataserver = savedata.overworldData();
        iworlddataserver.setRaining(false);
        iworlddataserver.setThundering(false);
        iworlddataserver.setClearWeatherTime(1000000000);
        iworlddataserver.setDayTime(6000L);
        iworlddataserver.setGameType(GameType.SPECTATOR);
    }

    public void prepareLevels(ServerLevel worldserver) {
        this.forceTicks = true;
        ChunkLoadCounter chunkloadcounter = new ChunkLoadCounter();
        chunkloadcounter.track(worldserver, () -> {
            TicketStorage ticketstorage = worldserver.getDataStorage().get(TicketStorage.TYPE);
            if (ticketstorage != null) {
                ticketstorage.activateAllDeactivatedTickets();
            }
        });
        this.levelLoadListener.start(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS, chunkloadcounter.totalChunks());
        do {
            this.levelLoadListener.update(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS, chunkloadcounter.readyChunks(), chunkloadcounter.totalChunks());
            this.executeModerately();
        } while (chunkloadcounter.pendingChunks() > 0);
        this.levelLoadListener.finish(LevelLoadListener.Stage.LOAD_INITIAL_CHUNKS);
        this.forceTicks = false;
        this.updateEffectiveRespawnData();
    }

    protected GlobalPos selectLevelLoadFocusPos() {
        return this.worldData.overworldData().getRespawnData().globalPos();
    }

    public GameType getDefaultGameType() {
        return this.worldData.getGameType();
    }

    public boolean isHardcore() {
        return this.worldData.isHardcore();
    }

    public abstract int operatorUserPermissionLevel();

    public abstract int getFunctionCompilationLevel();

    public abstract boolean shouldRconBroadcast();

    public boolean saveAllChunks(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3 = false;
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (!flag) {
                LOGGER.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.dimension().location());
            }
            worldserver.save(null, flag1, SharedConstants.DEBUG_DONT_SAVE_WORLD || worldserver.noSave && !flag2);
            flag3 = true;
        }
        if (flag1) {
            for (ServerLevel worldserver1 : this.getAllLevels()) {
                LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver1.getChunkSource().chunkMap.getStorageName());
            }
            LOGGER.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEverything(boolean flag, boolean flag1, boolean flag2) {
        boolean flag3;
        try {
            this.isSaving = true;
            this.getPlayerList().saveAll();
            flag3 = this.saveAllChunks(flag, flag1, flag2);
        }
        finally {
            this.isSaving = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        Iterator<ServerLevel> iterator = this.stopLock;
        synchronized (iterator) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        this.packetProcessor.close();
        if (this.metricsRecorder.isRecording()) {
            this.cancelRecordingMetrics();
        }
        LOGGER.info("Stopping server");
        if (this.server != null) {
            this.server.disablePlugins();
        }
        this.getConnection().stop();
        this.isSaving = true;
        if (this.playerList != null) {
            LOGGER.info("Saving players");
            this.playerList.saveAll();
            this.playerList.removeAll();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LOGGER.info("Saving worlds");
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.noSave = false;
        }
        while (this.levels.values().stream().anyMatch(worldserver1 -> worldserver1.getChunkSource().chunkMap.hasWork())) {
            this.nextTickTimeNanos = Util.getNanos() + TimeUtil.NANOSECONDS_PER_MILLISECOND;
            for (ServerLevel worldserver12 : this.getAllLevels()) {
                worldserver12.getChunkSource().deactivateTicketsOnClosing();
                worldserver12.getChunkSource().tick(() -> true, false);
            }
            this.waitUntilNextTick();
        }
        this.saveAllChunks(false, true, false);
        for (ServerLevel worldserver2 : this.getAllLevels()) {
            if (worldserver2 == null) continue;
            try {
                worldserver2.close();
            }
            catch (IOException ioexception) {
                LOGGER.error("Exception closing the level", (Throwable)ioexception);
            }
        }
        this.isSaving = false;
        this.resources.close();
        try {
            this.storageSource.close();
        }
        catch (IOException ioexception1) {
            LOGGER.error("Failed to unlock level {}", (Object)this.storageSource.getLevelId(), (Object)ioexception1);
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            LOGGER.info("Saving usercache.json");
            this.services().nameToIdCache().save();
        }
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String s) {
        this.localIp = s;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void halt(boolean flag) {
        this.running = false;
        if (flag) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedexception) {
                LOGGER.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runServer() {
        try {
            if (!this.initServer()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.nextTickTimeNanos = Util.getNanos();
            this.statusIcon = this.loadStatusIcon().orElse(null);
            this.status = this.buildServerStatus();
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = Util.getMillis();
            long tickCount = 1L;
            while (this.running) {
                boolean flag;
                long i;
                if (!this.isPaused() && this.tickRateManager.isSprinting() && this.tickRateManager.checkShouldSprintThisTick()) {
                    i = 0L;
                    this.lastOverloadWarningNanos = this.nextTickTimeNanos = Util.getNanos();
                } else {
                    i = this.tickRateManager.nanosecondsPerTick();
                    long j = Util.getNanos() - this.nextTickTimeNanos;
                    if (j > OVERLOADED_THRESHOLD_NANOS + 20L * i && this.nextTickTimeNanos - this.lastOverloadWarningNanos >= OVERLOADED_WARNING_INTERVAL_NANOS + 100L * i) {
                        long k = j / i;
                        if (this.server.getWarnOnOverload()) {
                            LOGGER.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j / TimeUtil.NANOSECONDS_PER_MILLISECOND), (Object)k);
                        }
                        this.nextTickTimeNanos += k * i;
                        this.lastOverloadWarningNanos = this.nextTickTimeNanos;
                    }
                }
                if (tickCount++ % 100L == 0L) {
                    long curTime = Util.getMillis();
                    double currentTps = 1000.0 / (double)(curTime - tickSection) * 100.0;
                    this.recentTps[0] = MinecraftServer.calcTps(this.recentTps[0], 0.92, currentTps);
                    this.recentTps[1] = MinecraftServer.calcTps(this.recentTps[1], 0.9835, currentTps);
                    this.recentTps[2] = MinecraftServer.calcTps(this.recentTps[2], 0.9945, currentTps);
                    tickSection = curTime;
                }
                boolean bl = flag = i == 0L;
                if (this.debugCommandProfilerDelayStart) {
                    this.debugCommandProfilerDelayStart = false;
                    this.debugCommandProfiler = new TimeProfiler(Util.getNanos(), this.tickCount);
                }
                currentTick = (int)(System.currentTimeMillis() / 50L);
                this.nextTickTimeNanos += i;
                try (Profiler.Scope profiler_a = Profiler.use(this.createProfiler());){
                    ProfilerFiller gameprofilerfiller = Profiler.get();
                    gameprofilerfiller.push("tick");
                    this.tickFrame.start();
                    gameprofilerfiller.push("scheduledPacketProcessing");
                    this.packetProcessor.processQueuedPackets();
                    gameprofilerfiller.pop();
                    this.tickServer(flag ? () -> false : this::haveTime);
                    this.tickFrame.end();
                    gameprofilerfiller.popPush("nextTickWait");
                    this.mayHaveDelayedTasks = true;
                    this.delayedTasksMaxNextTickTimeNanos = Math.max(Util.getNanos() + i, this.nextTickTimeNanos);
                    this.startMeasuringTaskExecutionTime();
                    this.waitUntilNextTick();
                    this.finishMeasuringTaskExecutionTime();
                    if (flag) {
                        this.tickRateManager.endTickWork();
                    }
                    gameprofilerfiller.pop();
                    this.logFullTickTime();
                }
                finally {
                    this.endMetricsRecordingTick();
                }
                this.isReady = true;
                JvmProfiler.INSTANCE.onServerTick(this.smoothedTickTimeMillis);
            }
            return;
        }
        catch (Throwable throwable2) {
            LOGGER.error("Encountered an unexpected exception", throwable2);
            CrashReport crashreport = MinecraftServer.constructOrExtractCrashReport(throwable2);
            this.fillSystemReport(crashreport.getSystemReport());
            Path path = this.getServerDirectory().resolve("crash-reports").resolve("crash-" + Util.getFilenameFormattedDateTime() + "-server.txt");
            if (crashreport.saveToFile(path, ReportType.CRASH)) {
                LOGGER.error("This crash report has been saved to: {}", (Object)path.toAbsolutePath());
            } else {
                LOGGER.error("We were unable to save this crash report to disk.");
            }
            this.onServerCrash(crashreport);
            return;
        }
        finally {
            try {
                this.stopped = true;
                this.stopServer();
            }
            catch (Throwable throwable3) {
                LOGGER.error("Exception stopping the server", throwable3);
            }
            finally {
                WatchdogThread.doStop();
                try {
                    this.terminal.close();
                }
                catch (Exception tickSection) {}
                this.onServerExit();
            }
        }
    }

    private void logFullTickTime() {
        long i = Util.getNanos();
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logSample(i - this.lastTickNanos);
        }
        this.lastTickNanos = i;
    }

    private void startMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            this.taskExecutionStartNanos = Util.getNanos();
            this.idleTimeNanos = 0L;
        }
    }

    private void finishMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            SampleLogger samplelogger = this.getTickTimeLogger();
            samplelogger.logPartialSample(Util.getNanos() - this.taskExecutionStartNanos - this.idleTimeNanos, TpsDebugDimensions.SCHEDULED_TASKS.ordinal());
            samplelogger.logPartialSample(this.idleTimeNanos, TpsDebugDimensions.IDLE.ordinal());
        }
    }

    private static CrashReport constructOrExtractCrashReport(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.getReport();
            if (reportedexception != throwable) {
                crashreport.addCategory("Wrapped in").setDetailError("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean haveTime() {
        return this.forceTicks || this.runningTask() || Util.getNanos() < (this.mayHaveDelayedTasks ? this.delayedTasksMaxNextTickTimeNanos : this.nextTickTimeNanos);
    }

    private void executeModerately() {
        this.runAllTasks();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    public static boolean throwIfFatalException() {
        RuntimeException runtimeexception = fatalException.get();
        if (runtimeexception != null) {
            throw runtimeexception;
        }
        return true;
    }

    public static void setFatalException(RuntimeException runtimeexception) {
        fatalException.compareAndSet(null, runtimeexception);
    }

    @Override
    public void managedBlock(BooleanSupplier booleansupplier) {
        super.managedBlock(() -> MinecraftServer.throwIfFatalException() && booleansupplier.getAsBoolean());
    }

    public NotificationManager notificationManager() {
        return this.notificationManager;
    }

    protected void waitUntilNextTick() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("scheduledPacketProcessing");
        this.packetProcessor.processQueuedPackets();
        gameprofilerfiller.pop();
        this.runAllTasks();
        this.waitingForNextTick = true;
        try {
            this.managedBlock(() -> !this.haveTime());
        }
        finally {
            this.waitingForNextTick = false;
        }
    }

    @Override
    public void waitForTasks() {
        boolean flag = this.isTickTimeLoggingEnabled();
        long i = flag ? Util.getNanos() : 0L;
        long j = this.waitingForNextTick ? this.nextTickTimeNanos - Util.getNanos() : 100000L;
        LockSupport.parkNanos("waiting for tasks", j);
        if (flag) {
            this.idleTimeNanos += Util.getNanos() - i;
        }
    }

    @Override
    public TickTask wrapRunnable(Runnable runnable) {
        return new TickTask(this.tickCount, runnable);
    }

    @Override
    protected boolean shouldRun(TickTask ticktask) {
        return ticktask.getTick() + 3 < this.tickCount || this.haveTime();
    }

    @Override
    public boolean pollTask() {
        boolean flag;
        this.mayHaveDelayedTasks = flag = this.pollTaskInternal();
        return flag;
    }

    private boolean pollTaskInternal() {
        if (super.pollTask()) {
            return true;
        }
        if (this.tickRateManager.isSprinting() || this.shouldRunAllTasks() || this.haveTime()) {
            for (ServerLevel worldserver : this.getAllLevels()) {
                if (!worldserver.getChunkSource().pollTask()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doRunTask(TickTask ticktask) {
        Profiler.get().incrementCounter("runTask");
        super.doRunTask(ticktask);
    }

    private Optional<ServerStatus.Favicon> loadStatusIcon() {
        Optional<Path> optional = Optional.of(this.getFile("server-icon.png")).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.storageSource.getIconFile().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerStatus.Favicon(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                LOGGER.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> getWorldScreenshotFile() {
        return this.storageSource.getIconFile();
    }

    public Path getServerDirectory() {
        return Path.of("", new String[0]);
    }

    public void onServerCrash(CrashReport crashreport) {
    }

    public void onServerExit() {
    }

    public boolean isPaused() {
        return false;
    }

    public void tickServer(BooleanSupplier booleansupplier) {
        WatchdogThread.tick();
        long i = Util.getNanos();
        int j = this.pauseWhenEmptySeconds() * 20;
        if (j > 0) {
            this.emptyTicks = this.playerList.getPlayerCount() == 0 && !this.tickRateManager.isSprinting() ? ++this.emptyTicks : 0;
            if (this.emptyTicks >= j) {
                if (this.emptyTicks == j) {
                    LOGGER.info("Server empty for {} seconds, pausing", (Object)this.pauseWhenEmptySeconds());
                    this.autoSave();
                }
                this.server.getScheduler().mainThreadHeartbeat();
                this.tickConnection();
                return;
            }
        }
        SpigotTimings.serverTickTimer.startTiming();
        ++this.tickCount;
        this.tickRateManager.tick();
        this.tickChildren(booleansupplier);
        if (i - this.lastServerStatus >= STATUS_EXPIRE_TIME_NANOS) {
            this.lastServerStatus = i;
            this.status = this.buildServerStatus();
        }
        --this.ticksUntilAutosave;
        if (this.autosavePeriod > 0 && this.ticksUntilAutosave <= 0) {
            this.autoSave();
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("tallying");
        long k = Util.getNanos() - i;
        int l = this.tickCount % 100;
        this.aggregatedTickTimesNanos -= this.tickTimesNanos[l];
        this.aggregatedTickTimesNanos += k;
        this.tickTimesNanos[l] = k;
        this.smoothedTickTimeMillis = this.smoothedTickTimeMillis * 0.8f + (float)k / (float)TimeUtil.NANOSECONDS_PER_MILLISECOND * 0.19999999f;
        this.logTickMethodTime(i);
        gameprofilerfiller.pop();
        SpigotTimings.serverTickTimer.stopTiming();
        CustomTimingsHandler.tick();
    }

    private void autoSave() {
        this.ticksUntilAutosave = this.autosavePeriod;
        SpigotTimings.worldSaveTimer.startTiming();
        LOGGER.debug("Autosave started");
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("save");
        this.saveEverything(true, false, false);
        gameprofilerfiller.pop();
        LOGGER.debug("Autosave finished");
        SpigotTimings.worldSaveTimer.stopTiming();
    }

    private void logTickMethodTime(long i) {
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logPartialSample(Util.getNanos() - i, TpsDebugDimensions.TICK_SERVER_METHOD.ordinal());
        }
    }

    private int computeNextAutosaveInterval() {
        float f;
        if (this.tickRateManager.isSprinting()) {
            long i = this.getAverageTickTimeNanos() + 1L;
            f = (float)TimeUtil.NANOSECONDS_PER_SECOND / (float)i;
        } else {
            f = this.tickRateManager.tickrate();
        }
        int j = 300;
        return Math.max(100, (int)(f * 300.0f));
    }

    public void onTickRateChanged() {
        int i = this.computeNextAutosaveInterval();
        if (i < this.ticksUntilAutosave) {
            this.ticksUntilAutosave = i;
        }
    }

    protected abstract SampleLogger getTickTimeLogger();

    public abstract boolean isTickTimeLoggingEnabled();

    private ServerStatus buildServerStatus() {
        ServerStatus.Players serverping_serverpingplayersample = this.buildPlayerStatus();
        return new ServerStatus(Component.nullToEmpty(this.getMotd()), Optional.of(serverping_serverpingplayersample), Optional.of(ServerStatus.Version.current()), Optional.ofNullable(this.statusIcon), this.enforceSecureProfile());
    }

    private ServerStatus.Players buildPlayerStatus() {
        List<ServerPlayer> list = this.playerList.getPlayers();
        int i = this.getMaxPlayers();
        if (this.hidesOnlinePlayers()) {
            return new ServerStatus.Players(i, list.size(), List.of());
        }
        int j = Math.min(list.size(), 12);
        ObjectArrayList objectarraylist = new ObjectArrayList(j);
        int k = Mth.nextInt(this.random, 0, list.size() - j);
        for (int l = 0; l < j; ++l) {
            ServerPlayer entityplayer = list.get(k + l);
            objectarraylist.add((Object)(entityplayer.allowsListing() ? entityplayer.nameAndId() : ANONYMOUS_PLAYER_PROFILE));
        }
        Util.shuffle(objectarraylist, this.random);
        return new ServerStatus.Players(i, list.size(), (List<NameAndId>)objectarraylist);
    }

    protected void tickChildren(BooleanSupplier booleansupplier) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        this.getPlayerList().getPlayers().forEach(entityplayer -> entityplayer.connection.suspendFlushing());
        SpigotTimings.schedulerTimer.startTiming();
        this.server.getScheduler().mainThreadHeartbeat();
        SpigotTimings.schedulerTimer.stopTiming();
        gameprofilerfiller.push("commandFunctions");
        SpigotTimings.commandFunctionsTimer.startTiming();
        this.getFunctions().tick();
        SpigotTimings.commandFunctionsTimer.stopTiming();
        gameprofilerfiller.popPush("levels");
        this.updateEffectiveRespawnData();
        SpigotTimings.processQueueTimer.startTiming();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        SpigotTimings.processQueueTimer.stopTiming();
        SpigotTimings.timeUpdateTimer.startTiming();
        if (this.tickCount % 20 == 0) {
            for (int i = 0; i < this.getPlayerList().players.size(); ++i) {
                ServerPlayer entityplayer2 = this.getPlayerList().players.get(i);
                entityplayer2.connection.send(new ClientboundSetTimePacket(entityplayer2.level().getGameTime(), entityplayer2.getPlayerTime(), entityplayer2.level().getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
            }
        }
        SpigotTimings.timeUpdateTimer.stopTiming();
        for (ServerLevel worldserver : this.getAllLevels()) {
            gameprofilerfiller.push(() -> {
                String s = String.valueOf(worldserver);
                return s + " " + String.valueOf(worldserver.dimension().location());
            });
            gameprofilerfiller.push("tick");
            try {
                worldserver.timings.doTick.startTiming();
                worldserver.tick(booleansupplier);
                worldserver.timings.doTick.stopTiming();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception ticking world");
                worldserver.fillReportDetails(crashreport);
                throw new ReportedException(crashreport);
            }
            gameprofilerfiller.pop();
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.popPush("connection");
        SpigotTimings.connectionTimer.startTiming();
        this.tickConnection();
        SpigotTimings.connectionTimer.stopTiming();
        gameprofilerfiller.popPush("players");
        SpigotTimings.playerListTimer.startTiming();
        this.playerList.tick();
        SpigotTimings.playerListTimer.stopTiming();
        gameprofilerfiller.popPush("debugSubscribers");
        this.debugSubscribers.tick();
        if (this.tickRateManager.runsNormally()) {
            gameprofilerfiller.popPush("gameTests");
            GameTestTicker.SINGLETON.tick();
        }
        gameprofilerfiller.popPush("server gui refresh");
        SpigotTimings.tickablesTimer.startTiming();
        for (int i = 0; i < this.tickables.size(); ++i) {
            this.tickables.get(i).run();
        }
        SpigotTimings.tickablesTimer.stopTiming();
        gameprofilerfiller.popPush("send chunks");
        for (ServerPlayer entityplayer2 : this.playerList.getPlayers()) {
            entityplayer2.connection.chunkSender.sendNextChunks(entityplayer2);
            entityplayer2.connection.resumeFlushing();
        }
        gameprofilerfiller.pop();
    }

    private void updateEffectiveRespawnData() {
        LevelData.RespawnData worlddata_a = this.worldData.overworldData().getRespawnData();
        ServerLevel worldserver = this.findRespawnDimension();
        this.effectiveRespawnData = worldserver.getWorldBorderAdjustedRespawnData(worlddata_a);
    }

    public void tickConnection() {
        this.getConnection().tick();
    }

    private void synchronizeTime(ServerLevel worldserver) {
        this.playerList.broadcastAll(new ClientboundSetTimePacket(worldserver.getGameTime(), worldserver.getDayTime(), worldserver.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)), worldserver.dimension());
    }

    public void forceTimeSynchronization() {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("timeSync");
        for (ServerLevel worldserver : this.getAllLevels()) {
            this.synchronizeTime(worldserver);
        }
        gameprofilerfiller.pop();
    }

    public boolean isAllowedToEnterPortal(Level world) {
        return world.dimension() == Level.NETHER ? this.getGameRules().getBoolean(GameRules.RULE_ALLOW_NETHER) : true;
    }

    public void addTickable(Runnable runnable) {
        this.tickables.add(runnable);
    }

    protected void setId(String s) {
        this.serverId = s;
    }

    public boolean isShutdown() {
        return !this.serverThread.isAlive();
    }

    public Path getFile(String s) {
        return this.getServerDirectory().resolve(s);
    }

    public final ServerLevel overworld() {
        return this.levels.get(Level.OVERWORLD);
    }

    @Nullable
    public ServerLevel getLevel(ResourceKey<Level> resourcekey) {
        return this.levels.get(resourcekey);
    }

    public void addLevel(ServerLevel level) {
        Map<ResourceKey<Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.dimension(), level);
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(ServerLevel level) {
        Map<ResourceKey<Level>, ServerLevel> oldLevels = this.levels;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.dimension());
        this.levels = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<Level>> levelKeys() {
        return this.levels.keySet();
    }

    public Iterable<ServerLevel> getAllLevels() {
        return this.levels.values();
    }

    @Override
    public String getServerVersion() {
        return SharedConstants.getCurrentVersion().name();
    }

    @Override
    public int getPlayerCount() {
        return this.playerList.getPlayerCount();
    }

    public String[] getPlayerNames() {
        return this.playerList.getPlayerNamesArray();
    }

    @DontObfuscate
    public String getServerModName() {
        return "Spigot";
    }

    public SystemReport fillSystemReport(SystemReport systemreport) {
        systemreport.setDetail("Server Running", () -> Boolean.toString(this.running));
        if (this.playerList != null) {
            systemreport.setDetail("Player Count", () -> {
                int i = this.playerList.getPlayerCount();
                return i + " / " + this.playerList.getMaxPlayers() + "; " + String.valueOf(this.playerList.getPlayers());
            });
        }
        systemreport.setDetail("Active Data Packs", () -> PackRepository.displayPackList(this.packRepository.getSelectedPacks()));
        systemreport.setDetail("Available Data Packs", () -> PackRepository.displayPackList(this.packRepository.getAvailablePacks()));
        systemreport.setDetail("Enabled Feature Flags", () -> FeatureFlags.REGISTRY.toNames(this.worldData.enabledFeatures()).stream().map(ResourceLocation::toString).collect(Collectors.joining(", ")));
        systemreport.setDetail("World Generation", () -> this.worldData.worldGenSettingsLifecycle().toString());
        systemreport.setDetail("World Seed", () -> String.valueOf(this.worldData.worldGenOptions().seed()));
        SuppressedExceptionCollector suppressedexceptioncollector = this.suppressedExceptions;
        Objects.requireNonNull(this.suppressedExceptions);
        systemreport.setDetail("Suppressed Exceptions", suppressedexceptioncollector::dump);
        if (this.serverId != null) {
            systemreport.setDetail("Server Id", () -> this.serverId);
        }
        return this.fillServerSystemReport(systemreport);
    }

    public abstract SystemReport fillServerSystemReport(SystemReport var1);

    public ModCheck getModdedStatus() {
        return ModCheck.identify(VANILLA_BRAND, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void sendSystemMessage(Component ichatbasecomponent) {
        LOGGER.info(ichatbasecomponent.getString());
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int i) {
        this.port = i;
    }

    @Nullable
    public GameProfile getSingleplayerProfile() {
        return this.singleplayerProfile;
    }

    public void setSingleplayerProfile(@Nullable GameProfile gameprofile) {
        this.singleplayerProfile = gameprofile;
    }

    public boolean isSingleplayer() {
        return this.singleplayerProfile != null;
    }

    protected void initializeKeyPair() {
        LOGGER.info("Generating keypair");
        try {
            this.keyPair = Crypt.generateKeyPair();
        }
        catch (CryptException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(Difficulty enumdifficulty, boolean flag) {
        if (flag || !this.worldData.isDifficultyLocked()) {
            this.worldData.setDifficulty(this.worldData.isHardcore() ? Difficulty.HARD : enumdifficulty);
            this.updateMobSpawningFlags();
            this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
        }
    }

    public int getScaledTrackingDistance(int i) {
        return i;
    }

    private void updateMobSpawningFlags() {
        for (ServerLevel worldserver : this.getAllLevels()) {
            worldserver.setSpawnSettings(MinecraftServer.isSpawningMonsters(worldserver));
        }
    }

    public void setDifficultyLocked(boolean flag) {
        this.worldData.setDifficultyLocked(flag);
        this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
    }

    private void sendDifficultyUpdate(ServerPlayer entityplayer) {
        LevelData worlddata = entityplayer.level().getLevelData();
        entityplayer.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
    }

    public static boolean isSpawningMonsters(ServerLevel worldserver) {
        return worldserver.getDifficulty() != Difficulty.PEACEFUL && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && worldserver.getGameRules().getBoolean(GameRules.RULE_SPAWN_MONSTERS);
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean flag) {
        this.isDemo = flag;
    }

    public Map<String, String> getCodeOfConducts() {
        return Map.of();
    }

    public Optional<ServerResourcePackInfo> getServerResourcePack() {
        return Optional.empty();
    }

    public boolean isResourcePackRequired() {
        return this.getServerResourcePack().filter(ServerResourcePackInfo::isRequired).isPresent();
    }

    public abstract boolean isDedicatedServer();

    public abstract int getRateLimitPacketsPerSecond();

    public boolean usesAuthentication() {
        return this.onlineMode;
    }

    public void setUsesAuthentication(boolean flag) {
        this.onlineMode = flag;
    }

    public boolean getPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public void setPreventProxyConnections(boolean flag) {
        this.preventProxyConnections = flag;
    }

    public abstract boolean isEpollEnabled();

    public boolean isPvpAllowed() {
        return this.getGameRules().getBoolean(GameRules.RULE_PVP);
    }

    public boolean allowFlight() {
        return true;
    }

    public boolean isCommandBlockEnabled() {
        return this.getGameRules().getBoolean(GameRules.RULE_COMMAND_BLOCKS_ENABLED);
    }

    public boolean isSpawnerBlockEnabled() {
        return this.getGameRules().getBoolean(GameRules.RULE_SPAWNER_BLOCKS_ENABLED);
    }

    @Override
    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String s) {
        this.motd = s;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public void setPlayerList(PlayerList playerlist) {
        this.playerList = playerlist;
    }

    public abstract boolean isPublished();

    public void setDefaultGameType(GameType enumgamemode) {
        this.worldData.setGameType(enumgamemode);
    }

    public int enforceGameTypeForPlayers(@Nullable GameType enumgamemode) {
        if (enumgamemode == null) {
            return 0;
        }
        int i = 0;
        for (ServerPlayer entityplayer : this.getPlayerList().getPlayers()) {
            if (!entityplayer.setGameMode(enumgamemode)) continue;
            ++i;
        }
        return i;
    }

    public ServerConnectionListener getConnection() {
        return this.connection == null ? (this.connection = new ServerConnectionListener(this)) : this.connection;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean publishServer(@Nullable GameType enumgamemode, boolean flag, int i) {
        return false;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public boolean isUnderSpawnProtection(ServerLevel worldserver, BlockPos blockposition, Player entityhuman) {
        return false;
    }

    public boolean repliesToStatus() {
        return true;
    }

    public boolean hidesOnlinePlayers() {
        return false;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int playerIdleTimeout() {
        return this.playerIdleTimeout;
    }

    public void setPlayerIdleTimeout(int i) {
        this.playerIdleTimeout = i;
    }

    public Services services() {
        return this.services;
    }

    @Nullable
    public ServerStatus getStatus() {
        return this.status;
    }

    public void invalidateStatus() {
        this.lastServerStatus = 0L;
    }

    public int getAbsoluteMaxWorldSize() {
        return 29999984;
    }

    @Override
    public boolean scheduleExecutables() {
        return super.scheduleExecutables() && !this.isStopped();
    }

    @Override
    public void executeIfPossible(Runnable runnable) {
        if (this.isStopped()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.executeIfPossible(runnable);
    }

    @Override
    public Thread getRunningThread() {
        return this.serverThread;
    }

    public int getCompressionThreshold() {
        return 256;
    }

    public boolean enforceSecureProfile() {
        return false;
    }

    public long getNextTickTime() {
        return this.nextTickTimeNanos;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public ServerAdvancementManager getAdvancements() {
        return this.resources.managers.getAdvancements();
    }

    public ServerFunctionManager getFunctions() {
        return this.functionManager;
    }

    public CompletableFuture<Void> reloadResources(Collection<String> collection) {
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = collection.stream();
            PackRepository resourcepackrepository = this.packRepository;
            Objects.requireNonNull(this.packRepository);
            return (ImmutableList)stream.map(resourcepackrepository::getPack).filter(Objects::nonNull).map(Pack::open).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            MultiPackResourceManager ireloadableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, (List<PackResources>)immutablelist);
            List<Registry.PendingTags<?>> list = TagLoader.loadTagsForExistingRegistries(ireloadableresourcemanager, this.registries.compositeAccess());
            return ((CompletableFuture)ReloadableServerResources.loadResources(ireloadableresourcemanager, this.registries, list, this.worldData.enabledFeatures(), this.isDedicatedServer() ? Commands.CommandSelection.DEDICATED : Commands.CommandSelection.INTEGRATED, this.getFunctionCompilationLevel(), this.executor, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    ireloadableresourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(ireloadableresourcemanager, (ReloadableServerResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.resources.close();
            this.resources = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.packRepository.setSelected(collection);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.getSelectedPacks(this.packRepository, true), this.worldData.enabledFeatures());
            this.worldData.setDataConfiguration(worlddataconfiguration);
            this.resources.managers.updateStaticRegistryTags();
            this.resources.managers.getRecipeManager().finalizeRecipeLoading(this.worldData.enabledFeatures());
            this.getPlayerList().saveAll();
            this.getPlayerList().reloadResources();
            this.functionManager.replaceLibrary(this.resources.managers.getFunctionLibrary());
            this.structureTemplateManager.onResourceManagerReload(this.resources.resourceManager);
            this.fuelValues = FuelValues.vanillaBurnTimes(this.registries.compositeAccess(), this.worldData.enabledFeatures());
        }, (Executor)this);
        if (this.isSameThread()) {
            Objects.requireNonNull(completablefuture);
            this.managedBlock(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration configurePackRepository(PackRepository resourcepackrepository, WorldDataConfiguration worlddataconfiguration, boolean flag, boolean flag1) {
        DataPackConfig datapackconfiguration = worlddataconfiguration.dataPacks();
        FeatureFlagSet featureflagset = flag ? FeatureFlagSet.of() : worlddataconfiguration.enabledFeatures();
        FeatureFlagSet featureflagset1 = flag ? FeatureFlags.REGISTRY.allFlags() : worlddataconfiguration.enabledFeatures();
        resourcepackrepository.reload();
        if (flag1) {
            return MinecraftServer.configureRepositoryWithSelection(resourcepackrepository, List.of(VANILLA_BRAND), featureflagset, false);
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s : datapackconfiguration.getEnabled()) {
            if (resourcepackrepository.isAvailable(s)) {
                set.add(s);
                continue;
            }
            LOGGER.warn("Missing data pack {}", (Object)s);
        }
        for (Pack resourcepackloader : resourcepackrepository.getAvailablePacks()) {
            String s1 = resourcepackloader.getId();
            if (datapackconfiguration.getDisabled().contains(s1)) continue;
            FeatureFlagSet featureflagset2 = resourcepackloader.getRequestedFeatures();
            boolean flag2 = set.contains(s1);
            if (!flag2 && resourcepackloader.getPackSource().shouldAddAutomatically()) {
                if (featureflagset2.isSubsetOf(featureflagset1)) {
                    LOGGER.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    LOGGER.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.printMissingFlags(featureflagset1, featureflagset2));
                }
            }
            if (!flag2 || featureflagset2.isSubsetOf(featureflagset1)) continue;
            LOGGER.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.printMissingFlags(featureflagset1, featureflagset2));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            LOGGER.info("No datapacks selected, forcing vanilla");
            set.add(VANILLA_BRAND);
        }
        return MinecraftServer.configureRepositoryWithSelection(resourcepackrepository, set, featureflagset, true);
    }

    private static WorldDataConfiguration configureRepositoryWithSelection(PackRepository resourcepackrepository, Collection<String> collection, FeatureFlagSet featureflagset, boolean flag) {
        resourcepackrepository.setSelected(collection);
        MinecraftServer.enableForcedFeaturePacks(resourcepackrepository, featureflagset);
        DataPackConfig datapackconfiguration = MinecraftServer.getSelectedPacks(resourcepackrepository, flag);
        FeatureFlagSet featureflagset1 = resourcepackrepository.getRequestedFeatureFlags().join(featureflagset);
        return new WorldDataConfiguration(datapackconfiguration, featureflagset1);
    }

    private static void enableForcedFeaturePacks(PackRepository resourcepackrepository, FeatureFlagSet featureflagset) {
        FeatureFlagSet featureflagset1 = resourcepackrepository.getRequestedFeatureFlags();
        FeatureFlagSet featureflagset2 = featureflagset.subtract(featureflagset1);
        if (!featureflagset2.isEmpty()) {
            ObjectArraySet set = new ObjectArraySet(resourcepackrepository.getSelectedIds());
            for (Pack resourcepackloader : resourcepackrepository.getAvailablePacks()) {
                if (featureflagset2.isEmpty()) break;
                if (resourcepackloader.getPackSource() != PackSource.FEATURE) continue;
                String s = resourcepackloader.getId();
                FeatureFlagSet featureflagset3 = resourcepackloader.getRequestedFeatures();
                if (featureflagset3.isEmpty() || !featureflagset3.intersects(featureflagset2) || !featureflagset3.isSubsetOf(featureflagset)) continue;
                if (!set.add(s)) {
                    throw new IllegalStateException("Tried to force '" + s + "', but it was already enabled");
                }
                LOGGER.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)s);
                featureflagset2 = featureflagset2.subtract(featureflagset3);
            }
            resourcepackrepository.setSelected((Collection<String>)set);
        }
    }

    private static DataPackConfig getSelectedPacks(PackRepository resourcepackrepository, boolean flag) {
        Collection<String> collection = resourcepackrepository.getSelectedIds();
        ImmutableList list = ImmutableList.copyOf(collection);
        List<String> list1 = flag ? resourcepackrepository.getAvailableIds().stream().filter(s -> !collection.contains(s)).toList() : List.of();
        return new DataPackConfig((List<String>)list, list1);
    }

    public void kickUnlistedPlayers() {
        if (this.isEnforceWhitelist() && this.isUsingWhitelist()) {
            PlayerList playerlist = this.getPlayerList();
            UserWhiteList whitelist = playerlist.getWhiteList();
            for (ServerPlayer entityplayer : Lists.newArrayList(playerlist.getPlayers())) {
                if (whitelist.isWhiteListed(entityplayer.nameAndId())) continue;
                entityplayer.connection.disconnect(Component.translatable("multiplayer.disconnect.not_whitelisted"));
            }
        }
    }

    public PackRepository getPackRepository() {
        return this.packRepository;
    }

    public Commands getCommands() {
        return this.resources.managers.getCommands();
    }

    public CommandSourceStack createCommandSourceStack() {
        ServerLevel worldserver = this.findRespawnDimension();
        return new CommandSourceStack(this, worldserver == null ? Vec3.ZERO : Vec3.atLowerCornerOf(this.getRespawnData().pos()), Vec2.ZERO, worldserver, 4, "Server", Component.literal("Server"), this, null);
    }

    public ServerLevel findRespawnDimension() {
        return this.findRespawnDimension(this.overworld());
    }

    public ServerLevel findRespawnDimension(ServerLevel world) {
        LevelData.RespawnData worlddata_a = world.getRespawnData();
        ResourceKey<Level> resourcekey = worlddata_a.dimension();
        ServerLevel worldserver = this.getLevel(resourcekey);
        return worldserver != null ? worldserver : this.overworld();
    }

    public void setRespawnData(LevelData.RespawnData worlddata_a) {
        this.setRespawnData(worlddata_a, this.overworld());
    }

    public void setRespawnData(LevelData.RespawnData worlddata_a, ServerLevel world) {
        PrimaryLevelData iworlddataserver = world.J;
        LevelData.RespawnData worlddata_a1 = iworlddataserver.getRespawnData();
        if (!worlddata_a1.equals(worlddata_a)) {
            iworlddataserver.setSpawn(worlddata_a);
            SpawnChangeEvent event = new SpawnChangeEvent((World)world.getWorld(), CraftLocation.toBukkit(worlddata_a1.pos(), (World)world.getWorld(), worlddata_a1.yaw(), worlddata_a1.pitch()));
            this.server.getPluginManager().callEvent((Event)event);
            this.getPlayerList().broadcastAll(new ClientboundSetDefaultSpawnPositionPacket(worlddata_a));
            this.updateEffectiveRespawnData();
        }
    }

    public LevelData.RespawnData getRespawnData() {
        return this.effectiveRespawnData;
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public abstract boolean shouldInformAdmins();

    public RecipeManager getRecipeManager() {
        return this.resources.managers.getRecipeManager();
    }

    public ServerScoreboard getScoreboard() {
        return this.scoreboard;
    }

    public CommandStorage getCommandStorage() {
        if (this.commandStorage == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.commandStorage;
    }

    public GameRules getGameRules() {
        return this.overworld().getGameRules();
    }

    public CustomBossEvents getCustomBossEvents() {
        return this.customBossEvents;
    }

    public boolean isEnforceWhitelist() {
        return this.enforceWhitelist;
    }

    public void setEnforceWhitelist(boolean flag) {
        this.enforceWhitelist = flag;
    }

    public boolean isUsingWhitelist() {
        return this.usingWhitelist;
    }

    public void setUsingWhitelist(boolean flag) {
        this.usingWhitelist = flag;
    }

    public float getCurrentSmoothedTickTime() {
        return this.smoothedTickTimeMillis;
    }

    public ServerTickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public long getAverageTickTimeNanos() {
        return this.aggregatedTickTimesNanos / (long)Math.min(100, Math.max(this.tickCount, 1));
    }

    public long[] getTickTimesNanos() {
        return this.tickTimesNanos;
    }

    public int getProfilePermissions(NameAndId nameandid) {
        if (this.getPlayerList().isOp(nameandid)) {
            ServerOpListEntry oplistentry = (ServerOpListEntry)this.getPlayerList().getOps().get(nameandid);
            return oplistentry != null ? oplistentry.getLevel() : (this.isSingleplayerOwner(nameandid) ? 4 : (this.isSingleplayer() ? (this.getPlayerList().isAllowCommandsForAllPlayers() ? 4 : 0) : this.operatorUserPermissionLevel()));
        }
        return 0;
    }

    public abstract boolean isSingleplayerOwner(NameAndId var1);

    public void dumpServerProperties(Path path) throws IOException {
    }

    private void saveDebugReport(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<Level>, ServerLevel> map_entry : this.levels.entrySet()) {
                ResourceLocation minecraftkey = map_entry.getKey().location();
                Path path2 = path1.resolve(minecraftkey.getNamespace()).resolve(minecraftkey.getPath());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                map_entry.getValue().saveDebugReport(path2);
            }
            this.dumpGameRules(path.resolve("gamerules.txt"));
            this.dumpClasspath(path.resolve("classpath.txt"));
            this.dumpMiscStats(path.resolve("stats.txt"));
            this.dumpThreads(path.resolve("threads.txt"));
            this.dumpServerProperties(path.resolve("server.properties.txt"));
            this.dumpNativeModules(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void dumpMiscStats(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getPendingTasksCount()));
            writer.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.getCurrentSmoothedTickTime())));
            writer.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.tickTimesNanos)));
            writer.write(String.format(Locale.ROOT, "queue: %s\n", Util.backgroundExecutor()));
        }
    }

    private void dumpGameRules(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.getGameRules();
            gamerules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

                @Override
                public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> gamerules_gamerulekey, GameRules.Type<T> gamerules_gameruledefinition) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", gamerules_gamerulekey.getId(), gamerules.getRule(gamerules_gamerulekey)));
                }
            });
            for (String s : list) {
                writer.write(s);
            }
        }
    }

    private void dumpClasspath(Path path) throws IOException {
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s2 : Splitter.on((String)s1).split((CharSequence)s)) {
                writer.write(s2);
                writer.write("\n");
            }
        }
    }

    private void dumpThreads(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            for (ThreadInfo threadinfo : athreadinfo) {
                writer.write(threadinfo.toString());
                ((Writer)writer).write(10);
            }
        }
    }

    private void dumpNativeModules(Path path) throws IOException {
        BufferedWriter writer = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);
        try {
            ArrayList list;
            try {
                list = Lists.newArrayList(NativeModuleLister.listModules());
            }
            catch (Throwable throwable) {
                LOGGER.warn("Failed to list native modules", throwable);
                if (writer != null) {
                    ((Writer)writer).close();
                }
                return;
            }
            list.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.name));
            for (NativeModuleLister.NativeModuleInfo nativemodulelister_a2 : list) {
                writer.write(nativemodulelister_a2.toString());
                ((Writer)writer).write(10);
            }
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public boolean isDebugging() {
        return false;
    }

    @Deprecated
    public static MinecraftServer getServer() {
        return Bukkit.getServer() instanceof CraftServer ? ((CraftServer)Bukkit.getServer()).getServer() : null;
    }

    @Deprecated
    public static RegistryAccess getDefaultRegistryAccess() {
        return CraftRegistry.getMinecraftRegistry();
    }

    private ProfilerFiller createProfiler() {
        if (this.willStartRecordingMetrics) {
            this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ServerMetricsSamplersProvider(Util.timeSource, this.isDedicatedServer()), Util.timeSource, Util.ioPool(), new MetricsPersister("server"), this.onMetricsRecordingStopped, path -> {
                this.executeBlocking(() -> this.saveDebugReport(path.resolve("server")));
                this.onMetricsRecordingFinished.accept((Path)path);
            });
            this.willStartRecordingMetrics = false;
        }
        this.metricsRecorder.startTick();
        return SingleTickProfiler.decorateFiller(this.metricsRecorder.getProfiler(), SingleTickProfiler.createTickProfiler("Server"));
    }

    public void endMetricsRecordingTick() {
        this.metricsRecorder.endTick();
    }

    public boolean isRecordingMetrics() {
        return this.metricsRecorder.isRecording();
    }

    public void startRecordingMetrics(Consumer<ProfileResults> consumer, Consumer<Path> consumer1) {
        this.onMetricsRecordingStopped = methodprofilerresults -> {
            this.stopRecordingMetrics();
            consumer.accept((ProfileResults)methodprofilerresults);
        };
        this.onMetricsRecordingFinished = consumer1;
        this.willStartRecordingMetrics = true;
    }

    public void stopRecordingMetrics() {
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    }

    public void finishRecordingMetrics() {
        this.metricsRecorder.end();
    }

    public void cancelRecordingMetrics() {
        this.metricsRecorder.cancel();
    }

    public Path getWorldPath(LevelResource savedfile) {
        return this.storageSource.getLevelPath(savedfile);
    }

    public boolean forceSynchronousWrites() {
        return true;
    }

    public StructureTemplateManager getStructureManager() {
        return this.structureTemplateManager;
    }

    public WorldData getWorldData() {
        return this.worldData;
    }

    public RegistryAccess.Frozen registryAccess() {
        return this.registries.compositeAccess();
    }

    public LayeredRegistryAccess<RegistryLayer> registries() {
        return this.registries;
    }

    public ReloadableServerRegistries.Holder reloadableRegistries() {
        return this.resources.managers.fullRegistries();
    }

    public TextFilter createTextFilterForPlayer(ServerPlayer entityplayer) {
        return TextFilter.DUMMY;
    }

    public ServerPlayerGameMode createGameModeForPlayer(ServerPlayer entityplayer) {
        return this.isDemo() ? new DemoMode(entityplayer) : new ServerPlayerGameMode(entityplayer);
    }

    @Nullable
    public GameType getForcedGameType() {
        return null;
    }

    public ResourceManager getResourceManager() {
        return this.resources.resourceManager;
    }

    public boolean isCurrentlySaving() {
        return this.isSaving;
    }

    public boolean isTimeProfilerRunning() {
        return this.debugCommandProfilerDelayStart || this.debugCommandProfiler != null;
    }

    public void startTimeProfiler() {
        this.debugCommandProfilerDelayStart = true;
    }

    public ProfileResults stopTimeProfiler() {
        if (this.debugCommandProfiler == null) {
            return EmptyProfileResults.EMPTY;
        }
        ProfileResults methodprofilerresults = this.debugCommandProfiler.stop(Util.getNanos(), this.tickCount);
        this.debugCommandProfiler = null;
        return methodprofilerresults;
    }

    public int getMaxChainedNeighborUpdates() {
        return 1000000;
    }

    public void logChatMessage(Component ichatbasecomponent, ChatType.Bound chatmessagetype_a, @Nullable String s) {
        String s1 = chatmessagetype_a.decorate(ichatbasecomponent).getString();
        if (s != null) {
            LOGGER.info("[{}] {}", (Object)s, (Object)s1);
        } else {
            LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator getChatDecorator() {
        return ChatDecorator.PLAIN;
    }

    public boolean logIPs() {
        return true;
    }

    public void handleCustomClickAction(ResourceLocation minecraftkey, Optional<Tag> optional, ServerPlayer player) {
        LOGGER.debug("Received custom click action {} with payload {}", (Object)minecraftkey, optional.orElse(null));
        CraftEventFactory.callPlayerCustomClickEvent(minecraftkey, optional, player);
    }

    public LevelLoadListener getLevelLoadListener() {
        return this.levelLoadListener;
    }

    public boolean setAutoSave(boolean flag) {
        boolean flag1 = false;
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (worldserver == null || worldserver.noSave != flag) continue;
            worldserver.noSave = !flag;
            flag1 = true;
        }
        return flag1;
    }

    public boolean isAutoSave() {
        for (ServerLevel worldserver : this.getAllLevels()) {
            if (worldserver == null || worldserver.noSave) continue;
            return true;
        }
        return false;
    }

    public void onGameRuleChanged(String s, GameRules.Value<?> gamerules_gamerulevalue) {
        this.notificationManager().onGameRuleChanged(s, gamerules_gamerulevalue);
    }

    public boolean acceptsTransfers() {
        return false;
    }

    private void storeChunkIoError(CrashReport crashreport, ChunkPos chunkcoordintpair, RegionStorageInfo regionstorageinfo) {
        Util.ioPool().execute(() -> {
            try {
                Path path = this.getFile("debug");
                FileUtil.createDirectoriesSafe(path);
                String s = FileUtil.sanitizeName(regionstorageinfo.level());
                Path path1 = path.resolve("chunk-" + s + "-" + Util.getFilenameFormattedDateTime() + "-server.txt");
                FileStore filestore = java.nio.file.Files.getFileStore(path);
                long i = filestore.getUsableSpace();
                if (i < 8192L) {
                    LOGGER.warn("Not storing chunk IO report due to low space on drive {}", (Object)filestore.name());
                    return;
                }
                CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk Info");
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.setDetail("Level", regionstorageinfo::level);
                crashreportsystemdetails.setDetail("Dimension", () -> regionstorageinfo.dimension().location().toString());
                Objects.requireNonNull(regionstorageinfo);
                crashreportsystemdetails.setDetail("Storage", regionstorageinfo::type);
                Objects.requireNonNull(chunkcoordintpair);
                crashreportsystemdetails.setDetail("Position", chunkcoordintpair::toString);
                crashreport.saveToFile(path1, ReportType.CHUNK_IO_ERROR);
                LOGGER.info("Saved details to {}", (Object)crashreport.getSaveFile());
            }
            catch (Exception exception) {
                LOGGER.warn("Failed to store chunk IO exception", (Throwable)exception);
            }
        });
    }

    @Override
    public void reportChunkLoadFailure(Throwable throwable, RegionStorageInfo regionstorageinfo, ChunkPos chunkcoordintpair) {
        LOGGER.error("Failed to load chunk {},{}", new Object[]{chunkcoordintpair.x, chunkcoordintpair.z, throwable});
        this.suppressedExceptions.addEntry("chunk/load", throwable);
        this.storeChunkIoError(CrashReport.forThrowable(throwable, "Chunk load failure"), chunkcoordintpair, regionstorageinfo);
    }

    @Override
    public void reportChunkSaveFailure(Throwable throwable, RegionStorageInfo regionstorageinfo, ChunkPos chunkcoordintpair) {
        LOGGER.error("Failed to save chunk {},{}", new Object[]{chunkcoordintpair.x, chunkcoordintpair.z, throwable});
        this.suppressedExceptions.addEntry("chunk/save", throwable);
        this.storeChunkIoError(CrashReport.forThrowable(throwable, "Chunk save failure"), chunkcoordintpair, regionstorageinfo);
    }

    public void reportPacketHandlingException(Throwable throwable, PacketType<?> packettype) {
        this.suppressedExceptions.addEntry("packet/" + packettype.toString(), throwable);
    }

    public PotionBrewing potionBrewing() {
        return this.potionBrewing;
    }

    public FuelValues fuelValues() {
        return this.fuelValues;
    }

    public ServerLinks serverLinks() {
        return ServerLinks.EMPTY;
    }

    protected int pauseWhenEmptySeconds() {
        return 0;
    }

    public PacketProcessor packetProcessor() {
        return this.packetProcessor;
    }

    public ServerDebugSubscribers debugSubscribers() {
        return this.debugSubscribers;
    }

    public record ReloadableResources(CloseableResourceManager resourceManager, ReloadableServerResources managers) implements AutoCloseable
    {
        @Override
        public void close() {
            this.resourceManager.close();
        }
    }

    private static class TimeProfiler {
        final long startNanos;
        final int startTick;

        TimeProfiler(long i, int j) {
            this.startNanos = i;
            this.startTick = j;
        }

        ProfileResults stop(final long i, final int j) {
            return new ProfileResults(){

                @Override
                public List<ResultField> getTimes(String s) {
                    return Collections.emptyList();
                }

                @Override
                public boolean saveResults(Path path) {
                    return false;
                }

                @Override
                public long getStartTimeNano() {
                    return startNanos;
                }

                @Override
                public int getStartTimeTicks() {
                    return startTick;
                }

                @Override
                public long getEndTimeNano() {
                    return i;
                }

                @Override
                public int getEndTimeTicks() {
                    return j;
                }

                @Override
                public String getProfilerResults() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID id, String url, String hash, boolean isRequired, @Nullable Component prompt) {
    }
}

