/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class RideCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_RIDING = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.ride.not_riding", var0));
    private static final Dynamic2CommandExceptionType ERROR_ALREADY_RIDING = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.ride.already_riding", var0, var1));
    private static final Dynamic2CommandExceptionType ERROR_MOUNT_FAILED = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.ride.mount.failure.generic", var0, var1));
    private static final SimpleCommandExceptionType ERROR_MOUNTING_PLAYER = new SimpleCommandExceptionType((Message)Component.translatable("commands.ride.mount.failure.cant_ride_players"));
    private static final SimpleCommandExceptionType ERROR_MOUNTING_LOOP = new SimpleCommandExceptionType((Message)Component.translatable("commands.ride.mount.failure.loop"));
    private static final SimpleCommandExceptionType ERROR_WRONG_DIMENSION = new SimpleCommandExceptionType((Message)Component.translatable("commands.ride.mount.failure.wrong_dimension"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ride").requires(Commands.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument("target", EntityArgument.entity()).then(Commands.literal("mount").then(Commands.argument("vehicle", EntityArgument.entity()).executes(var0 -> RideCommand.mount((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "vehicle")))))).then(Commands.literal("dismount").executes(var0 -> RideCommand.dismount((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target")))))));
    }

    private static int mount(CommandSourceStack var0, Entity var12, Entity var2) throws CommandSyntaxException {
        Entity var3 = var12.getVehicle();
        if (var3 != null) {
            throw ERROR_ALREADY_RIDING.create((Object)var12.getDisplayName(), (Object)var3.getDisplayName());
        }
        if (var2.getType() == EntityType.PLAYER) {
            throw ERROR_MOUNTING_PLAYER.create();
        }
        if (var12.getSelfAndPassengers().anyMatch(var1 -> var1 == var2)) {
            throw ERROR_MOUNTING_LOOP.create();
        }
        if (var12.level() != var2.level()) {
            throw ERROR_WRONG_DIMENSION.create();
        }
        if (!var12.startRiding(var2, true, true)) {
            throw ERROR_MOUNT_FAILED.create((Object)var12.getDisplayName(), (Object)var2.getDisplayName());
        }
        var0.sendSuccess(() -> Component.translatable("commands.ride.mount.success", var12.getDisplayName(), var2.getDisplayName()), true);
        return 1;
    }

    private static int dismount(CommandSourceStack var0, Entity var1) throws CommandSyntaxException {
        Entity var2 = var1.getVehicle();
        if (var2 == null) {
            throw ERROR_NOT_RIDING.create((Object)var1.getDisplayName());
        }
        var1.stopRiding();
        var0.sendSuccess(() -> Component.translatable("commands.ride.dismount.success", var1.getDisplayName(), var2.getDisplayName()), true);
        return 1;
    }
}

