/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;

public class TeamMsgCommand {
    private static final Style SUGGEST_STYLE = Style.EMPTY.withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.type.team.hover"))).withClickEvent(new ClickEvent.SuggestCommand("/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)Component.translatable("commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        LiteralCommandNode<CommandSourceStack> var1 = var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("teammsg").then(Commands.argument("message", MessageArgument.message()).executes(var0 -> {
            CommandSourceStack var1 = (CommandSourceStack)var0.getSource();
            Entity var22 = var1.getEntityOrException();
            PlayerTeam var3 = var22.getTeam();
            if (var3 == null) {
                throw ERROR_NOT_ON_TEAM.create();
            }
            List<ServerPlayer> var42 = var1.getServer().getPlayerList().getPlayers().stream().filter(var2 -> var2 == var22 || var2.getTeam() == var3).toList();
            if (!var42.isEmpty()) {
                MessageArgument.resolveChatMessage((CommandContext<CommandSourceStack>)var0, "message", var4 -> TeamMsgCommand.sendMessage(var1, var22, var3, var42, var4));
            }
            return var42.size();
        }))));
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("tm").redirect(var1)));
    }

    private static void sendMessage(CommandSourceStack var0, Entity var1, PlayerTeam var2, List<ServerPlayer> var3, PlayerChatMessage var4) {
        MutableComponent var5 = var2.getFormattedDisplayName().withStyle(SUGGEST_STYLE);
        ChatType.Bound var6 = ChatType.bind(ChatType.TEAM_MSG_COMMAND_INCOMING, var0).withTargetName(var5);
        ChatType.Bound var7 = ChatType.bind(ChatType.TEAM_MSG_COMMAND_OUTGOING, var0).withTargetName(var5);
        OutgoingChatMessage var8 = OutgoingChatMessage.create(var4);
        boolean var9 = false;
        for (ServerPlayer var11 : var3) {
            ChatType.Bound var12 = var11 == var1 ? var7 : var6;
            boolean var13 = var0.shouldFilterMessageTo(var11);
            var11.sendChatMessage(var8, var13, var12);
            var9 |= var13 && var4.isFullyFiltered();
        }
        if (var9) {
            var0.sendSystemMessage(PlayerList.CHAT_FILTERED_FULL);
        }
    }
}

