/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;

public interface OutgoingRpcMethod<Params, Result> {
    public static final String NOTIFICATION_PREFIX = "notification/";

    public MethodInfo info();

    public Attributes attributes();

    @Nullable
    default public JsonElement encodeParams(Params var0) {
        return null;
    }

    @Nullable
    default public Result decodeResult(JsonElement var0) {
        return null;
    }

    public static OutgoingRpcMethodBuilder<ParmeterlessNotification> notification() {
        return new OutgoingRpcMethodBuilder<ParmeterlessNotification>((var0, var1) -> {
            if (var0.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var0.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new ParmeterlessNotification(var0, var1);
        });
    }

    public static <Params> OutgoingRpcMethodBuilder<Notification<Params>> notification(Codec<Params> var0) {
        return new OutgoingRpcMethodBuilder<Notification<Params>>((var1, var2) -> {
            if (var1.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (var1.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new Notification(var1, var2, var0);
        });
    }

    public static <Result> OutgoingRpcMethodBuilder<ParameterlessMethod<Result>> request(Codec<Result> var0) {
        return new OutgoingRpcMethodBuilder<ParameterlessMethod<Result>>((var1, var2) -> {
            if (var1.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if (var1.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod(var1, var2, var0);
        });
    }

    public static <Params, Result> OutgoingRpcMethodBuilder<Method<Params, Result>> request(Codec<Params> var0, Codec<Result> var1) {
        return new OutgoingRpcMethodBuilder<Method<Params, Result>>((var2, var3) -> {
            if (var2.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if (var2.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new Method(var2, var3, var0, var1);
        });
    }

    public static class OutgoingRpcMethodBuilder<T extends OutgoingRpcMethod<?, ?>> {
        public static final Attributes DEFAULT_ATTRIBUTES = new Attributes(true);
        private final Factory<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;

        public OutgoingRpcMethodBuilder(Factory<T> var0) {
            this.method = var0;
        }

        public OutgoingRpcMethodBuilder<T> description(String var0) {
            this.description = var0;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> response(ResultInfo var0) {
            this.resultInfo = var0;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> param(ParamInfo var0) {
            this.paramInfo = var0;
            return this;
        }

        private T build() {
            MethodInfo var0 = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create(var0, DEFAULT_ATTRIBUTES);
        }

        public Holder.Reference<T> register(String var0) {
            return this.register(ResourceLocation.withDefaultNamespace(OutgoingRpcMethod.NOTIFICATION_PREFIX + var0));
        }

        private Holder.Reference<T> register(ResourceLocation var0) {
            return Registry.registerForHolder(BuiltInRegistries.OUTGOING_RPC_METHOD, var0, this.build());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends OutgoingRpcMethod<?, ?>> {
        public T create(MethodInfo var1, Attributes var2);
    }

    public record Method<Params, Result>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec) implements OutgoingRpcMethod<Params, Result>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params var0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }

        @Override
        public Result decodeResult(JsonElement var0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record Attributes(boolean discoverable) {
    }

    public record ParameterlessMethod<Result>(MethodInfo info, Attributes attributes, Codec<Result> resultCodec) implements OutgoingRpcMethod<Void, Result>
    {
        @Override
        public Result decodeResult(JsonElement var0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow();
        }
    }

    public record Notification<Params>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec) implements OutgoingRpcMethod<Params, Void>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params var0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, var0).getOrThrow();
        }
    }

    public record ParmeterlessNotification(MethodInfo info, Attributes attributes) implements OutgoingRpcMethod<Void, Void>
    {
    }
}

