/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class FilePackResources
extends AbstractPackResources {
    static final Logger LOGGER = LogUtils.getLogger();
    private final SharedZipFileAccess zipFileAccess;
    private final String prefix;

    FilePackResources(PackLocationInfo var0, SharedZipFileAccess var1, String var2) {
        super(var0);
        this.zipFileAccess = var1;
        this.prefix = var2;
    }

    private static String getPathFromLocation(PackType var0, ResourceLocation var1) {
        return String.format(Locale.ROOT, "%s/%s/%s", var0.getDirectory(), var1.getNamespace(), var1.getPath());
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var0) {
        return this.getResource(String.join((CharSequence)"/", var0));
    }

    @Override
    public IoSupplier<InputStream> getResource(PackType var0, ResourceLocation var1) {
        return this.getResource(FilePackResources.getPathFromLocation(var0, var1));
    }

    private String addPrefix(String var0) {
        if (this.prefix.isEmpty()) {
            return var0;
        }
        return this.prefix + "/" + var0;
    }

    @Nullable
    private IoSupplier<InputStream> getResource(String var0) {
        ZipFile var1 = this.zipFileAccess.getOrCreateZipFile();
        if (var1 == null) {
            return null;
        }
        ZipEntry var2 = var1.getEntry(this.addPrefix(var0));
        if (var2 == null) {
            return null;
        }
        return IoSupplier.create(var1, var2);
    }

    @Override
    public Set<String> getNamespaces(PackType var0) {
        ZipFile var1 = this.zipFileAccess.getOrCreateZipFile();
        if (var1 == null) {
            return Set.of();
        }
        Enumeration<? extends ZipEntry> var2 = var1.entries();
        HashSet var3 = Sets.newHashSet();
        String var4 = this.addPrefix(var0.getDirectory() + "/");
        while (var2.hasMoreElements()) {
            ZipEntry var5 = var2.nextElement();
            String var6 = var5.getName();
            String var7 = FilePackResources.extractNamespace(var4, var6);
            if (var7.isEmpty()) continue;
            if (ResourceLocation.isValidNamespace(var7)) {
                var3.add(var7);
                continue;
            }
            LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)var7, (Object)this.zipFileAccess.file);
        }
        return var3;
    }

    @VisibleForTesting
    public static String extractNamespace(String var0, String var1) {
        if (!var1.startsWith(var0)) {
            return "";
        }
        int var2 = var0.length();
        int var3 = var1.indexOf(47, var2);
        if (var3 == -1) {
            return var1.substring(var2);
        }
        return var1.substring(var2, var3);
    }

    @Override
    public void close() {
        this.zipFileAccess.close();
    }

    @Override
    public void listResources(PackType var0, String var1, String var2, PackResources.ResourceOutput var3) {
        ZipFile var4 = this.zipFileAccess.getOrCreateZipFile();
        if (var4 == null) {
            return;
        }
        Enumeration<? extends ZipEntry> var5 = var4.entries();
        String var6 = this.addPrefix(var0.getDirectory() + "/" + var1 + "/");
        String var7 = var6 + var2 + "/";
        while (var5.hasMoreElements()) {
            String var9;
            ZipEntry var8 = var5.nextElement();
            if (var8.isDirectory() || !(var9 = var8.getName()).startsWith(var7)) continue;
            String var10 = var9.substring(var6.length());
            ResourceLocation var11 = ResourceLocation.tryBuild(var1, var10);
            if (var11 != null) {
                var3.accept(var11, IoSupplier.create(var4, var8));
                continue;
            }
            LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)var1, (Object)var10);
        }
    }

    static class SharedZipFileAccess
    implements AutoCloseable {
        final File file;
        @Nullable
        private ZipFile zipFile;
        private boolean failedToLoad;

        SharedZipFileAccess(File var0) {
            this.file = var0;
        }

        @Nullable
        ZipFile getOrCreateZipFile() {
            if (this.failedToLoad) {
                return null;
            }
            if (this.zipFile == null) {
                try {
                    this.zipFile = new ZipFile(this.file);
                }
                catch (IOException var0) {
                    LOGGER.error("Failed to open pack {}", (Object)this.file, (Object)var0);
                    this.failedToLoad = true;
                    return null;
                }
            }
            return this.zipFile;
        }

        @Override
        public void close() {
            if (this.zipFile != null) {
                IOUtils.closeQuietly((Closeable)this.zipFile);
                this.zipFile = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    public static class FileResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final File content;

        public FileResourcesSupplier(Path var0) {
            this(var0.toFile());
        }

        public FileResourcesSupplier(File var0) {
            this.content = var0;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo var0) {
            SharedZipFileAccess var1 = new SharedZipFileAccess(this.content);
            return new FilePackResources(var0, var1, "");
        }

        @Override
        public PackResources openFull(PackLocationInfo var0, Pack.Metadata var1) {
            SharedZipFileAccess var2 = new SharedZipFileAccess(this.content);
            FilePackResources var3 = new FilePackResources(var0, var2, "");
            List<String> var4 = var1.overlays();
            if (var4.isEmpty()) {
                return var3;
            }
            ArrayList<PackResources> var5 = new ArrayList<PackResources>(var4.size());
            for (String var7 : var4) {
                var5.add(new FilePackResources(var0, var2, var7));
            }
            return new CompositePackResources(var3, var5);
        }
    }
}

