/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class SleepStatus {
    private int activePlayers;
    private int sleepingPlayers;

    public boolean areEnoughSleeping(int i) {
        return this.sleepingPlayers >= this.sleepersNeeded(i);
    }

    public boolean areEnoughDeepSleeping(int i, List<ServerPlayer> list) {
        int j = (int)list.stream().filter(eh -> eh.isSleepingLongEnough() || eh.fauxSleeping).count();
        boolean anyDeepSleep = list.stream().anyMatch(Player::isSleepingLongEnough);
        return anyDeepSleep && j >= this.sleepersNeeded(i);
    }

    public int sleepersNeeded(int i) {
        return Math.max(1, Mth.ceil((float)(this.activePlayers * i) / 100.0f));
    }

    public void removeAllSleepers() {
        this.sleepingPlayers = 0;
    }

    public int amountSleeping() {
        return this.sleepingPlayers;
    }

    public boolean update(List<ServerPlayer> list) {
        int i = this.activePlayers;
        int j = this.sleepingPlayers;
        this.activePlayers = 0;
        this.sleepingPlayers = 0;
        boolean anySleep = false;
        for (ServerPlayer entityplayer : list) {
            if (entityplayer.isSpectator()) continue;
            ++this.activePlayers;
            if (entityplayer.isSleeping() || entityplayer.fauxSleeping) {
                ++this.sleepingPlayers;
            }
            if (!entityplayer.isSleeping()) continue;
            anySleep = true;
        }
        return !(!anySleep || j <= 0 && this.sleepingPlayers <= 0 || i == this.activePlayers && j == this.sleepingPlayers);
    }
}

