/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public abstract class AbstractPoiSectionFix
extends DataFix {
    private final String name;

    public AbstractPoiSectionFix(Schema var0, String var1) {
        super(var0, false);
        this.name = var1;
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = DSL.named((String)References.POI_CHUNK.typeName(), (Type)DSL.remainderType());
        if (!Objects.equals(var0, this.getInputSchema().getType(References.POI_CHUNK))) {
            throw new IllegalStateException("Poi type is not what was expected.");
        }
        return this.fixTypeEverywhere(this.name, var0, var02 -> var0 -> var0.mapSecond(this::cap));
    }

    private <T> Dynamic<T> cap(Dynamic<T> var0) {
        return var0.update("Sections", var02 -> var02.updateMapValues(var0 -> var0.mapSecond(this::processSection)));
    }

    private Dynamic<?> processSection(Dynamic<?> var0) {
        return var0.update("Records", this::processSectionRecords);
    }

    private <T> Dynamic<T> processSectionRecords(Dynamic<T> var0) {
        return (Dynamic)DataFixUtils.orElse(var0.asStreamOpt().result().map(var1 -> var0.createList(this.processRecords((Stream)var1))), var0);
    }

    protected abstract <T> Stream<Dynamic<T>> processRecords(Stream<Dynamic<T>> var1);
}

