/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class MemoryExpiryDataFix
extends NamedEntityFix {
    public MemoryExpiryDataFix(Schema var0, String var1) {
        super(var0, false, "Memory expiry data fix (" + var1 + ")", References.ENTITY, var1);
    }

    @Override
    protected Typed<?> fix(Typed<?> var0) {
        return var0.update(DSL.remainderFinder(), this::fixTag);
    }

    public Dynamic<?> fixTag(Dynamic<?> var0) {
        return var0.update("Brain", this::updateBrain);
    }

    private Dynamic<?> updateBrain(Dynamic<?> var0) {
        return var0.update("memories", this::updateMemories);
    }

    private Dynamic<?> updateMemories(Dynamic<?> var0) {
        return var0.updateMapValues(this::updateMemoryEntry);
    }

    private Pair<Dynamic<?>, Dynamic<?>> updateMemoryEntry(Pair<Dynamic<?>, Dynamic<?>> var0) {
        return var0.mapSecond(this::wrapMemoryValue);
    }

    private Dynamic<?> wrapMemoryValue(Dynamic<?> var0) {
        return var0.createMap((Map)ImmutableMap.of((Object)var0.createString("value"), var0));
    }
}

