/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public final class MobEffectUtil {
    public static Component formatDuration(MobEffectInstance mobeffect, float f, float f1) {
        if (mobeffect.isInfiniteDuration()) {
            return Component.translatable("effect.duration.infinite");
        }
        int i = Mth.floor((float)mobeffect.getDuration() * f);
        return Component.literal(StringUtil.formatTickDuration(i, f1));
    }

    public static boolean hasDigSpeed(LivingEntity entityliving) {
        return entityliving.hasEffect(MobEffects.HASTE) || entityliving.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public static int getDigSpeedAmplification(LivingEntity entityliving) {
        int i = 0;
        int j = 0;
        if (entityliving.hasEffect(MobEffects.HASTE)) {
            i = entityliving.getEffect(MobEffects.HASTE).getAmplifier();
        }
        if (entityliving.hasEffect(MobEffects.CONDUIT_POWER)) {
            j = entityliving.getEffect(MobEffects.CONDUIT_POWER).getAmplifier();
        }
        return Math.max(i, j);
    }

    public static boolean hasWaterBreathing(LivingEntity entityliving) {
        return entityliving.hasEffect(MobEffects.WATER_BREATHING) || entityliving.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public static List<ServerPlayer> addEffectToPlayersAround(ServerLevel worldserver, @Nullable Entity entity, Vec3 vec3d, double d0, MobEffectInstance mobeffect, int i) {
        return MobEffectUtil.addEffectToPlayersAround(worldserver, entity, vec3d, d0, mobeffect, i, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public static List<ServerPlayer> addEffectToPlayersAround(ServerLevel worldserver, @Nullable Entity entity, Vec3 vec3d, double d0, MobEffectInstance mobeffect, int i, EntityPotionEffectEvent.Cause cause) {
        Holder<MobEffect> holder = mobeffect.getEffect();
        List<ServerPlayer> list = worldserver.getPlayers(entityplayer -> !(!entityplayer.gameMode.isSurvival() || entity != null && entity.isAlliedTo((Entity)entityplayer) || !vec3d.closerThan(entityplayer.position(), d0) || entityplayer.hasEffect(holder) && entityplayer.getEffect(holder).getAmplifier() >= mobeffect.getAmplifier() && !entityplayer.getEffect(holder).endsWithin(i - 1)));
        list.forEach(entityplayer -> entityplayer.addEffect(new MobEffectInstance(mobeffect), entity, cause));
        return list;
    }
}

