/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.waypoints.ServerWaypointManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.ElytraAnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.DeathProtection;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R6.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R6.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R6.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R6.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R6.inventory.CraftItemStack;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;

public abstract class LivingEntity
extends Entity
implements Attackable,
WaypointTransmitter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_ACTIVE_EFFECTS = "active_effects";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_SLEEPING_POS = "sleeping_pos";
    public static final String TAG_EQUIPMENT = "equipment";
    public static final String TAG_BRAIN = "Brain";
    public static final String TAG_FALL_FLYING = "FallFlying";
    public static final String TAG_HURT_TIME = "HurtTime";
    public static final String TAG_DEATH_TIME = "DeathTime";
    public static final String TAG_HURT_BY_TIMESTAMP = "HurtByTimestamp";
    public static final String TAG_HEALTH = "Health";
    private static final ResourceLocation SPEED_MODIFIER_POWDER_SNOW_ID = ResourceLocation.withDefaultNamespace("powder_snow");
    private static final ResourceLocation SPRINTING_MODIFIER_ID = ResourceLocation.withDefaultNamespace("sprinting");
    private static final AttributeModifier SPEED_MODIFIER_SPRINTING = new AttributeModifier(SPRINTING_MODIFIER_ID, 0.3f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final int EQUIPMENT_SLOT_OFFSET = 98;
    public static final int ARMOR_SLOT_OFFSET = 100;
    public static final int BODY_ARMOR_OFFSET = 105;
    public static final int SADDLE_OFFSET = 106;
    public static final int SWING_DURATION = 6;
    public static final int PLAYER_HURT_EXPERIENCE_TIME = 100;
    private static final int DAMAGE_SOURCE_TIMEOUT = 40;
    public static final double MIN_MOVEMENT_DISTANCE = 0.003;
    public static final double DEFAULT_BASE_GRAVITY = 0.08;
    public static final int DEATH_DURATION = 20;
    protected static final float INPUT_FRICTION = 0.98f;
    private static final int TICKS_PER_ELYTRA_FREE_FALL_EVENT = 10;
    private static final int FREE_FALL_EVENTS_PER_ELYTRA_BREAK = 2;
    public static final float BASE_JUMP_POWER = 0.42f;
    private static final double MAX_LINE_OF_SIGHT_TEST_RANGE = 128.0;
    protected static final int LIVING_ENTITY_FLAG_IS_USING = 1;
    protected static final int LIVING_ENTITY_FLAG_OFF_HAND = 2;
    public static final int LIVING_ENTITY_FLAG_SPIN_ATTACK = 4;
    protected static final EntityDataAccessor<Byte> DATA_LIVING_ENTITY_FLAGS = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Float> DATA_HEALTH_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<List<ParticleOptions>> DATA_EFFECT_PARTICLES = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.PARTICLES);
    private static final EntityDataAccessor<Boolean> DATA_EFFECT_AMBIENCE_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_ARROW_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_STINGER_COUNT_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockPos>> SLEEPING_POS_ID = SynchedEntityData.defineId(LivingEntity.class, EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final int PARTICLE_FREQUENCY_WHEN_INVISIBLE = 15;
    protected static final EntityDimensions SLEEPING_DIMENSIONS = EntityDimensions.fixed(0.2f, 0.2f).withEyeHeight(0.2f);
    public static final float EXTRA_RENDER_CULLING_SIZE_WITH_BIG_HAT = 0.5f;
    public static final float DEFAULT_BABY_SCALE = 0.5f;
    public static final Predicate<LivingEntity> PLAYER_NOT_WEARING_DISGUISE_ITEM = entityliving -> {
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            ItemStack itemstack = entityhuman.getItemBySlot(EquipmentSlot.HEAD);
            return !itemstack.is(ItemTags.GAZE_DISGUISE_EQUIPMENT);
        }
        return true;
    };
    private static final Dynamic<?> EMPTY_BRAIN = new Dynamic((DynamicOps)JavaOps.INSTANCE, Map.of("memories", Map.of()));
    private final AttributeMap attributes;
    public CombatTracker combatTracker = new CombatTracker(this);
    public final Map<Holder<MobEffect>, MobEffectInstance> activeEffects = Maps.newHashMap();
    private final Map<EquipmentSlot, ItemStack> lastEquipmentItems = Util.makeEnumMap(EquipmentSlot.class, enumitemslot -> ItemStack.EMPTY);
    public boolean swinging;
    private boolean discardFriction = false;
    public InteractionHand swingingArm;
    public int swingTime;
    public int removeArrowTime;
    public int removeStingerTime;
    public int hurtTime;
    public int hurtDuration;
    public int deathTime;
    public float oAttackAnim;
    public float attackAnim;
    protected int attackStrengthTicker;
    public final WalkAnimationState walkAnimation = new WalkAnimationState();
    public int invulnerableDuration = 20;
    public float yBodyRot;
    public float yBodyRotO;
    public float yHeadRot;
    public float yHeadRotO;
    public final ElytraAnimationState elytraAnimationState = new ElytraAnimationState(this);
    @Nullable
    public EntityReference<Player> lastHurtByPlayer;
    protected int lastHurtByPlayerMemoryTime;
    protected boolean dead;
    protected int noActionTime;
    public float lastHurt;
    protected boolean jumping;
    public float xxa;
    public float yya;
    public float zza;
    protected InterpolationHandler interpolation = new InterpolationHandler(this);
    protected double lerpYHeadRot;
    protected int lerpHeadSteps;
    public boolean effectsDirty = true;
    @Nullable
    public EntityReference<LivingEntity> lastHurtByMob;
    public int lastHurtByMobTimestamp;
    @Nullable
    private LivingEntity lastHurtMob;
    private int lastHurtMobTimestamp;
    private float speed;
    private int noJumpDelay;
    private float absorptionAmount;
    protected ItemStack useItem;
    public int useItemRemaining;
    protected int fallFlyTicks;
    private BlockPos lastPos;
    private Optional<BlockPos> lastClimbablePos;
    @Nullable
    private DamageSource lastDamageSource;
    private long lastDamageStamp;
    protected int autoSpinAttackTicks;
    protected float autoSpinAttackDmg;
    @Nullable
    protected ItemStack autoSpinAttackItemStack;
    private float swimAmount;
    private float swimAmountO;
    protected Brain<?> brain;
    protected boolean skipDropExperience;
    private final EnumMap<EquipmentSlot, Reference2ObjectMap<Enchantment, Set<EnchantmentLocationBasedEffect>>> activeLocationDependentEnchantments;
    public final EntityEquipment equipment;
    private Waypoint.Icon locatorBarIcon;
    public int expToDrop;
    public ArrayList<org.bukkit.inventory.ItemStack> drops = new ArrayList();
    public final CraftAttributeMap craftAttributes;
    public boolean collides = true;
    public Set<UUID> collidableExemptions = new HashSet<UUID>();
    public boolean bukkitPickUpLoot;
    private boolean isTickingEffects = false;
    private List<ProcessableEffect> effectsToProcess = Lists.newArrayList();

    @Override
    public float getBukkitYaw() {
        return this.getYHeadRot();
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        ++this.noActionTime;
    }

    protected LivingEntity(EntityType<? extends LivingEntity> entitytypes, Level world) {
        super(entitytypes, world);
        this.useItem = ItemStack.EMPTY;
        this.lastClimbablePos = Optional.empty();
        this.activeLocationDependentEnchantments = new EnumMap(EquipmentSlot.class);
        this.locatorBarIcon = new Waypoint.Icon();
        this.attributes = new AttributeMap(DefaultAttributes.getSupplier(entitytypes));
        this.craftAttributes = new CraftAttributeMap(this.attributes);
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf((float)this.getAttribute(Attributes.MAX_HEALTH).getValue()));
        this.equipment = this.createEquipment();
        this.blocksBuilding = true;
        this.reapplyPosition();
        this.setYRot((float)(Math.random() * 6.2831854820251465));
        this.yHeadRot = this.getYRot();
        this.brain = this.makeBrain(EMPTY_BRAIN);
    }

    @Override
    @Nullable
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Contract(pure=true)
    protected EntityEquipment createEquipment() {
        return new EntityEquipment();
    }

    public Brain<?> getBrain() {
        return this.brain;
    }

    protected Brain.Provider<?> brainProvider() {
        return Brain.provider(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return this.brainProvider().makeBrain(dynamic);
    }

    @Override
    public void kill(ServerLevel worldserver) {
        this.hurtServer(worldserver, this.damageSources().genericKill(), Float.MAX_VALUE);
    }

    public boolean canAttackType(EntityType<?> entitytypes) {
        return true;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_LIVING_ENTITY_FLAGS, (byte)0);
        datawatcher_a.define(DATA_EFFECT_PARTICLES, List.of());
        datawatcher_a.define(DATA_EFFECT_AMBIENCE_ID, false);
        datawatcher_a.define(DATA_ARROW_COUNT_ID, 0);
        datawatcher_a.define(DATA_STINGER_COUNT_ID, 0);
        datawatcher_a.define(DATA_HEALTH_ID, Float.valueOf(1.0f));
        datawatcher_a.define(SLEEPING_POS_ID, Optional.empty());
    }

    public static AttributeSupplier.Builder createLivingAttributes() {
        return AttributeSupplier.builder().add(Attributes.MAX_HEALTH).add(Attributes.KNOCKBACK_RESISTANCE).add(Attributes.MOVEMENT_SPEED).add(Attributes.ARMOR).add(Attributes.ARMOR_TOUGHNESS).add(Attributes.MAX_ABSORPTION).add(Attributes.STEP_HEIGHT).add(Attributes.SCALE).add(Attributes.GRAVITY).add(Attributes.SAFE_FALL_DISTANCE).add(Attributes.FALL_DAMAGE_MULTIPLIER).add(Attributes.JUMP_STRENGTH).add(Attributes.OXYGEN_BONUS).add(Attributes.BURNING_TIME).add(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE).add(Attributes.WATER_MOVEMENT_EFFICIENCY).add(Attributes.MOVEMENT_EFFICIENCY).add(Attributes.ATTACK_KNOCKBACK).add(Attributes.CAMERA_DISTANCE).add(Attributes.WAYPOINT_TRANSMIT_RANGE);
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
        Level world;
        if (!this.isInWater()) {
            this.updateInWaterStateAndDoWaterCurrentPushing();
        }
        if ((world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (flag && this.fallDistance > 0.0) {
                this.onChangedBlock(worldserver, blockposition);
                double d1 = Math.max(0, Mth.floor(this.calculateFallPower(this.fallDistance)));
                if (d1 > 0.0 && !iblockdata.isAir()) {
                    double d2 = this.getX();
                    double d3 = this.getY();
                    double d4 = this.getZ();
                    BlockPos blockposition1 = this.blockPosition();
                    if (blockposition.getX() != blockposition1.getX() || blockposition.getZ() != blockposition1.getZ()) {
                        double d5 = d2 - (double)blockposition.getX() - 0.5;
                        double d6 = d4 - (double)blockposition.getZ() - 0.5;
                        double d7 = Math.max(Math.abs(d5), Math.abs(d6));
                        d2 = (double)blockposition.getX() + 0.5 + d5 / d7 * 0.5;
                        d4 = (double)blockposition.getZ() + 0.5 + d6 / d7 * 0.5;
                    }
                    double d8 = Math.min((double)0.2f + d1 / 15.0, 2.5);
                    int i = (int)(150.0 * d8);
                    if (this instanceof ServerPlayer) {
                        worldserver.sendParticlesSource((ServerPlayer)this, new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), false, false, d2, d3, d4, i, 0.0, 0.0, 0.0, 0.15f);
                    } else {
                        worldserver.sendParticles(new BlockParticleOption(ParticleTypes.BLOCK, iblockdata), d2, d3, d4, i, 0.0, 0.0, 0.0, 0.15f);
                    }
                }
            }
        }
        super.checkFallDamage(d0, flag, iblockdata, blockposition);
        if (flag) {
            this.lastClimbablePos = Optional.empty();
        }
    }

    public boolean canBreatheUnderwater() {
        return this.getType().is(EntityTypeTags.CAN_BREATHE_UNDER_WATER);
    }

    public float getSwimAmount(float f) {
        return Mth.lerp(f, this.swimAmountO, this.swimAmount);
    }

    public boolean hasLandedInLiquid() {
        return this.getDeltaMovement().y() < (double)1.0E-5f && this.isInLiquid();
    }

    @Override
    public void baseTick() {
        LivingEntity entityliving;
        Level world;
        ServerLevel worldserver;
        this.oAttackAnim = this.attackAnim;
        if (this.firstTick) {
            this.getSleepingPos().ifPresent(this::setPosToBed);
        }
        if ((worldserver = (ServerLevel)this.level()) instanceof ServerLevel) {
            ServerLevel worldserver1 = worldserver;
            EnchantmentHelper.tickEffects(worldserver1, this);
        }
        super.baseTick();
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("livingEntityBaseTick");
        if (this.isAlive() && (world = this.level()) instanceof ServerLevel) {
            double d1;
            double d0;
            worldserver = (ServerLevel)world;
            boolean flag = this instanceof Player;
            if (this.isInWall()) {
                this.hurtServer(worldserver, this.damageSources().inWall(), 1.0f);
            } else if (flag && !worldserver.getWorldBorder().isWithinBounds(this.getBoundingBox()) && (d0 = worldserver.getWorldBorder().getDistanceToBorder(this) + worldserver.getWorldBorder().getSafeZone()) < 0.0 && (d1 = worldserver.getWorldBorder().getDamagePerBlock()) > 0.0) {
                this.hurtServer(worldserver, this.damageSources().outOfBorder(), Math.max(1, Mth.floor(-d0 * d1)));
            }
            if (this.isEyeInFluid(FluidTags.WATER) && !worldserver.getBlockState(BlockPos.containing(this.getX(), this.getEyeY(), this.getZ())).is(Blocks.BUBBLE_COLUMN)) {
                boolean flag1;
                boolean bl = flag1 = !this.canBreatheUnderwater() && !MobEffectUtil.hasWaterBreathing(this) && (!flag || !((Player)this).getAbilities().invulnerable);
                if (flag1) {
                    this.setAirSupply(this.decreaseAirSupply(this.getAirSupply()));
                    if (this.shouldTakeDrowningDamage()) {
                        this.setAirSupply(0);
                        worldserver.broadcastEntityEvent(this, (byte)67);
                        this.hurtServer(worldserver, this.damageSources().drown(), 2.0f);
                    }
                } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                    this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
                }
                if (this.isPassenger() && this.getVehicle() != null && this.getVehicle().dismountsUnderwater()) {
                    this.stopRiding();
                }
            } else if (this.getAirSupply() < this.getMaxAirSupply()) {
                this.setAirSupply(this.increaseAirSupply(this.getAirSupply()));
            }
            BlockPos blockposition = this.blockPosition();
            if (!com.google.common.base.Objects.equal((Object)this.lastPos, (Object)blockposition)) {
                this.lastPos = blockposition;
                this.onChangedBlock(worldserver, blockposition);
            }
        }
        if (this.hurtTime > 0) {
            --this.hurtTime;
        }
        if (this.invulnerableTime > 0 && !(this instanceof ServerPlayer)) {
            --this.invulnerableTime;
        }
        if (this.isDeadOrDying() && this.level().shouldTickDeath(this)) {
            this.tickDeath();
        }
        if (this.lastHurtByPlayerMemoryTime > 0) {
            --this.lastHurtByPlayerMemoryTime;
        } else {
            this.lastHurtByPlayer = null;
        }
        if (this.lastHurtMob != null && !this.lastHurtMob.isAlive()) {
            this.lastHurtMob = null;
        }
        if ((entityliving = this.getLastHurtByMob()) != null) {
            if (!entityliving.isAlive()) {
                this.setLastHurtByMob(null);
            } else if (this.tickCount - this.lastHurtByMobTimestamp > 100) {
                this.setLastHurtByMob(null);
            }
        }
        this.tickEffects();
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot;
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
        gameprofilerfiller.pop();
    }

    protected boolean shouldTakeDrowningDamage() {
        return this.getAirSupply() <= -20;
    }

    @Override
    protected float getBlockSpeedFactor() {
        return Mth.lerp((float)this.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY), super.getBlockSpeedFactor(), 1.0f);
    }

    public float getLuck() {
        return 0.0f;
    }

    protected void removeFrost() {
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
        if (attributemodifiable != null && attributemodifiable.getModifier(SPEED_MODIFIER_POWDER_SNOW_ID) != null) {
            attributemodifiable.removeModifier(SPEED_MODIFIER_POWDER_SNOW_ID);
        }
    }

    protected void tryAddFrost() {
        int i;
        if (!this.getBlockStateOnLegacy().isAir() && (i = this.getTicksFrozen()) > 0) {
            AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributemodifiable == null) {
                return;
            }
            float f = -0.05f * this.getPercentFrozen();
            attributemodifiable.addTransientModifier(new AttributeModifier(SPEED_MODIFIER_POWDER_SNOW_ID, f, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    protected void onChangedBlock(ServerLevel worldserver, BlockPos blockposition) {
        EnchantmentHelper.runLocationChangedEffects(worldserver, this);
    }

    public boolean isBaby() {
        return false;
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.5f : 1.0f;
    }

    public final float getScale() {
        AttributeMap attributemapbase = this.getAttributes();
        return attributemapbase == null ? 1.0f : this.sanitizeScale((float)attributemapbase.getValue(Attributes.SCALE));
    }

    protected float sanitizeScale(float f) {
        return f;
    }

    public boolean isAffectedByFluids() {
        return true;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime >= 20 && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent(this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED, EntityRemoveEvent.Cause.DEATH);
        }
    }

    public boolean shouldDropExperience() {
        return !this.isBaby();
    }

    protected boolean shouldDropLoot(ServerLevel worldserver) {
        return !this.isBaby() && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT);
    }

    protected int decreaseAirSupply(int i) {
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.OXYGEN_BONUS);
        double d0 = attributemodifiable != null ? attributemodifiable.getValue() : 0.0;
        return d0 > 0.0 && this.random.nextDouble() >= 1.0 / (d0 + 1.0) ? i : i - 1;
    }

    protected int increaseAirSupply(int i) {
        return Math.min(i + 4, this.getMaxAirSupply());
    }

    public final int getExperienceReward(ServerLevel worldserver, @Nullable Entity entity) {
        return EnchantmentHelper.processMobExperience(worldserver, entity, this, this.getBaseExperienceReward(worldserver));
    }

    protected int getBaseExperienceReward(ServerLevel worldserver) {
        return 0;
    }

    protected boolean isAlwaysExperienceDropper() {
        return false;
    }

    @Nullable
    public LivingEntity getLastHurtByMob() {
        return EntityReference.getLivingEntity(this.lastHurtByMob, this.level());
    }

    @Nullable
    public Player getLastHurtByPlayer() {
        return EntityReference.getPlayer(this.lastHurtByPlayer, this.level());
    }

    @Override
    public LivingEntity getLastAttacker() {
        return this.getLastHurtByMob();
    }

    public int getLastHurtByMobTimestamp() {
        return this.lastHurtByMobTimestamp;
    }

    public void setLastHurtByPlayer(Player entityhuman, int i) {
        this.setLastHurtByPlayer(EntityReference.of(entityhuman), i);
    }

    public void setLastHurtByPlayer(UUID uuid, int i) {
        this.setLastHurtByPlayer(EntityReference.of(uuid), i);
    }

    private void setLastHurtByPlayer(EntityReference<Player> entityreference, int i) {
        this.lastHurtByPlayer = entityreference;
        this.lastHurtByPlayerMemoryTime = i;
    }

    public void setLastHurtByMob(@Nullable LivingEntity entityliving) {
        this.lastHurtByMob = EntityReference.of(entityliving);
        this.lastHurtByMobTimestamp = this.tickCount;
    }

    @Nullable
    public LivingEntity getLastHurtMob() {
        return this.lastHurtMob;
    }

    public int getLastHurtMobTimestamp() {
        return this.lastHurtMobTimestamp;
    }

    public void setLastHurtMob(Entity entity) {
        this.lastHurtMob = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        this.lastHurtMobTimestamp = this.tickCount;
    }

    public int getNoActionTime() {
        return this.noActionTime;
    }

    public void setNoActionTime(int i) {
        this.noActionTime = i;
    }

    public boolean shouldDiscardFriction() {
        return this.discardFriction;
    }

    public void setDiscardFriction(boolean flag) {
        this.discardFriction = flag;
    }

    protected boolean doesEmitEquipEvent(EquipmentSlot enumitemslot) {
        return true;
    }

    public void onEquipItem(EquipmentSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1) {
        this.onEquipItem(enumitemslot, itemstack, itemstack1, false);
    }

    public void onEquipItem(EquipmentSlot enumitemslot, ItemStack itemstack, ItemStack itemstack1, boolean silent) {
        if (!(this.level().isClientSide() || this.isSpectator() || ItemStack.isSameItemSameComponents(itemstack, itemstack1) || this.firstTick)) {
            Equippable equippable = itemstack1.get(DataComponents.EQUIPPABLE);
            if (!this.isSilent() && equippable != null && enumitemslot == equippable.slot() && !silent) {
                this.level().playSeededSound((Entity)null, this.getX(), this.getY(), this.getZ(), this.getEquipSound(enumitemslot, itemstack1, equippable), this.getSoundSource(), 1.0f, 1.0f, this.random.nextLong());
            }
            if (this.doesEmitEquipEvent(enumitemslot)) {
                this.gameEvent(equippable != null ? GameEvent.EQUIP : GameEvent.UNEQUIP);
            }
        }
    }

    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return equippable.equipSound();
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        Level world;
        if ((entity_removalreason == Entity.RemovalReason.KILLED || entity_removalreason == Entity.RemovalReason.DISCARDED) && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.triggerOnDeathMobEffects(worldserver, entity_removalreason);
        }
        super.remove(entity_removalreason, cause);
        this.brain.clearMemories();
    }

    @Override
    public void onRemoval(Entity.RemovalReason entity_removalreason) {
        super.onRemoval(entity_removalreason);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            worldserver.getWaypointManager().untrackWaypoint(this);
        }
    }

    protected void triggerOnDeathMobEffects(ServerLevel worldserver, Entity.RemovalReason entity_removalreason) {
        for (MobEffectInstance mobeffect : this.getActiveEffects()) {
            mobeffect.onMobRemoved(worldserver, this, entity_removalreason);
        }
        this.removeAllEffects(EntityPotionEffectEvent.Cause.DEATH);
        this.activeEffects.clear();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.putFloat(TAG_HEALTH, this.getHealth());
        valueoutput.putShort(TAG_HURT_TIME, (short)this.hurtTime);
        valueoutput.putInt(TAG_HURT_BY_TIMESTAMP, this.lastHurtByMobTimestamp);
        valueoutput.putShort(TAG_DEATH_TIME, (short)this.deathTime);
        valueoutput.putFloat("AbsorptionAmount", this.getAbsorptionAmount());
        valueoutput.store(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC, this.getAttributes().pack());
        if (!this.activeEffects.isEmpty()) {
            valueoutput.store(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf(), List.copyOf(this.activeEffects.values()));
        }
        valueoutput.putBoolean(TAG_FALL_FLYING, this.isFallFlying());
        this.getSleepingPos().ifPresent(blockposition -> valueoutput.store(TAG_SLEEPING_POS, BlockPos.CODEC, blockposition));
        DataResult dataresult = this.brain.serializeStart(NbtOps.INSTANCE).map(nbtbase -> new Dynamic((DynamicOps)NbtOps.INSTANCE, nbtbase));
        Logger logger = LOGGER;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(dynamic -> valueoutput.store(TAG_BRAIN, Codec.PASSTHROUGH, dynamic));
        if (this.lastHurtByPlayer != null) {
            this.lastHurtByPlayer.store(valueoutput, "last_hurt_by_player");
            valueoutput.putInt("last_hurt_by_player_memory_time", this.lastHurtByPlayerMemoryTime);
        }
        if (this.lastHurtByMob != null) {
            this.lastHurtByMob.store(valueoutput, "last_hurt_by_mob");
            valueoutput.putInt("ticks_since_last_hurt_by_mob", this.tickCount - this.lastHurtByMobTimestamp);
        }
        if (!this.equipment.isEmpty()) {
            valueoutput.store(TAG_EQUIPMENT, EntityEquipment.CODEC, this.equipment);
        }
        if (this.locatorBarIcon.hasData()) {
            valueoutput.store("locator_bar_icon", Waypoint.Icon.CODEC, this.locatorBarIcon);
        }
    }

    @Nullable
    public ItemEntity drop(ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public ItemEntity drop(ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.isEmpty()) {
            return null;
        }
        if (this.level().isClientSide()) {
            this.swing(InteractionHand.MAIN_HAND);
            return null;
        }
        ItemEntity entityitem = this.createItemStackToDrop(itemstack, flag, flag1);
        if (entityitem != null) {
            if (callEvent && this instanceof ServerPlayer) {
                org.bukkit.entity.Player player = (org.bukkit.entity.Player)this.getBukkitEntity();
                Item drop = (Item)entityitem.getBukkitEntity();
                PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    org.bukkit.inventory.ItemStack cur = player.getInventory().getItemInHand();
                    if (flag1 && (cur == null || cur.getAmount() == 0)) {
                        player.getInventory().setItemInHand(drop.getItemStack());
                    } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                        cur.setAmount(cur.getAmount() + 1);
                        player.getInventory().setItemInHand(cur);
                    } else {
                        player.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{drop.getItemStack()});
                    }
                    return null;
                }
            }
            this.level().addFreshEntity(entityitem);
        }
        return entityitem;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.internalSetAbsorptionAmount(valueinput.getFloatOr("AbsorptionAmount", 0.0f));
        if (this.level() != null && !this.level().isClientSide()) {
            Optional<List<AttributeInstance.Packed>> optional = valueinput.read(TAG_ATTRIBUTES, AttributeInstance.Packed.LIST_CODEC);
            AttributeMap attributemapbase = this.getAttributes();
            Objects.requireNonNull(attributemapbase);
            optional.ifPresent(attributemapbase::apply);
        }
        List list = valueinput.read(TAG_ACTIVE_EFFECTS, MobEffectInstance.CODEC.listOf()).orElse(List.of());
        this.activeEffects.clear();
        for (MobEffectInstance mobeffect : list) {
            this.activeEffects.put(mobeffect.getEffect(), mobeffect);
        }
        float maxHealth = valueinput.getFloatOr("Bukkit.MaxHealth", -1.0f);
        if (maxHealth > 0.0f) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(maxHealth);
        }
        this.setHealth(valueinput.getFloatOr(TAG_HEALTH, this.getMaxHealth()));
        this.hurtTime = valueinput.getShortOr(TAG_HURT_TIME, (short)0);
        this.deathTime = valueinput.getShortOr(TAG_DEATH_TIME, (short)0);
        this.lastHurtByMobTimestamp = valueinput.getIntOr(TAG_HURT_BY_TIMESTAMP, 0);
        valueinput.getString("Team").ifPresent(s -> {
            boolean flag;
            Scoreboard scoreboard = this.level().getScoreboard();
            PlayerTeam scoreboardteam = scoreboard.getPlayerTeam((String)s);
            boolean bl = flag = scoreboardteam != null && scoreboard.addPlayerToTeam(this.getStringUUID(), scoreboardteam);
            if (!flag) {
                LOGGER.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", s);
            }
        });
        this.setSharedFlag(7, valueinput.getBooleanOr(TAG_FALL_FLYING, false));
        valueinput.read(TAG_SLEEPING_POS, BlockPos.CODEC).ifPresentOrElse(blockposition -> {
            this.setSleepingPos((BlockPos)blockposition);
            this.entityData.set(DATA_POSE, Pose.SLEEPING);
            if (!this.firstTick) {
                this.setPosToBed((BlockPos)blockposition);
            }
        }, this::clearSleepingPos);
        valueinput.read(TAG_BRAIN, Codec.PASSTHROUGH).ifPresent(dynamic -> {
            this.brain = this.makeBrain((Dynamic<?>)dynamic);
        });
        this.lastHurtByPlayer = EntityReference.read(valueinput, "last_hurt_by_player");
        this.lastHurtByPlayerMemoryTime = valueinput.getIntOr("last_hurt_by_player_memory_time", 0);
        this.lastHurtByMob = EntityReference.read(valueinput, "last_hurt_by_mob");
        this.lastHurtByMobTimestamp = valueinput.getIntOr("ticks_since_last_hurt_by_mob", 0) + this.tickCount;
        this.equipment.setAll(valueinput.read(TAG_EQUIPMENT, EntityEquipment.CODEC).orElseGet(EntityEquipment::new));
        this.locatorBarIcon = valueinput.read("locator_bar_icon", Waypoint.Icon.CODEC).orElseGet(Waypoint.Icon::new);
    }

    protected void tickEffects() {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Iterator<Holder<MobEffect>> iterator = this.activeEffects.keySet().iterator();
            this.isTickingEffects = true;
            try {
                while (iterator.hasNext()) {
                    Holder<MobEffect> holder = iterator.next();
                    MobEffectInstance mobeffect = this.activeEffects.get(holder);
                    if (!mobeffect.tickServer(worldserver, this, () -> this.onEffectUpdated(mobeffect, true, null))) {
                        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect, null, EntityPotionEffectEvent.Cause.EXPIRATION);
                        if (event.isCancelled()) continue;
                        iterator.remove();
                        this.onEffectsRemoved(List.of(mobeffect));
                        continue;
                    }
                    if (mobeffect.getDuration() % 600 != 0) continue;
                    this.onEffectUpdated(mobeffect, false, null);
                }
            }
            catch (ConcurrentModificationException holder) {
                // empty catch block
            }
            this.isTickingEffects = false;
            for (ProcessableEffect e : this.effectsToProcess) {
                if (e.effect != null) {
                    this.addEffect(e.effect, e.cause);
                    continue;
                }
                this.removeEffect(e.type, e.cause);
            }
            this.effectsToProcess.clear();
            if (this.effectsDirty) {
                this.updateInvisibilityStatus();
                this.updateGlowingStatus();
                this.effectsDirty = false;
            }
        } else {
            for (MobEffectInstance mobeffect1 : this.activeEffects.values()) {
                mobeffect1.tickClient();
            }
            List<ParticleOptions> list = this.entityData.get(DATA_EFFECT_PARTICLES);
            if (!list.isEmpty()) {
                int j;
                boolean flag = this.entityData.get(DATA_EFFECT_AMBIENCE_ID);
                int i = this.isInvisible() ? 15 : 4;
                int n = j = flag ? 5 : 1;
                if (this.random.nextInt(i * j) == 0) {
                    this.level().addParticle(Util.getRandom(list, this.random), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
                }
            }
        }
    }

    protected void updateInvisibilityStatus() {
        if (this.activeEffects.isEmpty()) {
            this.removeEffectParticles();
            this.setInvisible(false);
        } else {
            this.setInvisible(this.hasEffect(MobEffects.INVISIBILITY));
            this.updateSynchronizedMobEffectParticles();
        }
    }

    private void updateSynchronizedMobEffectParticles() {
        List<ParticleOptions> list = this.activeEffects.values().stream().filter(MobEffectInstance::isVisible).map(MobEffectInstance::getParticleOptions).toList();
        this.entityData.set(DATA_EFFECT_PARTICLES, list);
        this.entityData.set(DATA_EFFECT_AMBIENCE_ID, LivingEntity.areAllEffectsAmbient(this.activeEffects.values()));
    }

    private void updateGlowingStatus() {
        boolean flag = this.isCurrentlyGlowing();
        if (this.getSharedFlag(6) != flag) {
            this.setSharedFlag(6, flag);
        }
    }

    public double getVisibilityPercent(@Nullable Entity entity) {
        double d0 = 1.0;
        if (this.isDiscrete()) {
            d0 *= 0.8;
        }
        if (this.isInvisible()) {
            float f = this.getArmorCoverPercentage();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d0 *= 0.7 * (double)f;
        }
        if (entity != null) {
            ItemStack itemstack = this.getItemBySlot(EquipmentSlot.HEAD);
            EntityType<?> entitytypes = entity.getType();
            if (entitytypes == EntityType.SKELETON && itemstack.is(Items.SKELETON_SKULL) || entitytypes == EntityType.ZOMBIE && itemstack.is(Items.ZOMBIE_HEAD) || entitytypes == EntityType.PIGLIN && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityType.PIGLIN_BRUTE && itemstack.is(Items.PIGLIN_HEAD) || entitytypes == EntityType.CREEPER && itemstack.is(Items.CREEPER_HEAD)) {
                d0 *= 0.5;
            }
        }
        return d0;
    }

    public boolean canAttack(LivingEntity entityliving) {
        return entityliving instanceof Player && this.level().getDifficulty() == Difficulty.PEACEFUL ? false : entityliving.canBeSeenAsEnemy();
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isInvulnerable() && this.canBeSeenByAnyone();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isSpectator() && this.isAlive();
    }

    public static boolean areAllEffectsAmbient(Collection<MobEffectInstance> collection) {
        for (MobEffectInstance mobeffect : collection) {
            if (!mobeffect.isVisible() || mobeffect.isAmbient()) continue;
            return false;
        }
        return true;
    }

    protected void removeEffectParticles() {
        this.entityData.set(DATA_EFFECT_PARTICLES, List.of());
    }

    public boolean removeAllEffects() {
        return this.removeAllEffects(EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeAllEffects(EntityPotionEffectEvent.Cause cause) {
        if (this.level().isClientSide()) {
            return false;
        }
        if (this.activeEffects.isEmpty()) {
            return false;
        }
        LinkedList<MobEffectInstance> toRemove = new LinkedList<MobEffectInstance>();
        Iterator<MobEffectInstance> iterator = this.activeEffects.values().iterator();
        while (iterator.hasNext()) {
            MobEffectInstance effect = iterator.next();
            EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause, EntityPotionEffectEvent.Action.CLEARED);
            if (event.isCancelled()) continue;
            iterator.remove();
            toRemove.add(effect);
        }
        this.onEffectsRemoved(toRemove);
        return !toRemove.isEmpty();
    }

    public Collection<MobEffectInstance> getActiveEffects() {
        return this.activeEffects.values();
    }

    public Map<Holder<MobEffect>, MobEffectInstance> getActiveEffectsMap() {
        return this.activeEffects;
    }

    public boolean hasEffect(Holder<MobEffect> holder) {
        return this.activeEffects.containsKey(holder);
    }

    @Nullable
    public MobEffectInstance getEffect(Holder<MobEffect> holder) {
        return this.activeEffects.get(holder);
    }

    public float getEffectBlendFactor(Holder<MobEffect> holder, float f) {
        MobEffectInstance mobeffect = this.getEffect(holder);
        return mobeffect != null ? mobeffect.getBlendFactor(this, f) : 0.0f;
    }

    public final boolean addEffect(MobEffectInstance mobeffect) {
        return this.addEffect(mobeffect, (Entity)null);
    }

    public boolean addEffect(MobEffectInstance mobeffect, EntityPotionEffectEvent.Cause cause) {
        return this.addEffect(mobeffect, null, cause);
    }

    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity) {
        return this.addEffect(mobeffect, entity, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean addEffect(MobEffectInstance mobeffect, @Nullable Entity entity, EntityPotionEffectEvent.Cause cause) {
        EntityPotionEffectEvent event;
        AsyncCatcher.catchOp("effect add");
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(mobeffect, cause));
            return true;
        }
        if (!this.canBeAffected(mobeffect)) {
            return false;
        }
        MobEffectInstance mobeffect1 = this.activeEffects.get(mobeffect.getEffect());
        boolean flag = false;
        boolean override = false;
        if (mobeffect1 != null) {
            override = new MobEffectInstance(mobeffect1).update(mobeffect);
        }
        if ((event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, mobeffect1, mobeffect, cause, override)).isCancelled()) {
            return false;
        }
        if (mobeffect1 == null) {
            this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            this.onEffectAdded(mobeffect, entity);
            flag = true;
            mobeffect.onEffectAdded(this);
        } else if (event.isOverride()) {
            mobeffect1.update(mobeffect);
            this.onEffectUpdated(mobeffect1, true, entity);
            flag = true;
        }
        mobeffect.onEffectStarted(this);
        return flag;
    }

    public boolean canBeAffected(MobEffectInstance mobeffect) {
        return this.getType().is(EntityTypeTags.IMMUNE_TO_INFESTED) ? !mobeffect.is(MobEffects.INFESTED) : (this.getType().is(EntityTypeTags.IMMUNE_TO_OOZING) ? !mobeffect.is(MobEffects.OOZING) : (!this.getType().is(EntityTypeTags.IGNORES_POISON_AND_REGEN) ? true : !mobeffect.is(MobEffects.REGENERATION) && !mobeffect.is(MobEffects.POISON)));
    }

    public void forceAddEffect(MobEffectInstance mobeffect, @Nullable Entity entity) {
        if (this.canBeAffected(mobeffect)) {
            MobEffectInstance mobeffect1 = this.activeEffects.put(mobeffect.getEffect(), mobeffect);
            if (mobeffect1 == null) {
                this.onEffectAdded(mobeffect, entity);
            } else {
                mobeffect.copyBlendState(mobeffect1);
                this.onEffectUpdated(mobeffect, true, entity);
            }
        }
    }

    public boolean isInvertedHealAndHarm() {
        return this.getType().is(EntityTypeTags.INVERTED_HEALING_AND_HARM);
    }

    @Nullable
    public final MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> holder) {
        return this.removeEffectNoUpdate(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    @Nullable
    public final MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> holder, EntityPotionEffectEvent.Cause cause) {
        if (this.isTickingEffects) {
            this.effectsToProcess.add(new ProcessableEffect(holder, cause));
            return null;
        }
        MobEffectInstance effect = this.activeEffects.get(holder);
        if (effect == null) {
            return null;
        }
        EntityPotionEffectEvent event = CraftEventFactory.callEntityPotionEffectChangeEvent(this, effect, null, cause);
        if (event.isCancelled()) {
            return null;
        }
        return this.activeEffects.remove(holder);
    }

    public boolean removeEffect(Holder<MobEffect> holder) {
        return this.removeEffect(holder, EntityPotionEffectEvent.Cause.UNKNOWN);
    }

    public boolean removeEffect(Holder<MobEffect> holder, EntityPotionEffectEvent.Cause cause) {
        MobEffectInstance mobeffect = this.removeEffectNoUpdate(holder, cause);
        if (mobeffect != null) {
            this.onEffectsRemoved(List.of(mobeffect));
            return true;
        }
        return false;
    }

    protected void onEffectAdded(MobEffectInstance mobeffect, @Nullable Entity entity) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            mobeffect.getEffect().value().addAttributeModifiers(this.getAttributes(), mobeffect.getAmplifier());
            this.sendEffectToPassengers(mobeffect);
        }
    }

    public void sendEffectToPassengers(MobEffectInstance mobeffect) {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof ServerPlayer)) continue;
            ServerPlayer entityplayer = (ServerPlayer)entity;
            entityplayer.connection.send(new ClientboundUpdateMobEffectPacket(this.getId(), mobeffect, false));
        }
    }

    protected void onEffectUpdated(MobEffectInstance mobeffect, boolean flag, @Nullable Entity entity) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            if (flag) {
                MobEffect mobeffectlist = mobeffect.getEffect().value();
                mobeffectlist.removeAttributeModifiers(this.getAttributes());
                mobeffectlist.addAttributeModifiers(this.getAttributes(), mobeffect.getAmplifier());
                this.refreshDirtyAttributes();
            }
            this.sendEffectToPassengers(mobeffect);
        }
    }

    protected void onEffectsRemoved(Collection<MobEffectInstance> collection) {
        if (!this.level().isClientSide()) {
            this.effectsDirty = true;
            for (MobEffectInstance mobeffect : collection) {
                mobeffect.getEffect().value().removeAttributeModifiers(this.getAttributes());
                for (Entity entity : this.getPassengers()) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer entityplayer = (ServerPlayer)entity;
                    entityplayer.connection.send(new ClientboundRemoveMobEffectPacket(this.getId(), mobeffect.getEffect()));
                }
            }
            this.refreshDirtyAttributes();
        }
    }

    private void refreshDirtyAttributes() {
        Set<AttributeInstance> set = this.getAttributes().getAttributesToUpdate();
        for (AttributeInstance attributemodifiable : set) {
            this.onAttributeUpdated(attributemodifiable.getAttribute());
        }
        set.clear();
    }

    protected void onAttributeUpdated(Holder<Attribute> holder) {
        Level world;
        if (holder.is(Attributes.MAX_HEALTH)) {
            float f = this.getMaxHealth();
            if (this.getHealth() > f) {
                this.setHealth(f);
            }
        } else if (holder.is(Attributes.MAX_ABSORPTION)) {
            float f1 = this.getMaxAbsorption();
            if (this.getAbsorptionAmount() > f1) {
                this.setAbsorptionAmount(f1);
            }
        } else if (holder.is(Attributes.SCALE)) {
            this.refreshDimensions();
        } else if (holder.is(Attributes.WAYPOINT_TRANSMIT_RANGE) && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            ServerWaypointManager serverwaypointmanager = worldserver.getWaypointManager();
            if (this.attributes.getValue(holder) > 0.0) {
                serverwaypointmanager.trackWaypoint(this);
            } else {
                serverwaypointmanager.untrackWaypoint(this);
            }
        }
    }

    public void heal(float f) {
        this.heal(f, EntityRegainHealthEvent.RegainReason.CUSTOM);
    }

    public void heal(float f, EntityRegainHealthEvent.RegainReason regainReason) {
        float f1 = this.getHealth();
        if (f1 > 0.0f) {
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (double)f, regainReason);
            if (this.valid) {
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (!event.isCancelled()) {
                this.setHealth((float)((double)this.getHealth() + event.getAmount()));
            }
        }
    }

    public float getHealth() {
        if (this instanceof ServerPlayer) {
            return (float)((ServerPlayer)this).getBukkitEntity().getHealth();
        }
        return this.entityData.get(DATA_HEALTH_ID).floatValue();
    }

    public void setHealth(float f) {
        if (this instanceof ServerPlayer) {
            CraftPlayer player = ((ServerPlayer)this).getBukkitEntity();
            if (f < 0.0f) {
                player.setRealHealth(0.0);
            } else if ((double)f > player.getMaxHealth()) {
                player.setRealHealth(player.getMaxHealth());
            } else {
                player.setRealHealth(f);
            }
            player.updateScaledHealth(false);
            return;
        }
        this.entityData.set(DATA_HEALTH_ID, Float.valueOf(Mth.clamp(f, 0.0f, this.getMaxHealth())));
    }

    public boolean isDeadOrDying() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        Entity entity1;
        boolean flag2;
        boolean flag;
        if (this.isInvulnerableTo(worldserver, damagesource)) {
            return false;
        }
        if (this.isRemoved() || this.dead || this.getHealth() <= 0.0f) {
            return false;
        }
        if (damagesource.is(DamageTypeTags.IS_FIRE) && this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        this.noActionTime = 0;
        if (f < 0.0f) {
            f = 0.0f;
        }
        float f1 = f;
        ItemStack itemstack = this.getUseItem();
        EntityDamageEvent event = this.handleEntityDamage(damagesource, f);
        f = 0.0f;
        f += (float)event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        f += (float)event.getDamage(EntityDamageEvent.DamageModifier.FREEZING);
        f += (float)event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT);
        float f2 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
        boolean bl = flag = f2 > 0.0f;
        if (Float.isNaN(f -= f2) || Float.isInfinite(f)) {
            f = Float.MAX_VALUE;
        }
        boolean flag1 = true;
        if ((float)this.invulnerableTime > (float)this.invulnerableDuration / 2.0f && !damagesource.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
            if (f <= this.lastHurt) {
                return false;
            }
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage() - this.lastHurt, event)) {
                return false;
            }
            this.lastHurt = f;
            flag1 = false;
        } else {
            if (!this.actuallyHurt(worldserver, damagesource, (float)event.getFinalDamage(), event)) {
                return false;
            }
            this.lastHurt = f;
            this.invulnerableTime = this.invulnerableDuration;
            this.hurtTime = this.hurtDuration = 10;
        }
        this.resolveMobResponsibleForDamage(damagesource);
        this.resolvePlayerResponsibleForDamage(damagesource);
        if (flag1) {
            BlocksAttacks blocksattacks = itemstack.get(DataComponents.BLOCKS_ATTACKS);
            if (flag && blocksattacks != null) {
                blocksattacks.onBlocked(worldserver, this);
            } else {
                worldserver.broadcastDamageEvent(this, damagesource);
            }
            if (!damagesource.is(DamageTypeTags.NO_IMPACT) && !flag) {
                this.markHurt();
            }
            if (!damagesource.is(DamageTypeTags.NO_KNOCKBACK)) {
                double d0 = 0.0;
                double d1 = 0.0;
                Entity entity = damagesource.getDirectEntity();
                if (entity instanceof Projectile) {
                    Projectile iprojectile = (Projectile)entity;
                    DoubleDoubleImmutablePair doubledoubleimmutablepair = iprojectile.calculateHorizontalHurtKnockbackDirection(this, damagesource);
                    d0 = -doubledoubleimmutablepair.leftDouble();
                    d1 = -doubledoubleimmutablepair.rightDouble();
                } else if (damagesource.getSourcePosition() != null) {
                    d0 = damagesource.getSourcePosition().x() - this.getX();
                    d1 = damagesource.getSourcePosition().z() - this.getZ();
                }
                this.knockback(0.4f, d0, d1, entity, entity == null ? EntityKnockbackEvent.KnockbackCause.DAMAGE : EntityKnockbackEvent.KnockbackCause.ENTITY_ATTACK);
                if (!flag) {
                    this.indicateDamage(d0, d1);
                }
            }
        }
        if (this.isDeadOrDying()) {
            if (!this.checkTotemDeathProtection(damagesource)) {
                if (flag1) {
                    this.makeSound(this.getDeathSound());
                    this.playSecondaryHurtSound(damagesource);
                }
                this.die(damagesource);
            }
        } else if (flag1) {
            this.playHurtSound(damagesource);
            this.playSecondaryHurtSound(damagesource);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = damagesource;
            this.lastDamageStamp = this.level().getGameTime();
            for (MobEffectInstance mobeffect : new LinkedList<MobEffectInstance>(this.getActiveEffects())) {
                mobeffect.onMobHurt(worldserver, this, damagesource, f);
            }
        }
        if (this instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)this;
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger(entityplayer, damagesource, f1, f, flag);
            if (f2 > 0.0f && f2 < 3.4028235E37f) {
                entityplayer.awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f2 * 10.0f));
            }
        }
        if ((entity1 = damagesource.getEntity()) instanceof ServerPlayer) {
            ServerPlayer entityplayer1 = (ServerPlayer)entity1;
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger(entityplayer1, this, damagesource, f1, f, flag);
        }
        return flag2;
    }

    public float applyItemBlocking(ServerLevel worldserver, DamageSource damagesource, float f) {
        return this.actuallyDoItemBlocking(worldserver, damagesource, this.calculateItemBlocking(damagesource, f));
    }

    private float calculateItemBlocking(DamageSource damagesource, float f) {
        if (f <= 0.0f) {
            return 0.0f;
        }
        ItemStack itemstack = this.getItemBlockingWith();
        if (itemstack == null) {
            return 0.0f;
        }
        BlocksAttacks blocksattacks = itemstack.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksattacks != null) {
            Optional<TagKey<DamageType>> optional = blocksattacks.bypassedBy();
            Objects.requireNonNull(damagesource);
            if (!optional.map(damagesource::is).orElse(false).booleanValue()) {
                double d0;
                AbstractArrow entityarrow;
                Entity entity = damagesource.getDirectEntity();
                if (entity instanceof AbstractArrow && (entityarrow = (AbstractArrow)entity).getPierceLevel() > 0) {
                    return 0.0f;
                }
                Vec3 vec3d = damagesource.getSourcePosition();
                if (vec3d != null) {
                    Vec3 vec3d1 = this.calculateViewVector(0.0f, this.getYHeadRot());
                    Vec3 vec3d2 = vec3d.subtract(this.position());
                    vec3d2 = new Vec3(vec3d2.x, 0.0, vec3d2.z).normalize();
                    d0 = Math.acos(vec3d2.dot(vec3d1));
                } else {
                    d0 = 3.1415927410125732;
                }
                float f1 = blocksattacks.resolveBlockedDamage(damagesource, f, d0);
                return f1;
            }
        }
        return 0.0f;
    }

    private float actuallyDoItemBlocking(ServerLevel worldserver, DamageSource damagesource, float f1) {
        BlocksAttacks blocksattacks;
        ItemStack itemstack = this.getItemBlockingWith();
        if (itemstack != null && (blocksattacks = itemstack.get(DataComponents.BLOCKS_ATTACKS)) != null) {
            Entity entity1;
            blocksattacks.hurtBlockingItem(this.level(), itemstack, this, this.getUsedItemHand(), f1);
            if (f1 > 0.0f && !damagesource.is(DamageTypeTags.IS_PROJECTILE) && (entity1 = damagesource.getDirectEntity()) instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity1;
                this.blockUsingItem(worldserver, entityliving);
            }
            return f1;
        }
        return 0.0f;
    }

    private void playSecondaryHurtSound(DamageSource damagesource) {
        if (damagesource.is(DamageTypes.THORNS)) {
            SoundSource soundcategory = this instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            this.level().playSound((Entity)null, this.position().x, this.position().y, this.position().z, SoundEvents.THORNS_HIT, soundcategory);
        }
    }

    protected void resolveMobResponsibleForDamage(DamageSource damagesource) {
        Entity entity = damagesource.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            if (!(damagesource.is(DamageTypeTags.NO_ANGER) || damagesource.is(DamageTypes.WIND_CHARGE) && this.getType().is(EntityTypeTags.NO_ANGER_FROM_WIND_CHARGE))) {
                this.setLastHurtByMob(entityliving);
            }
        }
    }

    @Nullable
    protected Player resolvePlayerResponsibleForDamage(DamageSource damagesource) {
        Wolf entitywolf;
        Entity entity = damagesource.getEntity();
        if (entity instanceof Player) {
            Player entityhuman = (Player)entity;
            this.setLastHurtByPlayer(entityhuman, 100);
        } else if (entity instanceof Wolf && (entitywolf = (Wolf)entity).isTame()) {
            if (entitywolf.getOwnerReference() != null) {
                this.setLastHurtByPlayer(entitywolf.getOwnerReference().getUUID(), 100);
            } else {
                this.lastHurtByPlayer = null;
                this.lastHurtByPlayerMemoryTime = 0;
            }
        }
        return EntityReference.getPlayer(this.lastHurtByPlayer, this.level());
    }

    protected void blockUsingItem(ServerLevel worldserver, LivingEntity entityliving) {
        entityliving.blockedByItem(this);
    }

    protected void blockedByItem(LivingEntity entityliving) {
        entityliving.knockback(0.5, entityliving.getX() - this.getX(), entityliving.getZ() - this.getZ(), null, EntityKnockbackEvent.KnockbackCause.SHIELD_BLOCK);
    }

    private boolean checkTotemDeathProtection(DamageSource damagesource) {
        if (damagesource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        ItemStack itemstack = null;
        DeathProtection deathprotection = null;
        InteractionHand hand = null;
        ItemStack itemstack1 = ItemStack.EMPTY;
        for (InteractionHand enumhand : InteractionHand.values()) {
            itemstack1 = this.getItemInHand(enumhand);
            deathprotection = itemstack1.get(DataComponents.DEATH_PROTECTION);
            if (deathprotection == null) continue;
            hand = enumhand;
            itemstack = itemstack1.copy();
            break;
        }
        org.bukkit.inventory.EquipmentSlot handSlot = hand != null ? CraftEquipmentSlot.getHand(hand) : null;
        EntityResurrectEvent event = new EntityResurrectEvent((org.bukkit.entity.LivingEntity)this.getBukkitEntity(), handSlot);
        event.setCancelled(itemstack == null);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (!itemstack1.isEmpty()) {
                itemstack1.shrink(1);
            }
            if (itemstack != null && this instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)this;
                entityplayer.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
                CriteriaTriggers.USED_TOTEM.trigger(entityplayer, itemstack);
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
            this.setHealth(1.0f);
            deathprotection.applyEffects(itemstack, this);
            this.level().broadcastEntityEvent(this, (byte)35);
        }
        return deathprotection != null;
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        if (this.level().getGameTime() - this.lastDamageStamp > 40L) {
            this.lastDamageSource = null;
        }
        return this.lastDamageSource;
    }

    protected void playHurtSound(DamageSource damagesource) {
        this.makeSound(this.getHurtSound(damagesource));
    }

    public void makeSound(@Nullable SoundEvent soundeffect) {
        if (soundeffect != null) {
            this.playSound(soundeffect, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    private void breakItem(ItemStack itemstack) {
        if (!itemstack.isEmpty()) {
            Holder<SoundEvent> holder = itemstack.get(DataComponents.BREAK_SOUND);
            if (holder != null && !this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), holder.value(), this.getSoundSource(), 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f, false);
            }
            this.spawnItemParticles(itemstack, 5);
        }
    }

    public void die(DamageSource damagesource) {
        if (!this.isRemoved() && !this.dead) {
            Entity entity = damagesource.getEntity();
            LivingEntity entityliving = this.getKillCredit();
            if (entityliving != null) {
                entityliving.awardKillScore(this, damagesource);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            if (!this.level().isClientSide() && this.hasCustomName() && SpigotConfig.logNamedDeaths) {
                LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (entity == null || entity.killedEntity(worldserver, this, damagesource)) {
                    this.gameEvent(GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(worldserver, damagesource);
                    this.createWitherRose(entityliving);
                }
                this.level().broadcastEntityEvent(this, (byte)3);
            }
            this.setPose(Pose.DYING);
        }
    }

    protected void createWitherRose(@Nullable LivingEntity entityliving) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            boolean flag = false;
            if (entityliving instanceof WitherBoss) {
                if (worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                    BlockPos blockposition = this.blockPosition();
                    BlockState iblockdata = Blocks.WITHER_ROSE.defaultBlockState();
                    if (this.level().getBlockState(blockposition).isAir() && iblockdata.canSurvive(this.level(), blockposition)) {
                        flag = CraftEventFactory.handleBlockFormEvent(this.level(), blockposition, iblockdata, 3, this);
                    }
                }
                if (!flag) {
                    ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack(Items.WITHER_ROSE));
                    EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                    CraftEventFactory.callEvent(event);
                    if (event.isCancelled()) {
                        return;
                    }
                    this.level().addFreshEntity(entityitem);
                }
            }
        }
    }

    protected void dropAllDeathLoot(ServerLevel worldserver, DamageSource damagesource) {
        boolean flag = this.lastHurtByPlayerMemoryTime > 0;
        this.dropEquipment(worldserver);
        if (this.shouldDropLoot(worldserver)) {
            this.dropFromLootTable(worldserver, damagesource, flag);
            this.dropCustomDeathLoot(worldserver, damagesource, flag);
        }
        CraftEventFactory.callEntityDeathEvent(this, damagesource, this.drops);
        this.drops = new ArrayList();
        this.dropExperience(worldserver, damagesource.getEntity());
    }

    protected void dropEquipment(ServerLevel worldserver) {
    }

    public int getExpReward(ServerLevel worldserver, @Nullable Entity entity) {
        if (!this.wasExperienceConsumed() && (this.isAlwaysExperienceDropper() || this.lastHurtByPlayerMemoryTime > 0 && this.shouldDropExperience() && worldserver.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT))) {
            return this.getExperienceReward(worldserver, entity);
        }
        return 0;
    }

    protected void dropExperience(ServerLevel worldserver, @Nullable Entity entity) {
        if (!(this instanceof EnderDragon)) {
            ExperienceOrb.award(worldserver, this.position(), this.expToDrop);
            this.expToDrop = 0;
        }
    }

    protected void dropCustomDeathLoot(ServerLevel worldserver, DamageSource damagesource, boolean flag) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    protected float getKnockback(Entity entity, DamageSource damagesource) {
        float f = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return EnchantmentHelper.modifyKnockback(worldserver, this.getWeaponItem(), entity, damagesource, f);
        }
        return f;
    }

    protected void dropFromLootTable(ServerLevel worldserver, DamageSource damagesource, boolean flag) {
        Optional<ResourceKey<LootTable>> optional = this.getLootTable();
        if (!optional.isEmpty()) {
            this.dropFromLootTable(worldserver, damagesource, flag, optional.get());
        }
    }

    public void dropFromLootTable(ServerLevel worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey) {
        this.dropFromLootTable(worldserver, damagesource, flag, resourcekey, itemstack -> this.spawnAtLocation(worldserver, (ItemStack)itemstack));
    }

    public void dropFromLootTable(ServerLevel worldserver, DamageSource damagesource, boolean flag, ResourceKey<LootTable> resourcekey, Consumer<ItemStack> consumer) {
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
        LootParams.Builder lootparams_a = new LootParams.Builder(worldserver).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, damagesource).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, damagesource.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, damagesource.getDirectEntity());
        Player entityhuman = this.getLastHurtByPlayer();
        if (flag && entityhuman != null) {
            lootparams_a = lootparams_a.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, entityhuman).withLuck(entityhuman.getLuck());
        }
        LootParams lootparams = lootparams_a.create(LootContextParamSets.ENTITY);
        loottable.getRandomItems(lootparams, this.getLootTableSeed(), consumer);
    }

    public boolean dropFromEntityInteractLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, @Nullable Entity entity, ItemStack itemstack, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        return this.dropFromLootTable(worldserver, resourcekey, lootparams_a -> lootparams_a.withParameter(LootContextParams.TARGET_ENTITY, this).withOptionalParameter(LootContextParams.INTERACTING_ENTITY, entity).withParameter(LootContextParams.TOOL, itemstack).create(LootContextParamSets.ENTITY_INTERACT), biconsumer);
    }

    public boolean dropFromGiftLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        return this.dropFromLootTable(worldserver, resourcekey, lootparams_a -> lootparams_a.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).create(LootContextParamSets.GIFT), biconsumer);
    }

    protected void dropFromShearingLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, ItemStack itemstack, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        this.dropFromLootTable(worldserver, resourcekey, lootparams_a -> lootparams_a.withParameter(LootContextParams.ORIGIN, this.position()).withParameter(LootContextParams.THIS_ENTITY, this).withParameter(LootContextParams.TOOL, itemstack).create(LootContextParamSets.SHEARING), biconsumer);
    }

    protected boolean dropFromLootTable(ServerLevel worldserver, ResourceKey<LootTable> resourcekey, Function<LootParams.Builder, LootParams> function, BiConsumer<ServerLevel, ItemStack> biconsumer) {
        LootParams lootparams;
        LootTable loottable = worldserver.getServer().reloadableRegistries().getLootTable(resourcekey);
        ObjectArrayList<ItemStack> list = loottable.getRandomItems(lootparams = function.apply(new LootParams.Builder(worldserver)));
        if (!list.isEmpty()) {
            list.forEach(itemstack -> biconsumer.accept(worldserver, (ItemStack)itemstack));
            return true;
        }
        return false;
    }

    public void knockback(double d0, double d1, double d2) {
        this.knockback(d0, d1, d2, null, EntityKnockbackEvent.KnockbackCause.UNKNOWN);
    }

    public void knockback(double d0, double d1, double d2, Entity attacker, EntityKnockbackEvent.KnockbackCause cause) {
        d0 *= 1.0 - this.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        Vec3 vec3d = this.getDeltaMovement();
        while (d1 * d1 + d2 * d2 < (double)1.0E-5f) {
            d1 = (Math.random() - Math.random()) * 0.01;
            d2 = (Math.random() - Math.random()) * 0.01;
        }
        Vec3 vec3d1 = new Vec3(d1, 0.0, d2).normalize().scale(d0);
        EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)this.getBukkitEntity(), attacker, cause, d0, vec3d1, vec3d.x / 2.0 - vec3d1.x, this.onGround() ? Math.min(0.4, vec3d.y / 2.0 + d0) : vec3d.y, vec3d.z / 2.0 - vec3d1.z);
        if (event.isCancelled()) {
            return;
        }
        this.hasImpulse = true;
        this.setDeltaMovement(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ());
    }

    public void indicateDamage(double d0, double d1) {
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.GENERIC_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.GENERIC_DEATH;
    }

    private SoundEvent getFallDamageSound(int i) {
        return i > 4 ? this.getFallSounds().big() : this.getFallSounds().small();
    }

    public void skipDropExperience() {
        this.skipDropExperience = true;
    }

    public boolean wasExperienceConsumed() {
        return this.skipDropExperience;
    }

    public float getHurtDir() {
        return 0.0f;
    }

    protected AABB getHitbox() {
        AABB axisalignedbb = this.getBoundingBox();
        Entity entity = this.getVehicle();
        if (entity != null) {
            Vec3 vec3d = entity.getPassengerRidingPosition(this);
            return axisalignedbb.setMinY(Math.max(vec3d.y, axisalignedbb.minY));
        }
        return axisalignedbb;
    }

    public Map<Enchantment, Set<EnchantmentLocationBasedEffect>> activeLocationDependentEnchantments(EquipmentSlot enumitemslot) {
        return (Map)this.activeLocationDependentEnchantments.computeIfAbsent(enumitemslot, enumitemslot1 -> new Reference2ObjectArrayMap());
    }

    public Fallsounds getFallSounds() {
        return new Fallsounds(SoundEvents.GENERIC_SMALL_FALL, SoundEvents.GENERIC_BIG_FALL);
    }

    public SoundEvent getHurtSound0(DamageSource damagesource) {
        return this.getHurtSound(damagesource);
    }

    public SoundEvent getDeathSound0() {
        return this.getDeathSound();
    }

    public SoundEvent getFallDamageSound0(int fallHeight) {
        return this.getFallDamageSound(fallHeight);
    }

    public Optional<BlockPos> getLastClimbablePos() {
        return this.lastClimbablePos;
    }

    public boolean onClimbable() {
        if (this.isSpectator()) {
            return false;
        }
        BlockPos blockposition = this.blockPosition();
        BlockState iblockdata = this.getInBlockState();
        if (iblockdata.is(BlockTags.CLIMBABLE)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        if (iblockdata.getBlock() instanceof TrapDoorBlock && this.trapdoorUsableAsLadder(blockposition, iblockdata)) {
            this.lastClimbablePos = Optional.of(blockposition);
            return true;
        }
        return false;
    }

    private boolean trapdoorUsableAsLadder(BlockPos blockposition, BlockState iblockdata) {
        if (!iblockdata.getValue(TrapDoorBlock.OPEN).booleanValue()) {
            return false;
        }
        BlockState iblockdata1 = this.level().getBlockState(blockposition.below());
        return iblockdata1.is(Blocks.LADDER) && iblockdata1.getValue(LadderBlock.FACING) == iblockdata.getValue(TrapDoorBlock.FACING);
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved() && this.getHealth() > 0.0f;
    }

    public boolean isLookingAtMe(LivingEntity entityliving, double d0, boolean flag, boolean flag1, double ... adouble) {
        Vec3 vec3d = entityliving.getViewVector(1.0f).normalize();
        for (double d1 : adouble) {
            Vec3 vec3d1 = new Vec3(this.getX() - entityliving.getX(), d1 - entityliving.getEyeY(), this.getZ() - entityliving.getZ());
            double d2 = vec3d1.length();
            vec3d1 = vec3d1.normalize();
            double d3 = vec3d.dot(vec3d1);
            double d = flag ? d2 : 1.0;
            if (!(d3 > 1.0 - d0 / d) || !entityliving.hasLineOfSight(this, flag1 ? ClipContext.Block.VISUAL : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, d1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxFallDistance() {
        return this.getComfortableFallDistance(0.0f);
    }

    protected final int getComfortableFallDistance(float f) {
        return Mth.floor(f + 3.0f);
    }

    @Override
    public boolean causeFallDamage(double d0, float f, DamageSource damagesource) {
        boolean flag = super.causeFallDamage(d0, f, damagesource);
        int i = this.calculateFallDamage(d0, f);
        if (i > 0) {
            if (!this.hurtServer((ServerLevel)this.level(), damagesource, i)) {
                return true;
            }
            this.playSound(this.getFallDamageSound(i), 1.0f, 1.0f);
            this.playBlockFallSound();
            return true;
        }
        return flag;
    }

    protected int calculateFallDamage(double d0, float f) {
        if (this.getType().is(EntityTypeTags.FALL_DAMAGE_IMMUNE)) {
            return 0;
        }
        double d1 = this.calculateFallPower(d0);
        return Mth.floor(d1 * (double)f * this.getAttributeValue(Attributes.FALL_DAMAGE_MULTIPLIER));
    }

    private double calculateFallPower(double d0) {
        return d0 + 1.0E-6 - this.getAttributeValue(Attributes.SAFE_FALL_DISTANCE);
    }

    protected void playBlockFallSound() {
        if (!this.isSilent()) {
            int i = Mth.floor(this.getX());
            int j = Mth.floor(this.getY() - (double)0.2f);
            int k = Mth.floor(this.getZ());
            BlockState iblockdata = this.level().getBlockState(new BlockPos(i, j, k));
            if (!iblockdata.isAir()) {
                SoundType soundeffecttype = iblockdata.getSoundType();
                this.playSound(soundeffecttype.getFallSound(), soundeffecttype.getVolume() * 0.5f, soundeffecttype.getPitch() * 0.75f);
            }
        }
    }

    @Override
    public void animateHurt(float f) {
        this.hurtTime = this.hurtDuration = 10;
    }

    public int getArmorValue() {
        return Mth.floor(this.getAttributeValue(Attributes.ARMOR));
    }

    protected void hurtArmor(DamageSource damagesource, float f) {
    }

    protected void hurtHelmet(DamageSource damagesource, float f) {
    }

    protected void doHurtEquipment(DamageSource damagesource, float f, EquipmentSlot ... aenumitemslot) {
        if (f > 0.0f) {
            int i = (int)Math.max(1.0f, f / 4.0f);
            for (EquipmentSlot enumitemslot : aenumitemslot) {
                ItemStack itemstack = this.getItemBySlot(enumitemslot);
                Equippable equippable = itemstack.get(DataComponents.EQUIPPABLE);
                if (equippable == null || !equippable.damageOnHurt() || !itemstack.isDamageableItem() || !itemstack.canBeHurtBy(damagesource)) continue;
                itemstack.hurtAndBreak(i, this, enumitemslot);
            }
        }
    }

    protected float getDamageAfterArmorAbsorb(DamageSource damagesource, float f) {
        if (!damagesource.is(DamageTypeTags.BYPASSES_ARMOR)) {
            f = CombatRules.getDamageAfterAbsorb(this, f, damagesource, this.getArmorValue(), (float)this.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        }
        return f;
    }

    protected float getDamageAfterMagicAbsorb(DamageSource damagesource, float f) {
        float f4;
        if (damagesource.is(DamageTypeTags.BYPASSES_EFFECTS)) {
            return f;
        }
        if (f <= 0.0f) {
            return 0.0f;
        }
        if (damagesource.is(DamageTypeTags.BYPASSES_ENCHANTMENTS)) {
            return f;
        }
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            f4 = EnchantmentHelper.getDamageProtection(worldserver, this, damagesource);
        } else {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            f = CombatRules.getDamageAfterMagicAbsorb(f, f4);
        }
        return f;
    }

    private EntityDamageEvent handleEntityDamage(final DamageSource damagesource, float f) {
        float originalDamage = f;
        com.google.common.base.Function<Double, Double> freezing = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                if (damagesource.is(DamageTypeTags.IS_FREEZING) && LivingEntity.this.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                    return -(f - f * 5.0);
                }
                return -0.0;
            }
        };
        float freezingModifier = ((Double)freezing.apply((Object)f)).floatValue();
        com.google.common.base.Function<Double, Double> hardHat = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !LivingEntity.this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                    return -(f - f * 0.75);
                }
                return -0.0;
            }
        };
        float hardHatModifier = ((Double)hardHat.apply((Object)(f += freezingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> blocking = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                return -((double)LivingEntity.this.calculateItemBlocking(damagesource, f.floatValue()));
            }
        };
        float blockingModifier = ((Double)blocking.apply((Object)(f += hardHatModifier))).floatValue();
        com.google.common.base.Function<Double, Double> armor = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                return -(f - (double)LivingEntity.this.getDamageAfterArmorAbsorb(damagesource, f.floatValue()));
            }
        };
        float armorModifier = ((Double)armor.apply((Object)(f += blockingModifier))).floatValue();
        com.google.common.base.Function<Double, Double> resistance = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                if (!damagesource.is(DamageTypeTags.BYPASSES_EFFECTS) && LivingEntity.this.hasEffect(MobEffects.RESISTANCE) && !damagesource.is(DamageTypeTags.BYPASSES_RESISTANCE)) {
                    int i = (LivingEntity.this.getEffect(MobEffects.RESISTANCE).getAmplifier() + 1) * 5;
                    int j = 25 - i;
                    float f1 = f.floatValue() * (float)j;
                    return -(f - (double)Math.max(f1 / 25.0f, 0.0f));
                }
                return -0.0;
            }
        };
        float resistanceModifier = ((Double)resistance.apply((Object)(f += armorModifier))).floatValue();
        com.google.common.base.Function<Double, Double> magic = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                return -(f - (double)LivingEntity.this.getDamageAfterMagicAbsorb(damagesource, f.floatValue()));
            }
        };
        float magicModifier = ((Double)magic.apply((Object)(f += resistanceModifier))).floatValue();
        com.google.common.base.Function<Double, Double> absorption = new com.google.common.base.Function<Double, Double>(){

            public Double apply(Double f) {
                return -Math.max(f - Math.max(f - (double)LivingEntity.this.getAbsorptionAmount(), 0.0), 0.0);
            }
        };
        float absorptionModifier = ((Double)absorption.apply((Object)(f += magicModifier))).floatValue();
        return CraftEventFactory.handleLivingEntityDamageEvent(this, damagesource, originalDamage, freezingModifier, hardHatModifier, blockingModifier, armorModifier, resistanceModifier, magicModifier, absorptionModifier, freezing, hardHat, blocking, armor, resistance, magic, absorption);
    }

    protected boolean actuallyHurt(ServerLevel worldserver, DamageSource damagesource, float f, EntityDamageEvent event) {
        if (!this.isInvulnerableTo(worldserver, damagesource)) {
            Entity entity;
            float f3;
            if (event.isCancelled()) {
                return false;
            }
            if (damagesource.getEntity() instanceof Player) {
                ((Player)damagesource.getEntity()).resetAttackStrengthTicker();
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE) < 0.0 && (f3 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.RESISTANCE))) > 0.0f && f3 < 3.4028235E37f) {
                if (this instanceof ServerPlayer) {
                    ((ServerPlayer)this).awardStat(Stats.DAMAGE_RESISTED, Math.round(f3 * 10.0f));
                } else if (damagesource.getEntity() instanceof ServerPlayer) {
                    ((ServerPlayer)damagesource.getEntity()).awardStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f3 * 10.0f));
                }
            }
            if (damagesource.is(DamageTypeTags.DAMAGES_HELMET) && !this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                this.hurtHelmet(damagesource, f);
            }
            if (!damagesource.is(DamageTypeTags.BYPASSES_ARMOR)) {
                float armorDamage = (float)(event.getDamage() + event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) + event.getDamage(EntityDamageEvent.DamageModifier.HARD_HAT));
                this.hurtArmor(damagesource, armorDamage);
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                this.actuallyDoItemBlocking(worldserver, damagesource, (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING)));
            }
            boolean human = this instanceof Player;
            float originalDamage = (float)event.getDamage();
            float absorptionModifier = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.ABSORPTION));
            this.setAbsorptionAmount(Math.max(this.getAbsorptionAmount() - absorptionModifier, 0.0f));
            float f2 = absorptionModifier;
            if (f2 > 0.0f && f2 < 3.4028235E37f && this instanceof Player) {
                ((Player)this).awardStat(Stats.DAMAGE_ABSORBED, Math.round(f2 * 10.0f));
            }
            if (f2 > 0.0f && f2 < 3.4028235E37f && (entity = damagesource.getEntity()) instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entity;
                entityplayer.awardStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f2 * 10.0f));
            }
            if (f > 0.0f || !human) {
                if (human) {
                    ((Player)this).causeFoodExhaustion(damagesource.getFoodExhaustion(), EntityExhaustionEvent.ExhaustionReason.DAMAGED);
                    if (f < 3.4028235E37f) {
                        ((Player)this).awardStat(Stats.DAMAGE_TAKEN, Math.round(f * 10.0f));
                    }
                }
                this.getCombatTracker().recordDamage(damagesource, f);
                this.setHealth(this.getHealth() - f);
                if (!human) {
                    this.setAbsorptionAmount(this.getAbsorptionAmount() - f);
                }
                this.gameEvent(GameEvent.ENTITY_DAMAGE);
                return true;
            }
            if (event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING) < 0.0) {
                if (this instanceof ServerPlayer) {
                    CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayer)this, damagesource, f, originalDamage, true);
                    f2 = (float)(-event.getDamage(EntityDamageEvent.DamageModifier.BLOCKING));
                    if (f2 > 0.0f && f2 < 3.4028235E37f) {
                        ((ServerPlayer)this).awardStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(originalDamage * 10.0f));
                    }
                }
                if (damagesource.getEntity() instanceof ServerPlayer) {
                    CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayer)damagesource.getEntity(), this, damagesource, f, originalDamage, true);
                }
                return true;
            }
            return originalDamage > 0.0f;
        }
        return false;
    }

    public CombatTracker getCombatTracker() {
        return this.combatTracker;
    }

    @Nullable
    public LivingEntity getKillCredit() {
        return this.lastHurtByPlayer != null ? (LivingEntity)this.lastHurtByPlayer.getEntity(this.level(), Player.class) : (this.lastHurtByMob != null ? this.lastHurtByMob.getEntity(this.level(), LivingEntity.class) : null);
    }

    public final float getMaxHealth() {
        return (float)this.getAttributeValue(Attributes.MAX_HEALTH);
    }

    public final float getMaxAbsorption() {
        return (float)this.getAttributeValue(Attributes.MAX_ABSORPTION);
    }

    public final int getArrowCount() {
        return this.entityData.get(DATA_ARROW_COUNT_ID);
    }

    public final void setArrowCount(int i) {
        this.setArrowCount(i, false);
    }

    public final void setArrowCount(int i, boolean flag) {
        ArrowBodyCountChangeEvent event = CraftEventFactory.callArrowBodyCountChangeEvent(this, this.getArrowCount(), i, flag);
        if (event.isCancelled()) {
            return;
        }
        this.entityData.set(DATA_ARROW_COUNT_ID, event.getNewAmount());
    }

    public final int getStingerCount() {
        return this.entityData.get(DATA_STINGER_COUNT_ID);
    }

    public final void setStingerCount(int i) {
        this.entityData.set(DATA_STINGER_COUNT_ID, i);
    }

    private int getCurrentSwingDuration() {
        return MobEffectUtil.hasDigSpeed(this) ? 6 - (1 + MobEffectUtil.getDigSpeedAmplification(this)) : (this.hasEffect(MobEffects.MINING_FATIGUE) ? 6 + (1 + this.getEffect(MobEffects.MINING_FATIGUE).getAmplifier()) * 2 : 6);
    }

    public void swing(InteractionHand enumhand) {
        this.swing(enumhand, false);
    }

    public void swing(InteractionHand enumhand, boolean flag) {
        if (!this.swinging || this.swingTime >= this.getCurrentSwingDuration() / 2 || this.swingTime < 0) {
            this.swingTime = -1;
            this.swinging = true;
            this.swingingArm = enumhand;
            if (this.level() instanceof ServerLevel) {
                ClientboundAnimatePacket packetplayoutanimation = new ClientboundAnimatePacket(this, enumhand == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache chunkproviderserver = ((ServerLevel)this.level()).getChunkSource();
                if (flag) {
                    chunkproviderserver.sendToTrackingPlayersAndSelf(this, packetplayoutanimation);
                } else {
                    chunkproviderserver.sendToTrackingPlayers(this, packetplayoutanimation);
                }
            }
        }
    }

    @Override
    public void handleDamageEvent(DamageSource damagesource) {
        this.walkAnimation.setSpeed(1.5f);
        this.invulnerableTime = 20;
        this.hurtTime = this.hurtDuration = 10;
        SoundEvent soundeffect = this.getHurtSound(damagesource);
        if (soundeffect != null) {
            this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.lastDamageSource = damagesource;
        this.lastDamageStamp = this.level().getGameTime();
    }

    @Override
    public void handleEntityEvent(byte b0) {
        switch (b0) {
            case 3: {
                SoundEvent soundeffect = this.getDeathSound();
                if (soundeffect != null) {
                    this.playSound(soundeffect, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.setHealth(0.0f);
                this.die(this.damageSources().generic());
                break;
            }
            case 46: {
                int i = 128;
                for (int j = 0; j < 128; ++j) {
                    double d0 = (double)j / 127.0;
                    float f = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (this.random.nextFloat() - 0.5f) * 0.2f;
                    double d1 = Mth.lerp(d0, this.xo, this.getX()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    double d2 = Mth.lerp(d0, this.yo, this.getY()) + this.random.nextDouble() * (double)this.getBbHeight();
                    double d3 = Mth.lerp(d0, this.zo, this.getZ()) + (this.random.nextDouble() - 0.5) * (double)this.getBbWidth() * 2.0;
                    this.level().addParticle(ParticleTypes.PORTAL, d1, d2, d3, f, f1, f2);
                }
                break;
            }
            case 47: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.FEET));
                break;
            }
            case 54: {
                HoneyBlock.showJumpParticles(this);
                break;
            }
            case 55: {
                this.swapHandItems();
                break;
            }
            case 60: {
                this.makePoofParticles();
                break;
            }
            case 65: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.BODY));
                break;
            }
            case 67: {
                this.makeDrownParticles();
                break;
            }
            case 68: {
                this.breakItem(this.getItemBySlot(EquipmentSlot.SADDLE));
                break;
            }
            default: {
                super.handleEntityEvent(b0);
            }
        }
    }

    public void makePoofParticles() {
        for (int i = 0; i < 20; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            double d3 = 10.0;
            this.level().addParticle(ParticleTypes.POOF, this.getRandomX(1.0) - d0 * 10.0, this.getRandomY() - d1 * 10.0, this.getRandomZ(1.0) - d2 * 10.0, d0, d1, d2);
        }
    }

    private void makeDrownParticles() {
        Vec3 vec3d = this.getDeltaMovement();
        for (int i = 0; i < 8; ++i) {
            double d0 = this.random.triangle(0.0, 1.0);
            double d1 = this.random.triangle(0.0, 1.0);
            double d2 = this.random.triangle(0.0, 1.0);
            this.level().addParticle(ParticleTypes.BUBBLE, this.getX() + d0, this.getY() + d1, this.getZ() + d2, vec3d.x, vec3d.y, vec3d.z);
        }
    }

    private void swapHandItems() {
        ItemStack itemstack = this.getItemBySlot(EquipmentSlot.OFFHAND);
        this.setItemSlot(EquipmentSlot.OFFHAND, this.getItemBySlot(EquipmentSlot.MAINHAND));
        this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
    }

    @Override
    protected void onBelowWorld() {
        this.hurt(this.damageSources().fellOutOfWorld(), 4.0f);
    }

    protected void updateSwingTime() {
        int i = this.getCurrentSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i;
    }

    @Nullable
    public AttributeInstance getAttribute(Holder<Attribute> holder) {
        return this.getAttributes().getInstance(holder);
    }

    public double getAttributeValue(Holder<Attribute> holder) {
        return this.getAttributes().getValue(holder);
    }

    public double getAttributeBaseValue(Holder<Attribute> holder) {
        return this.getAttributes().getBaseValue(holder);
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public ItemStack getMainHandItem() {
        return this.getItemBySlot(EquipmentSlot.MAINHAND);
    }

    public ItemStack getOffhandItem() {
        return this.getItemBySlot(EquipmentSlot.OFFHAND);
    }

    public ItemStack getItemHeldByArm(HumanoidArm enummainhand) {
        return this.getMainArm() == enummainhand ? this.getMainHandItem() : this.getOffhandItem();
    }

    @Override
    @Nonnull
    public ItemStack getWeaponItem() {
        return this.getMainHandItem();
    }

    public boolean isHolding(net.minecraft.world.item.Item item) {
        return this.isHolding((ItemStack itemstack) -> itemstack.is(item));
    }

    public boolean isHolding(Predicate<ItemStack> predicate) {
        return predicate.test(this.getMainHandItem()) || predicate.test(this.getOffhandItem());
    }

    public ItemStack getItemInHand(InteractionHand enumhand) {
        if (enumhand == InteractionHand.MAIN_HAND) {
            return this.getItemBySlot(EquipmentSlot.MAINHAND);
        }
        if (enumhand == InteractionHand.OFF_HAND) {
            return this.getItemBySlot(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
    }

    public void setItemInHand(InteractionHand enumhand, ItemStack itemstack) {
        if (enumhand == InteractionHand.MAIN_HAND) {
            this.setItemSlot(EquipmentSlot.MAINHAND, itemstack);
        } else {
            if (enumhand != InteractionHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + String.valueOf((Object)enumhand));
            }
            this.setItemSlot(EquipmentSlot.OFFHAND, itemstack);
        }
    }

    public boolean hasItemInSlot(EquipmentSlot enumitemslot) {
        return !this.getItemBySlot(enumitemslot).isEmpty();
    }

    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return true;
    }

    public ItemStack getItemBySlot(EquipmentSlot enumitemslot) {
        return this.equipment.get(enumitemslot);
    }

    public void setItemSlot(EquipmentSlot enumitemslot, ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    public void setItemSlot(EquipmentSlot enumitemslot, ItemStack itemstack, boolean silent) {
        this.onEquipItem(enumitemslot, this.equipment.set(enumitemslot, itemstack), itemstack, silent);
    }

    public float getArmorCoverPercentage() {
        int i = 0;
        int j = 0;
        for (EquipmentSlot enumitemslot : EquipmentSlotGroup.ARMOR) {
            if (enumitemslot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            ItemStack itemstack = this.getItemBySlot(enumitemslot);
            if (!itemstack.isEmpty()) {
                ++j;
            }
            ++i;
        }
        return i > 0 ? (float)j / (float)i : 0.0f;
    }

    @Override
    public void setSprinting(boolean flag) {
        super.setSprinting(flag);
        AttributeInstance attributemodifiable = this.getAttribute(Attributes.MOVEMENT_SPEED);
        attributemodifiable.removeModifier(SPEED_MODIFIER_SPRINTING.id());
        if (flag) {
            attributemodifiable.addTransientModifier(SPEED_MODIFIER_SPRINTING);
        }
    }

    protected float getSoundVolume() {
        return 1.0f;
    }

    public float getVoicePitch() {
        return this.isBaby() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    @Override
    public void push(Entity entity) {
        if (!this.isSleeping()) {
            super.push(entity);
        }
    }

    private void dismountVehicle(Entity entity) {
        Vec3 vec3d;
        if (this.isRemoved()) {
            vec3d = this.position();
        } else if (!entity.isRemoved() && !this.level().getBlockState(entity.blockPosition()).is(BlockTags.PORTALS)) {
            vec3d = entity.getDismountLocationForPassenger(this);
        } else {
            boolean flag;
            double d0 = Math.max(this.getY(), entity.getY());
            vec3d = new Vec3(this.getX(), d0, this.getZ());
            boolean bl = flag = this.getBbWidth() <= 4.0f && this.getBbHeight() <= 4.0f;
            if (flag) {
                double d1 = (double)this.getBbHeight() / 2.0;
                Vec3 vec3d1 = vec3d.add(0.0, d1, 0.0);
                VoxelShape voxelshape = Shapes.create(AABB.ofSize(vec3d1, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()));
                vec3d = this.level().findFreePosition(this, voxelshape, vec3d1, this.getBbWidth(), this.getBbHeight(), this.getBbWidth()).map(vec3d2 -> vec3d2.add(0.0, -d1, 0.0)).orElse(vec3d);
            }
        }
        this.dismountTo(vec3d.x, vec3d.y, vec3d.z);
    }

    @Override
    public boolean shouldShowName() {
        return this.isCustomNameVisible();
    }

    protected float getJumpPower() {
        return this.getJumpPower(1.0f);
    }

    protected float getJumpPower(float f) {
        return (float)this.getAttributeValue(Attributes.JUMP_STRENGTH) * f * this.getBlockJumpFactor() + this.getJumpBoostPower();
    }

    public float getJumpBoostPower() {
        return this.hasEffect(MobEffects.JUMP_BOOST) ? 0.1f * ((float)this.getEffect(MobEffects.JUMP_BOOST).getAmplifier() + 1.0f) : 0.0f;
    }

    @VisibleForTesting
    public void jumpFromGround() {
        float f = this.getJumpPower();
        if (f > 1.0E-5f) {
            Vec3 vec3d = this.getDeltaMovement();
            this.setDeltaMovement(vec3d.x, Math.max((double)f, vec3d.y), vec3d.z);
            if (this.isSprinting()) {
                float f1 = this.getYRot() * ((float)Math.PI / 180);
                this.addDeltaMovement(new Vec3((double)(-Mth.sin(f1)) * 0.2, 0.0, (double)Mth.cos(f1) * 0.2));
            }
            this.hasImpulse = true;
        }
    }

    protected void goDownInWater() {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04f, 0.0));
    }

    protected void jumpInLiquid(TagKey<Fluid> tagkey) {
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.04f, 0.0));
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    public boolean canStandOnFluid(FluidState fluid) {
        return false;
    }

    @Override
    protected double getDefaultGravity() {
        return this.getAttributeValue(Attributes.GRAVITY);
    }

    protected double getEffectiveGravity() {
        boolean flag = this.getDeltaMovement().y <= 0.0;
        return flag && this.hasEffect(MobEffects.SLOW_FALLING) ? Math.min(this.getGravity(), 0.01) : this.getGravity();
    }

    public void travel(Vec3 vec3d) {
        FluidState fluid = this.level().getFluidState(this.blockPosition());
        if ((this.isInWater() || this.isInLava()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluid)) {
            this.travelInFluid(vec3d);
        } else if (this.isFallFlying()) {
            this.travelFallFlying(vec3d);
        } else {
            this.travelInAir(vec3d);
        }
    }

    protected void travelFlying(Vec3 vec3d, float f) {
        this.travelFlying(vec3d, 0.02f, 0.02f, f);
    }

    protected void travelFlying(Vec3 vec3d, float f, float f1, float f2) {
        if (this.isInWater()) {
            this.moveRelative(f, vec3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8f));
        } else if (this.isInLava()) {
            this.moveRelative(f1, vec3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
        } else {
            this.moveRelative(f2, vec3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.91f));
        }
    }

    private void travelInAir(Vec3 vec3d) {
        BlockPos blockposition = this.getBlockPosBelowThatAffectsMyMovement();
        float f = this.onGround() ? this.level().getBlockState(blockposition).getBlock().getFriction() : 1.0f;
        float f1 = f * 0.91f;
        Vec3 vec3d1 = this.handleRelativeFrictionAndCalculateMovement(vec3d, f);
        double d0 = vec3d1.y;
        MobEffectInstance mobeffect = this.getEffect(MobEffects.LEVITATION);
        d0 = mobeffect != null ? (d0 += (0.05 * (double)(mobeffect.getAmplifier() + 1) - vec3d1.y) * 0.2) : (this.level().isClientSide() && !this.level().hasChunkAt(blockposition) ? (this.getY() > (double)this.level().getMinY() ? -0.1 : 0.0) : (d0 -= this.getEffectiveGravity()));
        if (this.shouldDiscardFriction()) {
            this.setDeltaMovement(vec3d1.x, d0, vec3d1.z);
        } else {
            float f2 = this instanceof FlyingAnimal ? f1 : 0.98f;
            this.setDeltaMovement(vec3d1.x * (double)f1, d0 * (double)f2, vec3d1.z * (double)f1);
        }
    }

    private void travelInFluid(Vec3 vec3d) {
        boolean flag = this.getDeltaMovement().y <= 0.0;
        double d0 = this.getY();
        double d1 = this.getEffectiveGravity();
        if (this.isInWater()) {
            float f = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
            float f1 = 0.02f;
            float f2 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
            if (!this.onGround()) {
                f2 *= 0.5f;
            }
            if (f2 > 0.0f) {
                f += (0.54600006f - f) * f2;
                f1 += (this.getSpeed() - f1) * f2;
            }
            if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                f = 0.96f;
            }
            this.moveRelative(f1, vec3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 vec3d1 = this.getDeltaMovement();
            if (this.horizontalCollision && this.onClimbable()) {
                vec3d1 = new Vec3(vec3d1.x, 0.2, vec3d1.z);
            }
            vec3d1 = vec3d1.multiply(f, 0.8f, f);
            this.setDeltaMovement(this.getFluidFallingAdjustedMovement(d1, flag, vec3d1));
        } else {
            this.moveRelative(0.02f, vec3d);
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (this.getFluidHeight(FluidTags.LAVA) <= this.getFluidJumpThreshold()) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.5, 0.8f, 0.5));
                Vec3 vec3d2 = this.getFluidFallingAdjustedMovement(d1, flag, this.getDeltaMovement());
                this.setDeltaMovement(vec3d2);
            } else {
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            }
            if (d1 != 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -d1 / 4.0, 0.0));
            }
        }
        Vec3 vec3d3 = this.getDeltaMovement();
        if (this.horizontalCollision && this.isFree(vec3d3.x, vec3d3.y + (double)0.6f - this.getY() + d0, vec3d3.z)) {
            this.setDeltaMovement(vec3d3.x, 0.3f, vec3d3.z);
        }
    }

    private void travelFallFlying(Vec3 vec3d) {
        if (this.onClimbable()) {
            this.travelInAir(vec3d);
            this.stopFallFlying();
        } else {
            Vec3 vec3d1 = this.getDeltaMovement();
            double d0 = vec3d1.horizontalDistance();
            this.setDeltaMovement(this.updateFallFlyingMovement(vec3d1));
            this.move(MoverType.SELF, this.getDeltaMovement());
            if (!this.level().isClientSide()) {
                double d1 = this.getDeltaMovement().horizontalDistance();
                this.handleFallFlyingCollisions(d0, d1);
            }
        }
    }

    public void stopFallFlying() {
        if (CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            return;
        }
        this.setSharedFlag(7, true);
        this.setSharedFlag(7, false);
    }

    private Vec3 updateFallFlyingMovement(Vec3 vec3d) {
        Vec3 vec3d1 = this.getLookAngle();
        float f = this.getXRot() * ((float)Math.PI / 180);
        double d0 = Math.sqrt(vec3d1.x * vec3d1.x + vec3d1.z * vec3d1.z);
        double d1 = vec3d.horizontalDistance();
        double d2 = this.getEffectiveGravity();
        double d3 = Mth.square(Math.cos(f));
        vec3d = vec3d.add(0.0, d2 * (-1.0 + d3 * 0.75), 0.0);
        if (vec3d.y < 0.0 && d0 > 0.0) {
            double d4 = vec3d.y * -0.1 * d3;
            vec3d = vec3d.add(vec3d1.x * d4 / d0, d4, vec3d1.z * d4 / d0);
        }
        if (f < 0.0f && d0 > 0.0) {
            double d5 = d1 * (double)(-Mth.sin(f)) * 0.04;
            vec3d = vec3d.add(-vec3d1.x * d5 / d0, d5 * 3.2, -vec3d1.z * d5 / d0);
        }
        if (d0 > 0.0) {
            vec3d = vec3d.add((vec3d1.x / d0 * d1 - vec3d.x) * 0.1, 0.0, (vec3d1.z / d0 * d1 - vec3d.z) * 0.1);
        }
        return vec3d.multiply(0.99f, 0.98f, 0.99f);
    }

    private void handleFallFlyingCollisions(double d0, double d1) {
        double d2;
        float f;
        if (this.horizontalCollision && (f = (float)((d2 = d0 - d1) * 10.0 - 3.0)) > 0.0f) {
            this.playSound(this.getFallDamageSound((int)f), 1.0f, 1.0f);
            this.hurt(this.damageSources().flyIntoWall(), f);
        }
    }

    private void travelRidden(Player entityhuman, Vec3 vec3d) {
        Vec3 vec3d1 = this.getRiddenInput(entityhuman, vec3d);
        this.tickRidden(entityhuman, vec3d1);
        if (this.canSimulateMovement()) {
            this.setSpeed(this.getRiddenSpeed(entityhuman));
            this.travel(vec3d1);
        } else {
            this.setDeltaMovement(Vec3.ZERO);
        }
    }

    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
    }

    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        return vec3d;
    }

    protected float getRiddenSpeed(Player entityhuman) {
        return this.getSpeed();
    }

    public void calculateEntityAnimation(boolean flag) {
        float f = (float)Mth.length(this.getX() - this.xo, flag ? this.getY() - this.yo : 0.0, this.getZ() - this.zo);
        if (!this.isPassenger() && this.isAlive()) {
            this.updateWalkAnimation(f);
        } else {
            this.walkAnimation.stop();
        }
    }

    protected void updateWalkAnimation(float f) {
        float f1 = Math.min(f * 4.0f, 1.0f);
        this.walkAnimation.update(f1, 0.4f, this.isBaby() ? 3.0f : 1.0f);
    }

    private Vec3 handleRelativeFrictionAndCalculateMovement(Vec3 vec3d, float f) {
        this.moveRelative(this.getFrictionInfluencedSpeed(f), vec3d);
        this.setDeltaMovement(this.handleOnClimbable(this.getDeltaMovement()));
        this.move(MoverType.SELF, this.getDeltaMovement());
        Vec3 vec3d1 = this.getDeltaMovement();
        if ((this.horizontalCollision || this.jumping) && (this.onClimbable() || this.wasInPowderSnow && PowderSnowBlock.canEntityWalkOnPowderSnow(this))) {
            vec3d1 = new Vec3(vec3d1.x, 0.2, vec3d1.z);
        }
        return vec3d1;
    }

    public Vec3 getFluidFallingAdjustedMovement(double d0, boolean flag, Vec3 vec3d) {
        if (d0 != 0.0 && !this.isSprinting()) {
            double d1 = flag && Math.abs(vec3d.y - 0.005) >= 0.003 && Math.abs(vec3d.y - d0 / 16.0) < 0.003 ? -0.003 : vec3d.y - d0 / 16.0;
            return new Vec3(vec3d.x, d1, vec3d.z);
        }
        return vec3d;
    }

    private Vec3 handleOnClimbable(Vec3 vec3d) {
        if (this.onClimbable()) {
            this.resetFallDistance();
            float f = 0.15f;
            double d0 = Mth.clamp(vec3d.x, (double)-0.15f, (double)0.15f);
            double d1 = Mth.clamp(vec3d.z, (double)-0.15f, (double)0.15f);
            double d2 = Math.max(vec3d.y, (double)-0.15f);
            if (d2 < 0.0 && !this.getInBlockState().is(Blocks.SCAFFOLDING) && this.isSuppressingSlidingDownLadder() && this instanceof Player) {
                d2 = 0.0;
            }
            vec3d = new Vec3(d0, d2, d1);
        }
        return vec3d;
    }

    private float getFrictionInfluencedSpeed(float f) {
        return this.onGround() ? this.getSpeed() * (0.21600002f / (f * f * f)) : this.getFlyingSpeed();
    }

    protected float getFlyingSpeed() {
        return this.getControllingPassenger() instanceof Player ? this.getSpeed() * 0.1f : 0.02f;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float f) {
        this.speed = f;
    }

    public boolean doHurtTarget(ServerLevel worldserver, Entity entity) {
        this.setLastHurtMob(entity);
        return false;
    }

    @Override
    public void tick() {
        SpigotTimings.timerEntityBaseTick.startTiming();
        super.tick();
        this.updatingUsingItem();
        this.updateSwimAmount();
        if (!this.level().isClientSide()) {
            int j;
            int i = this.getArrowCount();
            if (i > 0) {
                if (this.removeArrowTime <= 0) {
                    this.removeArrowTime = 20 * (30 - i);
                }
                --this.removeArrowTime;
                if (this.removeArrowTime <= 0) {
                    this.setArrowCount(i - 1);
                }
            }
            if ((j = this.getStingerCount()) > 0) {
                if (this.removeStingerTime <= 0) {
                    this.removeStingerTime = 20 * (30 - j);
                }
                --this.removeStingerTime;
                if (this.removeStingerTime <= 0) {
                    this.setStingerCount(j - 1);
                }
            }
            this.detectEquipmentUpdatesPublic();
            if (this.tickCount % 20 == 0) {
                this.getCombatTracker().recheckStatus();
            }
            if (!(!this.isSleeping() || this.canInteractWithLevel() && this.checkBedExists())) {
                this.stopSleeping();
            }
        }
        if (!this.isRemoved()) {
            SpigotTimings.timerEntityBaseTick.stopTiming();
            this.aiStep();
            SpigotTimings.timerEntityTickRest.startTiming();
        }
        double d0 = this.getX() - this.xo;
        double d1 = this.getZ() - this.zo;
        float f = (float)(d0 * d0 + d1 * d1);
        float f1 = this.yBodyRot;
        if (f > 0.0025000002f) {
            float f2 = (float)Mth.atan2(d1, d0) * 57.295776f - 90.0f;
            float f3 = Mth.abs(Mth.wrapDegrees(this.getYRot()) - f2);
            f1 = 95.0f < f3 && f3 < 265.0f ? f2 - 180.0f : f2;
        }
        if (this.attackAnim > 0.0f) {
            f1 = this.getYRot();
        }
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("headTurn");
        this.tickHeadTurn(f1);
        gameprofilerfiller.pop();
        gameprofilerfiller.push("rangeChecks");
        while (this.getYRot() - this.yRotO < -180.0f) {
            this.yRotO -= 360.0f;
        }
        while (this.getYRot() - this.yRotO >= 180.0f) {
            this.yRotO += 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO < -180.0f) {
            this.yBodyRotO -= 360.0f;
        }
        while (this.yBodyRot - this.yBodyRotO >= 180.0f) {
            this.yBodyRotO += 360.0f;
        }
        while (this.getXRot() - this.xRotO < -180.0f) {
            this.xRotO -= 360.0f;
        }
        while (this.getXRot() - this.xRotO >= 180.0f) {
            this.xRotO += 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO < -180.0f) {
            this.yHeadRotO -= 360.0f;
        }
        while (this.yHeadRot - this.yHeadRotO >= 180.0f) {
            this.yHeadRotO += 360.0f;
        }
        gameprofilerfiller.pop();
        this.fallFlyTicks = this.isFallFlying() ? ++this.fallFlyTicks : 0;
        if (this.isSleeping()) {
            this.setXRot(0.0f);
        }
        this.refreshDirtyAttributes();
        this.elytraAnimationState.tick();
        SpigotTimings.timerEntityTickRest.stopTiming();
    }

    public void detectEquipmentUpdatesPublic() {
        Map<EquipmentSlot, ItemStack> map = this.collectEquipmentChanges();
        if (map != null) {
            this.handleHandSwap(map);
            if (!map.isEmpty()) {
                this.handleEquipmentChanges(map);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlot, ItemStack> collectEquipmentChanges() {
        Map map = null;
        for (EquipmentSlot equipmentSlot : EquipmentSlot.VALUES) {
            ItemStack itemstack1;
            ItemStack itemstack = this.lastEquipmentItems.get(equipmentSlot);
            if (!this.equipmentHasChanged(itemstack, itemstack1 = this.getItemBySlot(equipmentSlot))) continue;
            if (map == null) {
                map = Maps.newEnumMap(EquipmentSlot.class);
            }
            map.put(equipmentSlot, itemstack1);
            AttributeMap attributemapbase = this.getAttributes();
            if (itemstack.isEmpty()) continue;
            this.stopLocationBasedEffects(itemstack, equipmentSlot, attributemapbase);
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                EquipmentSlot enumitemslot1 = (EquipmentSlot)entry.getKey();
                ItemStack itemstack2 = (ItemStack)entry.getValue();
                if (itemstack2.isEmpty() || itemstack2.isBroken()) continue;
                itemstack2.forEachModifier(enumitemslot1, (holder, attributemodifier) -> {
                    AttributeInstance attributemodifiable = this.attributes.getInstance((Holder<Attribute>)holder);
                    if (attributemodifiable != null) {
                        attributemodifiable.removeModifier(attributemodifier.id());
                        attributemodifiable.addTransientModifier((AttributeModifier)attributemodifier);
                    }
                });
                Level world = this.level();
                if (!(world instanceof ServerLevel)) continue;
                ServerLevel worldserver = (ServerLevel)world;
                EnchantmentHelper.runLocationChangedEffects(worldserver, itemstack2, this, enumitemslot1);
            }
        }
        return map;
    }

    public boolean equipmentHasChanged(ItemStack itemstack, ItemStack itemstack1) {
        return !ItemStack.matches(itemstack1, itemstack);
    }

    private void handleHandSwap(Map<EquipmentSlot, ItemStack> map) {
        ItemStack itemstack = map.get(EquipmentSlot.MAINHAND);
        ItemStack itemstack1 = map.get(EquipmentSlot.OFFHAND);
        if (itemstack != null && itemstack1 != null && ItemStack.matches(itemstack, this.lastEquipmentItems.get(EquipmentSlot.OFFHAND)) && ItemStack.matches(itemstack1, this.lastEquipmentItems.get(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayers(this, new ClientboundEntityEventPacket(this, 55));
            map.remove(EquipmentSlot.MAINHAND);
            map.remove(EquipmentSlot.OFFHAND);
            this.lastEquipmentItems.put(EquipmentSlot.MAINHAND, itemstack.copy());
            this.lastEquipmentItems.put(EquipmentSlot.OFFHAND, itemstack1.copy());
        }
    }

    private void handleEquipmentChanges(Map<EquipmentSlot, ItemStack> map) {
        ArrayList list = Lists.newArrayListWithCapacity((int)map.size());
        map.forEach((enumitemslot, itemstack) -> {
            ItemStack itemstack1 = itemstack.copy();
            list.add(Pair.of((Object)enumitemslot, (Object)itemstack1));
            this.lastEquipmentItems.put((EquipmentSlot)enumitemslot, itemstack1);
        });
        ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayers(this, new ClientboundSetEquipmentPacket(this.getId(), list));
    }

    protected void tickHeadTurn(float f) {
        float f1 = Mth.wrapDegrees(f - this.yBodyRot);
        this.yBodyRot += f1 * 0.3f;
        float f2 = Mth.wrapDegrees(this.getYRot() - this.yBodyRot);
        float f3 = this.getMaxHeadRotationRelativeToBody();
        if (Math.abs(f2) > f3) {
            this.yBodyRot += f2 - (float)Mth.sign(f2) * f3;
        }
    }

    protected float getMaxHeadRotationRelativeToBody() {
        return 50.0f;
    }

    /*
     * Unable to fully structure code
     */
    public void aiStep() {
        if (this.noJumpDelay > 0) {
            --this.noJumpDelay;
        }
        if (this.isInterpolating()) {
            this.getInterpolation().interpolate();
        } else if (!this.canSimulateMovement()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        }
        if (this.lerpHeadSteps > 0) {
            this.lerpHeadRotationStep(this.lerpHeadSteps, this.lerpYHeadRot);
            --this.lerpHeadSteps;
        }
        this.equipment.tick(this);
        vec3d = this.getDeltaMovement();
        d0 = vec3d.x;
        d1 = vec3d.y;
        d2 = vec3d.z;
        if (this.getType().equals(EntityType.PLAYER)) {
            if (vec3d.horizontalDistanceSqr() < 9.0E-6) {
                d0 = 0.0;
                d2 = 0.0;
            }
        } else {
            if (Math.abs(vec3d.x) < 0.003) {
                d0 = 0.0;
            }
            if (Math.abs(vec3d.z) < 0.003) {
                d2 = 0.0;
            }
        }
        if (Math.abs(vec3d.y) < 0.003) {
            d1 = 0.0;
        }
        this.setDeltaMovement(d0, d1, d2);
        gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("ai");
        SpigotTimings.timerEntityAI.startTiming();
        this.applyInput();
        if (this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        } else if (this.isEffectiveAi() && !this.level().isClientSide()) {
            gameprofilerfiller.push("newAi");
            this.serverAiStep();
            gameprofilerfiller.pop();
        }
        SpigotTimings.timerEntityAI.stopTiming();
        gameprofilerfiller.pop();
        gameprofilerfiller.push("jump");
        if (this.jumping && this.isAffectedByFluids()) {
            d3 = this.isInLava() != false ? this.getFluidHeight(FluidTags.LAVA) : this.getFluidHeight(FluidTags.WATER);
            flag = this.isInWater() != false && d3 > 0.0;
            d4 = this.getFluidJumpThreshold();
            if (!flag || this.onGround() && d3 <= d4) {
                if (!this.isInLava() || this.onGround() && d3 <= d4) {
                    if ((this.onGround() || flag && d3 <= d4) && this.noJumpDelay == 0) {
                        this.jumpFromGround();
                        this.noJumpDelay = 10;
                    }
                } else {
                    this.jumpInLiquid(FluidTags.LAVA);
                }
            } else {
                this.jumpInLiquid(FluidTags.WATER);
            }
        } else {
            this.noJumpDelay = 0;
        }
        gameprofilerfiller.pop();
        gameprofilerfiller.push("travel");
        if (this.isFallFlying()) {
            this.updateFallFlying();
        }
        axisalignedbb = this.getBoundingBox();
        vec3d1 = new Vec3(this.xxa, this.yya, this.zza);
        if (this.hasEffect(MobEffects.SLOW_FALLING) || this.hasEffect(MobEffects.LEVITATION)) {
            this.resetFallDistance();
        }
        SpigotTimings.timerEntityAIMove.startTiming();
        entityliving = this.getControllingPassenger();
        if (!(entityliving instanceof Player)) ** GOTO lbl-1000
        entityhuman = (Player)entityliving;
        if (this.isAlive()) {
            this.travelRidden(entityhuman, vec3d1);
        } else if (this.canSimulateMovement() && this.isEffectiveAi()) {
            this.travel(vec3d1);
        }
        SpigotTimings.timerEntityAIMove.stopTiming();
        if (!this.level().isClientSide() || this.isLocalInstanceAuthoritative()) {
            this.applyEffectsFromBlocks();
        }
        if (this.level().isClientSide()) {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
        gameprofilerfiller.pop();
        world = this.level();
        if (world instanceof ServerLevel) {
            worldserver = (ServerLevel)world;
            gameprofilerfiller.push("freezing");
            if (!this.isInPowderSnow || !this.canFreeze()) {
                this.setTicksFrozen(Math.max(0, this.getTicksFrozen() - 2));
            }
            this.removeFrost();
            this.tryAddFrost();
            if (this.tickCount % 40 == 0 && this.isFullyFrozen() && this.canFreeze()) {
                this.hurtServer(worldserver, this.damageSources().freeze(), 1.0f);
            }
            gameprofilerfiller.pop();
        }
        gameprofilerfiller.push("push");
        if (this.autoSpinAttackTicks > 0) {
            --this.autoSpinAttackTicks;
            this.checkAutoSpinAttack(axisalignedbb, this.getBoundingBox());
        }
        SpigotTimings.timerEntityAICollision.startTiming();
        this.pushEntities();
        SpigotTimings.timerEntityAICollision.stopTiming();
        gameprofilerfiller.pop();
        world = this.level();
        if (world instanceof ServerLevel) {
            worldserver1 = (ServerLevel)world;
            if (this.isSensitiveToWater() && this.isInWaterOrRain()) {
                this.hurtServer(worldserver1, this.damageSources().drown(), 1.0f);
            }
        }
    }

    protected void applyInput() {
        this.xxa *= 0.98f;
        this.zza *= 0.98f;
    }

    public boolean isSensitiveToWater() {
        return false;
    }

    public boolean isJumping() {
        return this.jumping;
    }

    protected void updateFallFlying() {
        this.checkFallDistanceAccumulation();
        if (!this.level().isClientSide()) {
            if (!this.canGlide()) {
                if (this.getSharedFlag(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                    this.setSharedFlag(7, false);
                }
                return;
            }
            int i = this.fallFlyTicks + 1;
            if (i % 10 == 0) {
                int j = i / 10;
                if (j % 2 == 0) {
                    List<EquipmentSlot> list = EquipmentSlot.VALUES.stream().filter(enumitemslot -> LivingEntity.canGlideUsing(this.getItemBySlot((EquipmentSlot)enumitemslot), enumitemslot)).toList();
                    EquipmentSlot enumitemslot2 = Util.getRandom(list, this.random);
                    this.getItemBySlot(enumitemslot2).hurtAndBreak(1, this, enumitemslot2);
                }
                this.gameEvent(GameEvent.ELYTRA_GLIDE);
            }
        }
    }

    protected boolean canGlide() {
        if (!(this.onGround() || this.isPassenger() || this.hasEffect(MobEffects.LEVITATION))) {
            for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                if (!LivingEntity.canGlideUsing(this.getItemBySlot(enumitemslot), enumitemslot)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void serverAiStep() {
    }

    protected void pushEntities() {
        List<Entity> list = this.level().getPushableEntities(this, this.getBoundingBox());
        if (!list.isEmpty()) {
            ServerLevel worldserver;
            int i;
            Level world = this.level();
            if (world instanceof ServerLevel && (i = (worldserver = (ServerLevel)world).getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING)) > 0 && list.size() > i - 1 && this.random.nextInt(4) == 0) {
                int j = 0;
                for (Entity entity : list) {
                    if (entity.isPassenger()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.hurtServer(worldserver, this.damageSources().cramming(), 6.0f);
                }
            }
            for (Entity entity1 : list) {
                this.doPush(entity1);
            }
        }
    }

    protected void checkAutoSpinAttack(AABB axisalignedbb, AABB axisalignedbb1) {
        AABB axisalignedbb2 = axisalignedbb.minmax(axisalignedbb1);
        List<Entity> list = this.level().getEntities(this, axisalignedbb2);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof LivingEntity)) continue;
                this.doAutoAttackOnTouch((LivingEntity)entity);
                this.autoSpinAttackTicks = 0;
                this.setDeltaMovement(this.getDeltaMovement().scale(-0.2));
                break;
            }
        } else if (this.horizontalCollision) {
            this.autoSpinAttackTicks = 0;
        }
        if (!this.level().isClientSide() && this.autoSpinAttackTicks <= 0) {
            this.setLivingEntityFlag(4, false);
            this.autoSpinAttackDmg = 0.0f;
            this.autoSpinAttackItemStack = null;
        }
    }

    protected void doPush(Entity entity) {
        entity.push(this);
    }

    protected void doAutoAttackOnTouch(LivingEntity entityliving) {
    }

    public boolean isAutoSpinAttack() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 4) != 0;
    }

    @Override
    public void stopRiding() {
        Entity entity = this.getVehicle();
        super.stopRiding();
        if (entity != null && entity != this.getVehicle() && !this.level().isClientSide()) {
            this.dismountVehicle(entity);
        }
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.resetFallDistance();
    }

    @Override
    public InterpolationHandler getInterpolation() {
        return this.interpolation;
    }

    @Override
    public void lerpHeadTo(float f, int i) {
        this.lerpYHeadRot = f;
        this.lerpHeadSteps = i;
    }

    public void setJumping(boolean flag) {
        this.jumping = flag;
    }

    public void onItemPickup(ItemEntity entityitem) {
        Entity entity = entityitem.getOwner();
        if (entity instanceof ServerPlayer) {
            CriteriaTriggers.THROWN_ITEM_PICKED_UP_BY_ENTITY.trigger((ServerPlayer)entity, entityitem.getItem(), this);
        }
    }

    public void take(Entity entity, int i) {
        if (!entity.isRemoved() && !this.level().isClientSide() && (entity instanceof ItemEntity || entity instanceof AbstractArrow || entity instanceof ExperienceOrb)) {
            ((ServerLevel)this.level()).getChunkSource().sendToTrackingPlayers(entity, new ClientboundTakeItemEntityPacket(entity.getId(), this.getId(), i));
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        return this.hasLineOfSight(entity, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity.getEyeY());
    }

    public boolean hasLineOfSight(Entity entity, ClipContext.Block raytrace_blockcollisionoption, ClipContext.Fluid raytrace_fluidcollisionoption, double d0) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3d = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec3d1 = new Vec3(entity.getX(), d0, entity.getZ());
        return vec3d1.distanceTo(vec3d) > 128.0 ? false : this.level().clip(new ClipContext(vec3d, vec3d1, raytrace_blockcollisionoption, raytrace_fluidcollisionoption, this)).getType() == HitResult.Type.MISS;
    }

    @Override
    public float getViewYRot(float f) {
        return f == 1.0f ? this.yHeadRot : Mth.rotLerp(f, this.yHeadRotO, this.yHeadRot);
    }

    public float getAttackAnim(float f) {
        float f1 = this.attackAnim - this.oAttackAnim;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.oAttackAnim + f1 * f;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved() && this.collides;
    }

    @Override
    public boolean isPushable() {
        return this.isAlive() && !this.isSpectator() && !this.onClimbable() && this.collides;
    }

    @Override
    public boolean canCollideWithBukkit(Entity entity) {
        return this.isPushable() && this.collides != this.collidableExemptions.contains(entity.getUUID());
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public void setYHeadRot(float f) {
        this.yHeadRot = f;
    }

    @Override
    public void setYBodyRot(float f) {
        this.yBodyRot = f;
    }

    @Override
    public Vec3 getRelativePortalPosition(Direction.Axis enumdirection_enumaxis, BlockUtil.FoundRectangle blockutil_rectangle) {
        return LivingEntity.resetForwardDirectionOfRelativePortalPosition(super.getRelativePortalPosition(enumdirection_enumaxis, blockutil_rectangle));
    }

    public static Vec3 resetForwardDirectionOfRelativePortalPosition(Vec3 vec3d) {
        return new Vec3(vec3d.x, vec3d.y, 0.0);
    }

    public float getAbsorptionAmount() {
        return this.absorptionAmount;
    }

    public final void setAbsorptionAmount(float f) {
        this.internalSetAbsorptionAmount(Mth.clamp(f, 0.0f, this.getMaxAbsorption()));
    }

    protected void internalSetAbsorptionAmount(float f) {
        this.absorptionAmount = f;
    }

    public void onEnterCombat() {
    }

    public void onLeaveCombat() {
    }

    protected void updateEffectVisibility() {
        this.effectsDirty = true;
    }

    public abstract HumanoidArm getMainArm();

    public boolean isUsingItem() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
    }

    public InteractionHand getUsedItemHand() {
        return (this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    private void updatingUsingItem() {
        if (this.isUsingItem()) {
            if (ItemStack.isSameItem(this.getItemInHand(this.getUsedItemHand()), this.useItem)) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                this.updateUsingItem(this.useItem);
            } else {
                this.stopUsingItem();
            }
        }
    }

    @Nullable
    private ItemEntity createItemStackToDrop(ItemStack itemstack, boolean flag, boolean flag1) {
        if (itemstack.isEmpty()) {
            return null;
        }
        double d0 = this.getEyeY() - (double)0.3f;
        ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), d0, this.getZ(), itemstack);
        entityitem.setPickUpDelay(40);
        if (flag1) {
            entityitem.setThrower(this);
        }
        if (flag) {
            float f = this.random.nextFloat() * 0.5f;
            float f1 = this.random.nextFloat() * ((float)Math.PI * 2);
            entityitem.setDeltaMovement(-Mth.sin(f1) * f, 0.2f, Mth.cos(f1) * f);
        } else {
            float f2 = 0.3f;
            float f3 = Mth.sin(this.getXRot() * ((float)Math.PI / 180));
            float f4 = Mth.cos(this.getXRot() * ((float)Math.PI / 180));
            float f5 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float f6 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            float f7 = this.random.nextFloat() * ((float)Math.PI * 2);
            float f8 = 0.02f * this.random.nextFloat();
            entityitem.setDeltaMovement((double)(-f5 * f4 * 0.3f) + Math.cos(f7) * (double)f8, -f3 * 0.3f + 0.1f + (this.random.nextFloat() - this.random.nextFloat()) * 0.1f, (double)(f6 * f4 * 0.3f) + Math.sin(f7) * (double)f8);
        }
        return entityitem;
    }

    protected void updateUsingItem(ItemStack itemstack) {
        itemstack.onUseTick(this.level(), this, this.getUseItemRemainingTicks());
        if (--this.useItemRemaining == 0 && !this.level().isClientSide() && !itemstack.useOnRelease()) {
            this.completeUsingItem();
        }
    }

    private void updateSwimAmount() {
        this.swimAmountO = this.swimAmount;
        this.swimAmount = this.isVisuallySwimming() ? Math.min(1.0f, this.swimAmount + 0.09f) : Math.max(0.0f, this.swimAmount - 0.09f);
    }

    public void setLivingEntityFlag(int i, boolean flag) {
        int j = this.entityData.get(DATA_LIVING_ENTITY_FLAGS).byteValue();
        j = flag ? (j |= i) : (j &= ~i);
        this.entityData.set(DATA_LIVING_ENTITY_FLAGS, (byte)j);
    }

    public void startUsingItem(InteractionHand enumhand) {
        ItemStack itemstack = this.getItemInHand(enumhand);
        if (!itemstack.isEmpty() && !this.isUsingItem()) {
            this.useItem = itemstack;
            this.useItemRemaining = itemstack.getUseDuration(this);
            if (!this.level().isClientSide()) {
                this.setLivingEntityFlag(1, true);
                this.setLivingEntityFlag(2, enumhand == InteractionHand.OFF_HAND);
                this.gameEvent(GameEvent.ITEM_INTERACT_START);
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        super.onSyncedDataUpdated(datawatcherobject);
        if (SLEEPING_POS_ID.equals(datawatcherobject)) {
            if (this.level().isClientSide()) {
                this.getSleepingPos().ifPresent(this::setPosToBed);
            }
        } else if (DATA_LIVING_ENTITY_FLAGS.equals(datawatcherobject) && this.level().isClientSide()) {
            if (this.isUsingItem() && this.useItem.isEmpty()) {
                this.useItem = this.getItemInHand(this.getUsedItemHand());
                if (!this.useItem.isEmpty()) {
                    this.useItemRemaining = this.useItem.getUseDuration(this);
                }
            } else if (!this.isUsingItem() && !this.useItem.isEmpty()) {
                this.useItem = ItemStack.EMPTY;
                this.useItemRemaining = 0;
            }
        }
    }

    @Override
    public void lookAt(EntityAnchorArgument.Anchor argumentanchor_anchor, Vec3 vec3d) {
        super.lookAt(argumentanchor_anchor, vec3d);
        this.yHeadRotO = this.yHeadRot;
        this.yBodyRotO = this.yBodyRot = this.yHeadRot;
    }

    @Override
    public float getPreciseBodyRotation(float f) {
        return Mth.lerp(f, this.yBodyRotO, this.yBodyRot);
    }

    public void spawnItemParticles(ItemStack itemstack, int i) {
        for (int j = 0; j < i; ++j) {
            Vec3 vec3d = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d = vec3d.yRot(-this.getYRot() * ((float)Math.PI / 180));
            double d0 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec3d1 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec3d1 = vec3d1.xRot(-this.getXRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.yRot(-this.getYRot() * ((float)Math.PI / 180));
            vec3d1 = vec3d1.add(this.getX(), this.getEyeY(), this.getZ());
            this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, itemstack), vec3d1.x, vec3d1.y, vec3d1.z, vec3d.x, vec3d.y + 0.05, vec3d.z);
        }
    }

    protected void completeUsingItem() {
        if (!this.level().isClientSide() || this.isUsingItem()) {
            InteractionHand enumhand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(enumhand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                ItemStack itemstack;
                LivingEntity livingEntity = this;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer entityPlayer = (ServerPlayer)livingEntity;
                    org.bukkit.inventory.ItemStack craftItem = CraftItemStack.asBukkitCopy(this.useItem);
                    org.bukkit.inventory.EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                    PlayerItemConsumeEvent event = new PlayerItemConsumeEvent((org.bukkit.entity.Player)this.getBukkitEntity(), craftItem, hand);
                    this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        Consumable consumable = this.useItem.get(DataComponents.CONSUMABLE);
                        if (consumable != null) {
                            consumable.cancelUsingItem(entityPlayer, this.useItem);
                        }
                        entityPlayer.getBukkitEntity().updateInventory();
                        entityPlayer.getBukkitEntity().updateScaledHealth();
                        return;
                    }
                    itemstack = craftItem.equals((Object)event.getItem()) ? this.useItem.finishUsingItem(this.level(), this) : CraftItemStack.asNMSCopy(event.getItem()).finishUsingItem(this.level(), this);
                } else {
                    itemstack = this.useItem.finishUsingItem(this.level(), this);
                }
                if (itemstack != this.useItem) {
                    this.setItemInHand(enumhand, itemstack);
                }
                this.stopUsingItem();
            }
        }
    }

    public void handleExtraItemsCreatedOnUse(ItemStack itemstack) {
    }

    public ItemStack getUseItem() {
        return this.useItem;
    }

    public int getUseItemRemainingTicks() {
        return this.useItemRemaining;
    }

    public int getTicksUsingItem() {
        return this.isUsingItem() ? this.useItem.getUseDuration(this) - this.getUseItemRemainingTicks() : 0;
    }

    public void releaseUsingItem() {
        ItemStack itemstack = this.getItemInHand(this.getUsedItemHand());
        if (!this.useItem.isEmpty() && ItemStack.isSameItem(itemstack, this.useItem)) {
            this.useItem = itemstack;
            this.useItem.releaseUsing(this.level(), this, this.getUseItemRemainingTicks());
            if (this.useItem.useOnRelease()) {
                this.updatingUsingItem();
            }
        }
        this.stopUsingItem();
    }

    public void stopUsingItem() {
        if (!this.level().isClientSide()) {
            boolean flag = this.isUsingItem();
            this.setLivingEntityFlag(1, false);
            if (flag) {
                this.gameEvent(GameEvent.ITEM_INTERACT_FINISH);
            }
        }
        this.useItem = ItemStack.EMPTY;
        this.useItemRemaining = 0;
    }

    public boolean isBlocking() {
        return this.getItemBlockingWith() != null;
    }

    @Nullable
    public ItemStack getItemBlockingWith() {
        int i;
        if (!this.isUsingItem()) {
            return null;
        }
        BlocksAttacks blocksattacks = this.useItem.get(DataComponents.BLOCKS_ATTACKS);
        if (blocksattacks != null && (i = this.useItem.getItem().getUseDuration(this.useItem, this) - this.useItemRemaining) >= blocksattacks.blockDelayTicks()) {
            return this.useItem;
        }
        return null;
    }

    public boolean isSuppressingSlidingDownLadder() {
        return this.isShiftKeyDown();
    }

    public boolean isFallFlying() {
        return this.getSharedFlag(7);
    }

    @Override
    public boolean isVisuallySwimming() {
        return super.isVisuallySwimming() || !this.isFallFlying() && this.hasPose(Pose.FALL_FLYING);
    }

    public int getFallFlyingTicks() {
        return this.fallFlyTicks;
    }

    public boolean randomTeleport(double d0, double d1, double d2, boolean flag) {
        return this.randomTeleport(d0, d1, d2, flag, PlayerTeleportEvent.TeleportCause.UNKNOWN).orElse(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<Boolean> randomTeleport(double d0, double d1, double d2, boolean flag, PlayerTeleportEvent.TeleportCause cause) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getZ();
        double d6 = d1;
        boolean flag1 = false;
        BlockPos blockposition = BlockPos.containing(d0, d1, d2);
        Level world = this.level();
        if (world.hasChunkAt(blockposition)) {
            boolean flag2 = false;
            while (!flag2 && blockposition.getY() > world.getMinY()) {
                BlockPos blockposition1 = blockposition.below();
                BlockState iblockdata = world.getBlockState(blockposition1);
                if (iblockdata.blocksMotion()) {
                    flag2 = true;
                    continue;
                }
                d6 -= 1.0;
                blockposition = blockposition1;
            }
            if (flag2) {
                this.setPos(d0, d6, d2);
                if (world.noCollision(this) && !world.containsAnyLiquid(this.getBoundingBox())) {
                    flag1 = true;
                }
                this.setPos(d3, d4, d5);
                if (flag1) {
                    if (!(this instanceof ServerPlayer)) {
                        EntityTeleportEvent teleport = new EntityTeleportEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)this.level().getWorld(), d3, d4, d5), new Location((World)this.level().getWorld(), d0, d6, d2));
                        this.level().getCraftServer().getPluginManager().callEvent((Event)teleport);
                        if (teleport.isCancelled()) return Optional.empty();
                        Location to = teleport.getTo();
                        this.teleportTo(to.getX(), to.getY(), to.getZ());
                    } else if (!((ServerPlayer)this).connection.teleport(d0, d6, d2, this.getYRot(), this.getXRot(), cause)) {
                        return Optional.empty();
                    }
                }
            }
        }
        if (!flag1) {
            return Optional.of(false);
        }
        if (flag) {
            world.broadcastEntityEvent(this, (byte)46);
        }
        if (!(this instanceof PathfinderMob)) return Optional.of(true);
        PathfinderMob entitycreature = (PathfinderMob)this;
        entitycreature.getNavigation().stop();
        return Optional.of(true);
    }

    public boolean isAffectedByPotions() {
        return !this.isDeadOrDying();
    }

    public boolean attackable() {
        return true;
    }

    public void setRecordPlayingNearby(BlockPos blockposition, boolean flag) {
    }

    public boolean canPickUpLoot() {
        return false;
    }

    @Override
    public final EntityDimensions getDimensions(Pose entitypose) {
        return entitypose == Pose.SLEEPING ? SLEEPING_DIMENSIONS : this.getDefaultDimensions(entitypose).scale(this.getScale());
    }

    protected EntityDimensions getDefaultDimensions(Pose entitypose) {
        return this.getType().getDimensions().scale(this.getAgeScale());
    }

    public ImmutableList<Pose> getDismountPoses() {
        return ImmutableList.of((Object)Pose.STANDING);
    }

    public AABB getLocalBoundsForPose(Pose entitypose) {
        EntityDimensions entitysize = this.getDimensions(entitypose);
        return new AABB(-entitysize.width() / 2.0f, 0.0, -entitysize.width() / 2.0f, entitysize.width() / 2.0f, entitysize.height(), entitysize.width() / 2.0f);
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose entitypose) {
        AABB axisalignedbb = this.getDimensions(entitypose).makeBoundingBox(this.position());
        return this.level().noBlockCollision(this, axisalignedbb);
    }

    @Override
    public boolean canUsePortal(boolean flag) {
        return super.canUsePortal(flag) && !this.isSleeping();
    }

    public Optional<BlockPos> getSleepingPos() {
        return this.entityData.get(SLEEPING_POS_ID);
    }

    public void setSleepingPos(BlockPos blockposition) {
        this.entityData.set(SLEEPING_POS_ID, Optional.of(blockposition));
    }

    public void clearSleepingPos() {
        this.entityData.set(SLEEPING_POS_ID, Optional.empty());
    }

    public boolean isSleeping() {
        return this.getSleepingPos().isPresent();
    }

    public void startSleeping(BlockPos blockposition) {
        BlockState iblockdata;
        if (this.isPassenger()) {
            this.stopRiding();
        }
        if ((iblockdata = this.level().getBlockState(blockposition)).getBlock() instanceof BedBlock) {
            this.level().setBlock(blockposition, (BlockState)iblockdata.setValue(BedBlock.OCCUPIED, true), 3);
        }
        this.setPose(Pose.SLEEPING);
        this.setPosToBed(blockposition);
        this.setSleepingPos(blockposition);
        this.setDeltaMovement(Vec3.ZERO);
        this.hasImpulse = true;
    }

    private void setPosToBed(BlockPos blockposition) {
        this.setPos((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 0.6875, (double)blockposition.getZ() + 0.5);
    }

    private boolean checkBedExists() {
        return this.getSleepingPos().map(blockposition -> this.level().getBlockState((BlockPos)blockposition).getBlock() instanceof BedBlock).orElse(false);
    }

    public void stopSleeping() {
        Optional<BlockPos> optional = this.getSleepingPos();
        Level world = this.level();
        Objects.requireNonNull(world);
        optional.filter(world::hasChunkAt).ifPresent(blockposition -> {
            BlockState iblockdata = this.level().getBlockState((BlockPos)blockposition);
            if (iblockdata.getBlock() instanceof BedBlock) {
                Direction enumdirection = (Direction)iblockdata.getValue(BedBlock.FACING);
                this.level().setBlock((BlockPos)blockposition, (BlockState)iblockdata.setValue(BedBlock.OCCUPIED, false), 3);
                Vec3 vec3d = BedBlock.findStandUpPosition(this.getType(), this.level(), blockposition, enumdirection, this.getYRot()).orElseGet(() -> {
                    BlockPos blockposition1 = blockposition.above();
                    return new Vec3((double)blockposition1.getX() + 0.5, (double)blockposition1.getY() + 0.1, (double)blockposition1.getZ() + 0.5);
                });
                Vec3 vec3d1 = Vec3.atBottomCenterOf(blockposition).subtract(vec3d).normalize();
                float f = (float)Mth.wrapDegrees(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
                this.setPos(vec3d.x, vec3d.y, vec3d.z);
                this.setYRot(f);
                this.setXRot(0.0f);
            }
        });
        Vec3 vec3d = this.position();
        this.setPose(Pose.STANDING);
        this.setPos(vec3d.x, vec3d.y, vec3d.z);
        this.clearSleepingPos();
    }

    @Nullable
    public Direction getBedOrientation() {
        BlockPos blockposition = this.getSleepingPos().orElse(null);
        return blockposition != null ? BedBlock.getBedOrientation(this.level(), blockposition) : null;
    }

    @Override
    public boolean isInWall() {
        return !this.isSleeping() && super.isInWall();
    }

    public ItemStack getProjectile(ItemStack itemstack) {
        return ItemStack.EMPTY;
    }

    private static byte entityEventForEquipmentBreak(EquipmentSlot enumitemslot) {
        return switch (enumitemslot) {
            case EquipmentSlot.MAINHAND -> 47;
            case EquipmentSlot.OFFHAND -> 48;
            case EquipmentSlot.HEAD -> 49;
            case EquipmentSlot.CHEST -> 50;
            case EquipmentSlot.FEET -> 52;
            case EquipmentSlot.LEGS -> 51;
            case EquipmentSlot.BODY -> 65;
            case EquipmentSlot.SADDLE -> 68;
            default -> throw new MatchException(null, null);
        };
    }

    public void onEquippedItemBroken(net.minecraft.world.item.Item item, EquipmentSlot enumitemslot) {
        this.level().broadcastEntityEvent(this, LivingEntity.entityEventForEquipmentBreak(enumitemslot));
        this.stopLocationBasedEffects(this.getItemBySlot(enumitemslot), enumitemslot, this.attributes);
    }

    private void stopLocationBasedEffects(ItemStack itemstack, EquipmentSlot enumitemslot, AttributeMap attributemapbase) {
        itemstack.forEachModifier(enumitemslot, (holder, attributemodifier) -> {
            AttributeInstance attributemodifiable = attributemapbase.getInstance((Holder<Attribute>)holder);
            if (attributemodifiable != null) {
                attributemodifiable.removeModifier((AttributeModifier)attributemodifier);
            }
        });
        EnchantmentHelper.stopLocationBasedEffects(itemstack, this, enumitemslot);
    }

    public final boolean canEquipWithDispenser(ItemStack itemstack) {
        if (this.isAlive() && !this.isSpectator()) {
            Equippable equippable = itemstack.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.dispensable()) {
                EquipmentSlot enumitemslot = equippable.slot();
                return this.canUseSlot(enumitemslot) && equippable.canBeEquippedBy(this.getType()) ? this.getItemBySlot(enumitemslot).isEmpty() && this.canDispenserEquipIntoSlot(enumitemslot) : false;
            }
            return false;
        }
        return false;
    }

    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return true;
    }

    public final EquipmentSlot getEquipmentSlotForItem(ItemStack itemstack) {
        Equippable equippable = itemstack.get(DataComponents.EQUIPPABLE);
        return equippable != null && this.canUseSlot(equippable.slot()) ? equippable.slot() : EquipmentSlot.MAINHAND;
    }

    public final boolean isEquippableInSlot(ItemStack itemstack, EquipmentSlot enumitemslot) {
        Equippable equippable = itemstack.get(DataComponents.EQUIPPABLE);
        return equippable == null ? enumitemslot == EquipmentSlot.MAINHAND && this.canUseSlot(EquipmentSlot.MAINHAND) : enumitemslot == equippable.slot() && this.canUseSlot(equippable.slot()) && equippable.canBeEquippedBy(this.getType());
    }

    private static SlotAccess createEquipmentSlotAccess(LivingEntity entityliving, EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.HEAD && enumitemslot != EquipmentSlot.MAINHAND && enumitemslot != EquipmentSlot.OFFHAND ? SlotAccess.forEquipmentSlot(entityliving, enumitemslot, itemstack -> itemstack.isEmpty() || entityliving.getEquipmentSlotForItem((ItemStack)itemstack) == enumitemslot) : SlotAccess.forEquipmentSlot(entityliving, enumitemslot);
    }

    @Nullable
    private static EquipmentSlot getEquipmentSlot(int i) {
        return i == 100 + EquipmentSlot.HEAD.getIndex() ? EquipmentSlot.HEAD : (i == 100 + EquipmentSlot.CHEST.getIndex() ? EquipmentSlot.CHEST : (i == 100 + EquipmentSlot.LEGS.getIndex() ? EquipmentSlot.LEGS : (i == 100 + EquipmentSlot.FEET.getIndex() ? EquipmentSlot.FEET : (i == 98 ? EquipmentSlot.MAINHAND : (i == 99 ? EquipmentSlot.OFFHAND : (i == 105 ? EquipmentSlot.BODY : (i == 106 ? EquipmentSlot.SADDLE : null)))))));
    }

    @Override
    public SlotAccess getSlot(int i) {
        EquipmentSlot enumitemslot = LivingEntity.getEquipmentSlot(i);
        return enumitemslot != null ? LivingEntity.createEquipmentSlotAccess(this, enumitemslot) : super.getSlot(i);
    }

    @Override
    public boolean canFreeze() {
        if (this.isSpectator()) {
            return false;
        }
        for (EquipmentSlot enumitemslot : EquipmentSlotGroup.ARMOR) {
            if (!this.getItemBySlot(enumitemslot).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) continue;
            return false;
        }
        return super.canFreeze();
    }

    @Override
    public boolean isCurrentlyGlowing() {
        return !this.level().isClientSide() && this.hasEffect(MobEffects.GLOWING) || super.isCurrentlyGlowing();
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.yBodyRot;
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        double d0 = packetplayoutspawnentity.getX();
        double d1 = packetplayoutspawnentity.getY();
        double d2 = packetplayoutspawnentity.getZ();
        float f = packetplayoutspawnentity.getYRot();
        float f1 = packetplayoutspawnentity.getXRot();
        this.syncPacketPositionCodec(d0, d1, d2);
        this.yBodyRot = packetplayoutspawnentity.getYHeadRot();
        this.yHeadRot = packetplayoutspawnentity.getYHeadRot();
        this.yBodyRotO = this.yBodyRot;
        this.yHeadRotO = this.yHeadRot;
        this.setId(packetplayoutspawnentity.getId());
        this.setUUID(packetplayoutspawnentity.getUUID());
        this.absSnapTo(d0, d1, d2, f, f1);
        this.setDeltaMovement(packetplayoutspawnentity.getMovement());
    }

    public float getSecondsToDisableBlocking() {
        Weapon weapon = this.getWeaponItem().get(DataComponents.WEAPON);
        return weapon != null ? weapon.disableBlockingForSeconds() : 0.0f;
    }

    @Override
    public float maxUpStep() {
        float f = (float)this.getAttributeValue(Attributes.STEP_HEIGHT);
        return this.getControllingPassenger() instanceof Player ? Math.max(f, 1.0f) : f;
    }

    @Override
    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position().add(this.getPassengerAttachmentPoint(entity, this.getDimensions(this.getPose()), this.getScale() * this.getAgeScale()));
    }

    protected void lerpHeadRotationStep(int i, double d0) {
        this.yHeadRot = (float)Mth.rotLerp(1.0 / (double)i, (double)this.yHeadRot, d0);
    }

    @Override
    public void igniteForTicks(int i) {
        super.igniteForTicks(Mth.ceil((double)i * this.getAttributeValue(Attributes.BURNING_TIME)));
    }

    public boolean hasInfiniteMaterials() {
        return false;
    }

    public boolean isInvulnerableTo(ServerLevel worldserver, DamageSource damagesource) {
        return this.isInvulnerableToBase(damagesource) || EnchantmentHelper.isImmuneToDamage(worldserver, this, damagesource);
    }

    public static boolean canGlideUsing(ItemStack itemstack, EquipmentSlot enumitemslot) {
        if (!itemstack.has(DataComponents.GLIDER)) {
            return false;
        }
        Equippable equippable = itemstack.get(DataComponents.EQUIPPABLE);
        return equippable != null && enumitemslot == equippable.slot() && !itemstack.nextDamageWillBreak();
    }

    @VisibleForTesting
    public int getLastHurtByPlayerMemoryTime() {
        return this.lastHurtByPlayerMemoryTime;
    }

    @Override
    public boolean isTransmittingWaypoint() {
        return this.getAttributeValue(Attributes.WAYPOINT_TRANSMIT_RANGE) > 0.0;
    }

    @Override
    public Optional<WaypointTransmitter.Connection> makeWaypointConnectionWith(ServerPlayer entityplayer) {
        if (!this.firstTick && entityplayer != this) {
            if (WaypointTransmitter.doesSourceIgnoreReceiver(this, entityplayer)) {
                return Optional.empty();
            }
            Waypoint.Icon waypoint_a = this.locatorBarIcon.cloneAndAssignStyle(this);
            return WaypointTransmitter.isReallyFar(this, entityplayer) ? Optional.of(new WaypointTransmitter.EntityAzimuthConnection(this, waypoint_a, entityplayer)) : (!WaypointTransmitter.isChunkVisible(this.chunkPosition(), entityplayer) ? Optional.of(new WaypointTransmitter.EntityChunkConnection(this, waypoint_a, entityplayer)) : Optional.of(new WaypointTransmitter.EntityBlockConnection(this, waypoint_a, entityplayer)));
        }
        return Optional.empty();
    }

    @Override
    public Waypoint.Icon waypointIcon() {
        return this.locatorBarIcon;
    }

    private static class ProcessableEffect {
        private Holder<MobEffect> type;
        private MobEffectInstance effect;
        private final EntityPotionEffectEvent.Cause cause;

        private ProcessableEffect(MobEffectInstance effect, EntityPotionEffectEvent.Cause cause) {
            this.effect = effect;
            this.cause = cause;
        }

        private ProcessableEffect(Holder<MobEffect> type, EntityPotionEffectEvent.Cause cause) {
            this.type = type;
            this.cause = cause;
        }
    }

    public record Fallsounds(SoundEvent small, SoundEvent big) {
    }
}

